/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.examples.server.HttpClientExamplesServerKt;
import com.intellij.httpClient.examples.server.WebSocketRepeatMessage;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/examples/server/WebSocketClientHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "disconnected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "getMessageServer", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/WebSocketClientHandler\n+ 2 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServerKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,611:1\n430#2,2:612\n433#2,2:616\n56#3:614\n49#3:615\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/WebSocketClientHandler\n*L\n88#1:612,2\n88#1:616,2\n88#1:614\n88#1:615\n*E\n"})
final class WebSocketClientHandler
extends WebSocketHandshakeHandler {
    @NotNull
    private final ObjectMapper mapper = ExtensionsKt.registerKotlinModule$default((ObjectMapper)new ObjectMapper(), null, (int)1, null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (!super.isSupported(request2)) return false;
        String string = request2.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples/ws", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return super.isAccessible(request2) && HttpClientExampleServerManager.Companion.getInstance().isRequestScheduled();
    }

    public void disconnected(@NotNull Client client2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
    }

    @NotNull
    protected MessageServer getMessageServer() {
        return (arg_0, arg_1) -> WebSocketClientHandler.getMessageServer$lambda$2(this, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMessageServer$lambda$2(WebSocketClientHandler this$0, Client client2, CharSequence message2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!(client2 instanceof WebSocketClient)) {
            return;
        }
        ObjectMapper objectMapper = this$0.mapper;
        CharSequence json$iv = message2;
        boolean $i$f$fromJson = false;
        try {
            void $this$readValue$iv$iv;
            void $this$fromJson$iv;
            void var7_7 = $this$fromJson$iv;
            String content$iv$iv = ((Object)json$iv).toString();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            object = $this$readValue$iv$iv.readValue(content$iv$iv, (TypeReference)new TypeReference<WebSocketRepeatMessage>(){});
        }
        catch (JacksonException e$iv) {
            JacksonException it = e$iv;
            boolean bl = false;
            HttpClientExamplesServerKt.access$send((WebSocketClient)client2, "{\"error\": \"malformed JSON\"}");
            return;
        }
        WebSocketRepeatMessage webSocketRepeatMessage = (WebSocketRepeatMessage)object;
        String messageToRepeat = webSocketRepeatMessage.component1();
        Integer repeat = webSocketRepeatMessage.component2();
        char[] cArray = new char[]{'\n', '\\', '\"'};
        String string = StringUtil.escapeChars((String)messageToRepeat, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
        String escapedMessage = string;
        Integer n = repeat;
        int n2 = n != null ? n : 1;
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl = false;
            HttpClientExamplesServerKt.access$send((WebSocketClient)client2, "{\"message\": \"" + escapedMessage + "\"}");
        }
    }
}

