/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.examples.server.HttpClientExamplesServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/examples/server/HttpClientExamplesServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "handlers", "", "getHandlers", "()Ljava/util/List;", "handlers$delegate", "Lkotlin/Lazy;", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,611:1\n1747#2,3:612\n288#2,2:615\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServer\n*L\n54#1:612,3\n66#1:615,2\n*E\n"})
public final class HttpClientExamplesServer
extends HttpRequestHandler {
    @NotNull
    private final Lazy handlers$delegate = LazyKt.lazy((Function0)handlers.2.INSTANCE);

    private final List<HttpRequestHandler> getHandlers() {
        Lazy lazy = this.handlers$delegate;
        return (List)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request2) {
        HttpRequestHandler it;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        String string = request2.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.getHandlers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (HttpRequestHandler)element$iv;
            boolean bl = false;
        } while (!it.isSupported(request2));
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return super.isAccessible(request2) && HttpClientExampleServerManager.Companion.getInstance().isRequestScheduled();
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$firstOrNull$iv = this.getHandlers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpRequestHandler it = (HttpRequestHandler)element$iv;
                boolean bl = false;
                if (!it.isSupported(request2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HttpRequestHandler httpRequestHandler = v0;
        if (httpRequestHandler == null) {
            return false;
        }
        HttpRequestHandler handler = httpRequestHandler;
        return handler.process(urlDecoder, request2, context);
    }
}

