/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.legacy;

import com.intellij.core.CoreBundle;
import com.intellij.httpClient.actions.HttpRequestActionUtils;
import com.intellij.httpClient.converters.legacy.LegacyRestClientFileToNewAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientSerializer;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\rH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/converters/legacy/LegacyRestClientRequestFromExternalFilesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "toNlsString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nLegacyRestClientRequestFromExternalFilesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyRestClientRequestFromExternalFilesAction.kt\ncom/intellij/httpClient/converters/legacy/LegacyRestClientRequestFromExternalFilesAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class LegacyRestClientRequestFromExternalFilesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getData(CommonDataKeys.EDITOR) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        block7: {
            block6: {
                Project project;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                object = e.getProject();
                if (object == null) break block6;
                Project it = project = object;
                boolean bl = false;
                object = !it.isDefault() ? project : null;
                if (object != null) break block7;
            }
            return;
        }
        Project project = object;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor3.getDocument());
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            if (!it.isWritable()) {
                HttpRequestActionUtils.notifyAboutFail(e, RestClientBundle.message("legacy.cannot.convert.message.begin", new Object[0]) + "\n" + CoreBundle.message((String)"editing.read.only.file.hint", (Object[])new Object[0]), HttpClientDataKeys.CONVERT_FROM_HYPERLINK_LABEL);
                return;
            }
        }
        String[] stringArray = new String[]{".xml"};
        FileTypeDescriptor descriptor = new FileTypeDescriptor(RestClientBundle.message("dialog.title.select.xml.file.with.rest.client.request", new Object[0]), stringArray);
        FileChooser.chooseFiles((FileChooserDescriptor)((FileChooserDescriptor)descriptor), (Project)project, null, (VirtualFile)ProjectUtil.guessProjectDir((Project)project), arg_0 -> LegacyRestClientRequestFromExternalFilesAction.actionPerformed$lambda$4(editor3, project, e, this, arg_0));
    }

    @NlsSafe
    private final String toNlsString(StringBuilder $this$toNlsString) {
        String string = $this$toNlsString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void actionPerformed$lambda$4$lambda$2(Editor $editor, StringBuilder $result) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $editor.getDocument().insertString(0, (CharSequence)$result.toString());
    }

    private static final void actionPerformed$lambda$4$lambda$3(AnActionEvent $e, LegacyRestClientRequestFromExternalFilesAction this$0, StringBuilder $errors) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$errors, (String)"$errors");
        StringBuilder stringBuilder = $errors.insert(0, RestClientBundle.message("legacy.cannot.convert.message.begin", new Object[0]) + "\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"insert(...)");
        HttpRequestActionUtils.notifyAboutFail($e, this$0.toNlsString(stringBuilder), HttpClientDataKeys.CONVERT_FROM_HYPERLINK_LABEL);
    }

    private static final void actionPerformed$lambda$4(Editor $editor, Project $project, AnActionEvent $e, LegacyRestClientRequestFromExternalFilesAction this$0, List files) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        StringBuilder errors2 = new StringBuilder();
        StringBuilder result2 = new StringBuilder();
        for (VirtualFile file : files) {
            try {
                Intrinsics.checkNotNull((Object)file);
                String request2 = LegacyRestClientFileToNewAction.Manager.INSTANCE.convertFileToPsiRequest(file);
                result2.append(request2);
            }
            catch (RestClientSerializer.RestClientSerializationException e) {
                StringBuilder stringBuilder = errors2.append(file.getPresentableUrl()).append(" : ");
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                stringBuilder.append(string);
            }
        }
        if (((CharSequence)result2).length() > 0) {
            $editor.getSelectionModel().removeSelection();
            $editor.getCaretModel().moveToOffset(0);
            WriteCommandAction.writeCommandAction((Project)$project).withName(RestClientBundle.message("rest.clien.ui.deprecation.convert.action", new Object[0])).run(() -> LegacyRestClientRequestFromExternalFilesAction.actionPerformed$lambda$4$lambda$2($editor, result2));
        }
        if (((CharSequence)errors2).length() > 0) {
            ApplicationManager.getApplication().invokeLater(() -> LegacyRestClientRequestFromExternalFilesAction.actionPerformed$lambda$4$lambda$3($e, this$0, errors2));
        }
    }
}

