/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.legacy;

import com.intellij.httpClient.actions.AddHttpRequestAction;
import com.intellij.httpClient.converters.legacy.LegacyRestClientFileToNewAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientSerializer;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0007H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiRequest", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getName", "attempt", "", "getNonexistentFileName", "directory", "Lcom/intellij/psi/PsiDirectory;", "saveFile", "update", "e", "Manager", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nLegacyRestClientFileToNewAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyRestClientFileToNewAction.kt\ncom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,116:1\n179#2,2:117\n*S KotlinDebug\n*F\n+ 1 LegacyRestClientFileToNewAction.kt\ncom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction\n*L\n78#1:117,2\n*E\n"})
public final class LegacyRestClientFileToNewAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setEnabledAndVisible(Manager.INSTANCE.isSingleRestClientRequest(files));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file == null) {
            return;
        }
        try {
            this.saveFile(file);
            String psiRequest = Manager.INSTANCE.convertFileToPsiRequest(file);
            PsiFile psiFile = this.createFile(project, file, psiRequest);
            if (psiFile == null) {
                return;
            }
            PsiFile newFile = psiFile;
            VirtualFile virtualFile = newFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            OpenFileAction.Companion.openFile(virtualFile, project);
        }
        catch (RestClientSerializer.RestClientSerializationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            AddHttpRequestAction.showErrorBalloon(event, string);
        }
    }

    private final void saveFile(VirtualFile file) {
        block0: {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager documentManager = fileDocumentManager;
            Document document = documentManager.getDocument(file);
            if (document == null) break block0;
            Document it = document;
            boolean bl = false;
            documentManager.saveDocument(it);
        }
    }

    private final PsiFile createFile(Project project, VirtualFile file, String psiRequest) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiFile psiFile = psiManager2.findFile(file);
        if (psiFile == null || (psiFile = psiFile.getParent()) == null) {
            return null;
        }
        PsiFile directory = psiFile;
        String string = this.getNonexistentFileName(file, (PsiDirectory)directory);
        if (string == null) {
            return null;
        }
        String fileName = string;
        return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("rest.clien.ui.deprecation.convert.action", new Object[0])).compute(() -> LegacyRestClientFileToNewAction.createFile$lambda$1((PsiDirectory)directory, fileName, project, psiRequest));
    }

    private final String getNonexistentFileName(VirtualFile file, PsiDirectory directory) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)0, (Function1)getNonexistentFileName.1.INSTANCE), (int)100), (Function1)((Function1)new Function1<Integer, String>(this, file){
                final /* synthetic */ LegacyRestClientFileToNewAction this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(1);
                }

                @NotNull
                public final String invoke(int it) {
                    return LegacyRestClientFileToNewAction.access$getName(this.this$0, this.$file, it);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(directory.findFile(it) == null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getName(VirtualFile file, int attempt) {
        String string = PathUtil.makeFileName((String)(file.getNameWithoutExtension() + (String)(attempt == 0 ? "" : "-" + attempt)), (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"makeFileName(...)");
        return string;
    }

    private static final PsiFile createFile$lambda$1(PsiDirectory $directory, String $fileName, Project $project, String $psiRequest) {
        PsiFile resultFile2;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$directory, (String)"$directory");
            Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$psiRequest, (String)"$psiRequest");
            PsiFile psiFile = $directory.createFile($fileName);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFile(...)");
            resultFile2 = psiFile;
            Document document = PsiDocumentManager.getInstance((Project)$project).getDocument(resultFile2);
            if (document == null) break block0;
            document.insertString(0, (CharSequence)$psiRequest);
        }
        return resultFile2;
    }

    public static final /* synthetic */ String access$getName(LegacyRestClientFileToNewAction $this, VirtualFile file, int attempt) {
        return $this.getName(file, attempt);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction$Manager;", "", "()V", "convertFileToPsiRequest", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSingleRestClientRequest", "", "files", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Z", "intellij.restClient"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final boolean isSingleRestClientRequest(@Nullable VirtualFile[] files) {
            boolean bl;
            if (files == null || files.length != 1) {
                return false;
            }
            VirtualFile file = files[0];
            if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
                return false;
            }
            try {
                XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeaderWithException((VirtualFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)xmlFileHeader, (String)"parseHeaderWithException(...)");
                XmlFileHeader header2 = xmlFileHeader;
                bl = Intrinsics.areEqual((Object)"RestClientRequest", (Object)header2.getRootTagLocalName());
            }
            catch (IOException e) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String convertFileToPsiRequest(@NotNull VirtualFile file) throws RestClientSerializer.RestClientSerializationException {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            StringBuilder $this$convertFileToPsiRequest_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$convertFileToPsiRequest_u24lambda_u240.append("# ");
            $this$convertFileToPsiRequest_u24lambda_u240.append(file.getPresentableUrl());
            $this$convertFileToPsiRequest_u24lambda_u240.append("\n");
            try {
                $this$convertFileToPsiRequest_u24lambda_u240.append(HttpRequestPsiConverter.toPsiHttpRequest(RestClientSerializer.loadFromFile(file), null, true));
            }
            catch (ClassCastException e) {
                throw new RestClientSerializer.RestClientSerializationException(RestClientBundle.message("rest.client.ui.xml.file.unknown.error", new Object[0]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

