/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.httpClient.converters.curl.CurlRequestBuilderKt;
import com.intellij.httpClient.converters.curl.CurlRequestFormBody;
import com.intellij.httpClient.converters.curl.CurlRequestMessageBody;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody;", "", "()V", "appendData", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "contentType", "", "MultipartBody", "SingleDataBody", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$MultipartBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody;", "intellij.restClient"})
abstract class CurlRequestMessageBody {
    private CurlRequestMessageBody() {
    }

    public abstract void appendData(@NotNull StringBuilder var1, @Nullable String var2);

    public /* synthetic */ CurlRequestMessageBody(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u0007*\u00060\bj\u0002`\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$MultipartBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody;", "parts", "", "Lcom/intellij/httpClient/converters/curl/CurlRequestFormBody;", "(Ljava/util/List;)V", "appendData", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "contentType", "", "intellij.restClient"})
    public static final class MultipartBody
    extends CurlRequestMessageBody {
        @NotNull
        private final List<CurlRequestFormBody> parts;

        public MultipartBody(@NotNull List<? extends CurlRequestFormBody> parts) {
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            super(null);
            this.parts = parts;
        }

        @Override
        public void appendData(@NotNull StringBuilder $this$appendData, @Nullable String contentType2) {
            Intrinsics.checkNotNullParameter((Object)$this$appendData, (String)"<this>");
            for (CurlRequestFormBody part : this.parts) {
                CurlRequestBuilderKt.access$lineSeparator($this$appendData);
                $this$appendData.append("-F \"");
                $this$appendData.append(part.getName$intellij_restClient());
                $this$appendData.append("=");
                CurlRequestFormBody $this$appendData_u24lambda_u240 = part;
                boolean bl = false;
                $this$appendData_u24lambda_u240.appendPartValue$intellij_restClient($this$appendData);
                $this$appendData.append(";");
                $this$appendData.append("type=");
                $this$appendData.append(part.getContentType$intellij_restClient().getMimeType());
                $this$appendData.append("\"");
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H$J\u0018\u0010\u0007\u001a\u00020\b*\u00060\tj\u0002`\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody;", "()V", "getBody", "", "contentType", "option", "appendData", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ExactBody", "FileBody", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody$ExactBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody$FileBody;", "intellij.restClient"})
    public static abstract class SingleDataBody
    extends CurlRequestMessageBody {
        private SingleDataBody() {
            super(null);
        }

        @Override
        public final void appendData(@NotNull StringBuilder $this$appendData, @Nullable String contentType2) {
            Intrinsics.checkNotNullParameter((Object)$this$appendData, (String)"<this>");
            CurlRequestBuilderKt.access$lineSeparator($this$appendData);
            $this$appendData.append("-d");
            $this$appendData.append(this.getBody(contentType2, "-d"));
        }

        @NotNull
        protected abstract String getBody(@Nullable String var1, @NotNull String var2);

        public /* synthetic */ SingleDataBody(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u001a\u0010\b\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody$ExactBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody;", "data", "", "(Ljava/lang/String;)V", "addIndents", "contentType", "option", "getBody", "intellij.restClient"})
        public static final class ExactBody
        extends SingleDataBody {
            @NotNull
            private final String data;

            public ExactBody(@NotNull String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super(null);
                this.data = data;
            }

            @Override
            @NotNull
            protected String getBody(@Nullable String contentType2, @NotNull String option) {
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                String body2 = this.addIndents(contentType2, option);
                StringsKt.replace$default((String)body2, (String)"'", (String)"'\\''", (boolean)false, (int)4, null);
                String escapedBody = StringsKt.replace$default((String)body2, (String)"'", (String)"'\\''", (boolean)false, (int)4, null);
                return " '" + escapedBody + "'";
            }

            private final String addIndents(String contentType2, String option) {
                if (contentType2 == null) {
                    return this.data;
                }
                int identSize = option.length() + 1 + CurlRequestBuilderKt.access$getINDENT$p();
                if (StringsKt.endsWith$default((String)contentType2, (String)"+json", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)contentType2, (Object)"application/json")) {
                    return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)this.data), (CharSequence)("\n" + StringsKt.repeat((CharSequence)" ", (int)identSize)), null, null, (int)0, null, (Function1)addIndents.1.INSTANCE, (int)30, null);
                }
                return this.data;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody$FileBody;", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody$SingleDataBody;", "filePath", "", "(Ljava/lang/String;)V", "getBody", "contentType", "option", "intellij.restClient"})
        public static final class FileBody
        extends SingleDataBody {
            @NotNull
            private final String filePath;

            public FileBody(@NotNull String filePath2) {
                Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
                super(null);
                this.filePath = filePath2;
            }

            @Override
            @NotNull
            protected String getBody(@Nullable String contentType2, @NotNull String option) {
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                return " @" + this.filePath;
            }
        }
    }
}

