/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters;

import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.psi.impl.HttpRequestContentDescriptorImpl;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RequestBuilder<T, R extends RequestFormBodyPart> {
    default public void withUrl(@NotNull String url) {
        if (url == null) {
            RequestBuilder.$$$reportNull$$$0(0);
        }
    }

    default public void withMethod(@NotNull String method) {
        if (method == null) {
            RequestBuilder.$$$reportNull$$$0(1);
        }
    }

    default public void withProtocol(@NotNull HttpProtocol protocol) {
        if (protocol == null) {
            RequestBuilder.$$$reportNull$$$0(2);
        }
    }

    default public <E extends Throwable> void withQueryParameters(@NotNull ThrowableConsumer<QueryBuilder, E> queryInitializer) throws E {
        if (queryInitializer == null) {
            RequestBuilder.$$$reportNull$$$0(3);
        }
    }

    default public void withAuthData(@NotNull HttpClientAuthData data) {
        if (data == null) {
            RequestBuilder.$$$reportNull$$$0(4);
        }
    }

    default public void withHeader(@NotNull String name, @NotNull String value2, @NotNull @RequiresReadLock Function<String, @Nullable String> optionProvider) throws HttpRequestValidationException {
        if (name == null) {
            RequestBuilder.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            RequestBuilder.$$$reportNull$$$0(6);
        }
        if (optionProvider == null) {
            RequestBuilder.$$$reportNull$$$0(7);
        }
    }

    default public void withFileToSend(@NotNull File file) {
        if (file == null) {
            RequestBuilder.$$$reportNull$$$0(8);
        }
    }

    default public void withTextToSend(@NotNull String text2) {
        if (text2 == null) {
            RequestBuilder.$$$reportNull$$$0(9);
        }
    }

    default public <E extends Throwable> void withMultipartBody(@Nullable String multipartBoundary, ThrowableConsumer<? super MultipartBodyBuilder<R>, E> multipartInitializer) throws E {
    }

    default public void withConfig(@NotNull HttpRequestConfig config) {
        if (config == null) {
            RequestBuilder.$$$reportNull$$$0(10);
        }
    }

    default public void withEmptyCredentials() {
    }

    default public void withSslConfiguration(@Nullable SslConfiguration sslConfiguration) {
    }

    default public void withUserDefinedOutputFilePath(@NotNull String filePath2, boolean isForce) {
        if (filePath2 == null) {
            RequestBuilder.$$$reportNull$$$0(11);
        }
    }

    public T build();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryInitializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/converters/RequestBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withProtocol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withQueryParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withAuthData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withHeader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "withFileToSend";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "withTextToSend";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "withConfig";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "withUserDefinedOutputFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record ContentTypeInfo(@Nullable String contentTypeHeader, @Nullable String fallbackMimeType, @Nullable String acceptCharsetHeader) {
        public ContentTypeInfo(@Nullable String contentTypeHeader, @Nullable String acceptCharsetHeader) {
            this(contentTypeHeader, null, acceptCharsetHeader);
        }

        @NotNull
        public String contentTypeHeaderNotNull() {
            String string = StringUtil.notNullize((String)this.contentTypeHeader, (String)"*/*");
            if (string == null) {
                ContentTypeInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String acceptCharsetHeaderNotNull() {
            String string = StringUtil.notNullize((String)this.acceptCharsetHeader, (String)"UTF-8");
            if (string == null) {
                ContentTypeInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getMimeType() {
            String[] mimeTypeAndEtc;
            if (this.contentTypeHeader != null && HttpRequestContentDescriptorImpl.isValidMimeType((mimeTypeAndEtc = this.contentTypeHeader.split(";", 2))[0])) {
                String string = mimeTypeAndEtc[0];
                if (string == null) {
                    ContentTypeInfo.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.fallbackMimeType != null) {
                String string = this.fallbackMimeType;
                if (string == null) {
                    ContentTypeInfo.$$$reportNull$$$0(3);
                }
                return string;
            }
            return "*/*";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/httpClient/converters/RequestBuilder$ContentTypeInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contentTypeHeaderNotNull";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acceptCharsetHeaderNotNull";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMimeType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum HttpProtocol {
        HTTP_11,
        HTTP_2,
        HTTP_2_PRIOR_KNOWLEDGE;

    }

    public static interface RequestFormBodyPart {
        public RequestFormBodyPart addHeader(@NotNull String var1, @Nullable String var2);
    }

    public static interface MultipartBodyBuilder<T> {
        public T createPartForFile(@NotNull String var1, @NotNull String var2, @NotNull File var3, @NotNull ContentTypeInfo var4);

        public T createPartForString(@NotNull String var1, @NotNull String var2, @NotNull ContentTypeInfo var3);

        public void addFormBodyPart(@NotNull T var1);
    }

    public static interface QueryBuilder {
        public void addQueryParameter(@NotNull String var1, @NotNull String var2);
    }
}

