/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfoError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlQueryParameters;
import com.intellij.httpClient.actions.generation.RequestBody;
import com.intellij.httpClient.actions.generation.UrlChecker;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0007J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "", "url", "", "methods", "", "(Ljava/lang/String;Ljava/util/Collection;)V", "heavyBuildingOperation", "Lkotlin/Function1;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "getMethods", "()Ljava/util/Collection;", "getUrl", "()Ljava/lang/String;", "applyOnRequestGeneration", "heavyUrlInfoBuilder", "compute", "equals", "", "other", "hashCode", "", "toString", "validated", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfoError;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "Computed", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestGenerationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n3190#2,10:347\n*S KotlinDebug\n*F\n+ 1 HttpRequestGenerationUtil.kt\ncom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo\n*L\n241#1:347,10\n*E\n"})
public class HttpRequestUrlPathInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Collection<String> methods;
    @NotNull
    private Function1<? super HttpRequestUrlPathInfo, Computed> heavyBuildingOperation;

    private HttpRequestUrlPathInfo(String url, Collection<String> methods2) {
        this.url = url;
        this.methods = methods2;
        this.heavyBuildingOperation = heavyBuildingOperation.1.INSTANCE;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final Collection<String> getMethods() {
        return this.methods;
    }

    private final HttpRequestUrlPathInfo applyOnRequestGeneration(Function1<? super HttpRequestUrlPathInfo, Computed> heavyUrlInfoBuilder) {
        this.heavyBuildingOperation = heavyUrlInfoBuilder;
        return this;
    }

    private final PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> validated(Project project) {
        String validUrl = new UrlMappingBuilder("/").appendSegment(this.url).build();
        Collection<String> supportedMethods = RequestExecutionSupport.All.allSupportedMethods(project);
        Iterable $this$partition$iv = this.methods;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (supportedMethods.contains(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List validMethods = (List)pair.component1();
        List invalidMethods = (List)pair.component2();
        if (validMethods.isEmpty()) {
            return new PartialResult.Error<HttpRequestUrlPathInfoError.Methods>(new HttpRequestUrlPathInfoError.Methods(invalidMethods));
        }
        if (!UrlChecker.isValidRequest$default(UrlChecker.INSTANCE, project, new UrlMappingBuilder("/").appendSegment(this.url).build(), null, 4, null)) {
            return new PartialResult.Error<HttpRequestUrlPathInfoError.Url>(new HttpRequestUrlPathInfoError.Url(this.url));
        }
        HttpRequestUrlPathInfo validInfo = new HttpRequestUrlPathInfo(validUrl, CollectionsKt.toSet((Iterable)validMethods)).applyOnRequestGeneration(this.heavyBuildingOperation);
        return invalidMethods.isEmpty() ? (PartialResult)new PartialResult.Success<HttpRequestUrlPathInfo>(validInfo) : (PartialResult)new PartialResult.PartialSuccess<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError.Methods>(validInfo, new HttpRequestUrlPathInfoError.Methods(invalidMethods));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @NotNull
    public final Computed compute() {
        return (Computed)this.heavyBuildingOperation.invoke((Object)this);
    }

    @NotNull
    public String toString() {
        return "HttpRequestUrlPathInfo(url='" + this.url + "', methods=" + this.methods + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo");
        HttpRequestUrlPathInfo cfr_ignored_0 = (HttpRequestUrlPathInfo)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)((HttpRequestUrlPathInfo)other).url)) {
            return false;
        }
        return Intrinsics.areEqual(this.methods, ((HttpRequestUrlPathInfo)other).methods);
    }

    public int hashCode() {
        int result2 = this.url.hashCode();
        result2 = 31 * result2 + ((Object)this.methods).hashCode();
        return result2;
    }

    public /* synthetic */ HttpRequestUrlPathInfo(String url, Collection methods2, DefaultConstructorMarker $constructor_marker) {
        this(url, methods2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Companion;", "", "()V", "create", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfoError;", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "methods", "", "applyOnRequestGeneration", "Lkotlin/Function1;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PartialResult<HttpRequestUrlPathInfo, HttpRequestUrlPathInfoError> create(@NotNull Project project, @NotNull String url, @NotNull Collection<String> methods2, @NotNull Function1<? super HttpRequestUrlPathInfo, Computed> applyOnRequestGeneration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(methods2, (String)"methods");
            Intrinsics.checkNotNullParameter(applyOnRequestGeneration, (String)"applyOnRequestGeneration");
            return new HttpRequestUrlPathInfo(url, methods2, null).applyOnRequestGeneration((Function1<? super HttpRequestUrlPathInfo, Computed>)applyOnRequestGeneration).validated(project);
        }

        public static /* synthetic */ PartialResult create$default(Companion companion, Project project, String string, Collection collection, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = create.1.INSTANCE;
            }
            return companion.create(project, string, collection, (Function1<? super HttpRequestUrlPathInfo, Computed>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011*\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019*\u0004\b\u0017\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;", "", "baseInfo", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "queryParameters", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;", "requestBody", "Lcom/intellij/httpClient/actions/generation/RequestBody;", "(Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;Lcom/intellij/httpClient/actions/generation/RequestBody;)V", "getBaseInfo", "()Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo;", "methods", "", "", "getMethods$delegate", "(Lcom/intellij/httpClient/actions/generation/HttpRequestUrlPathInfo$Computed;)Ljava/lang/Object;", "getMethods", "()Ljava/util/Collection;", "getQueryParameters", "()Lcom/intellij/httpClient/actions/generation/HttpRequestUrlQueryParameters;", "getRequestBody", "()Lcom/intellij/httpClient/actions/generation/RequestBody;", "url", "getUrl$delegate", "getUrl", "()Ljava/lang/String;", "intellij.restClient"})
    public static final class Computed {
        @NotNull
        private final HttpRequestUrlPathInfo baseInfo;
        @NotNull
        private final HttpRequestUrlQueryParameters queryParameters;
        @NotNull
        private final RequestBody requestBody;

        public Computed(@NotNull HttpRequestUrlPathInfo baseInfo, @NotNull HttpRequestUrlQueryParameters queryParameters, @NotNull RequestBody requestBody) {
            Intrinsics.checkNotNullParameter((Object)baseInfo, (String)"baseInfo");
            Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
            Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
            this.baseInfo = baseInfo;
            this.queryParameters = queryParameters;
            this.requestBody = requestBody;
        }

        public /* synthetic */ Computed(HttpRequestUrlPathInfo httpRequestUrlPathInfo, HttpRequestUrlQueryParameters httpRequestUrlQueryParameters, RequestBody requestBody, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                httpRequestUrlQueryParameters = HttpRequestUrlQueryParameters.Empty.INSTANCE;
            }
            if ((n & 4) != 0) {
                requestBody = RequestBody.Empty.INSTANCE;
            }
            this(httpRequestUrlPathInfo, httpRequestUrlQueryParameters, requestBody);
        }

        @NotNull
        public final HttpRequestUrlPathInfo getBaseInfo() {
            return this.baseInfo;
        }

        @NotNull
        public final HttpRequestUrlQueryParameters getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        public final RequestBody getRequestBody() {
            return this.requestBody;
        }

        @NotNull
        public final String getUrl() {
            return this.baseInfo.getUrl();
        }

        private static Object getUrl$delegate(Computed computed) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)computed.baseInfo, HttpRequestUrlPathInfo.class, "url", "getUrl()Ljava/lang/String;", 0)));
        }

        @NotNull
        public final Collection<String> getMethods() {
            return this.baseInfo.getMethods();
        }

        private static Object getMethods$delegate(Computed computed) {
            return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)computed.baseInfo, HttpRequestUrlPathInfo.class, "methods", "getMethods()Ljava/util/Collection;", 0)));
        }
    }
}

