/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.notification.HttpClientNotificationPanelV2Kt;
import com.intellij.httpClient.http.request.run.RunHttpRequestAction;
import com.intellij.httpClient.http.request.run.config.HttpRequestFileExecutionConfig;
import com.intellij.httpClient.http.request.run.statistics.HttpClientExecutionUsageCollector;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestRunFileAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(0);
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        if (project != null && file instanceof HttpRequestPsiFile) {
            HttpClientExecutionUsageCollector.RUN_REQUEST_ACTION_EVENT_ID.log(project, (Object)HttpClientExecutionUsageCollector.RunRequestType.RUN_ALL, (Object)HttpClientExecutionUsageCollector.RunRequestPlace.REGULAR_EDITOR);
            if (Boolean.TRUE.equals(e.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2))) {
                String env = HttpClientSelectedEnvironments.getInstance(project).get(file.getVirtualFile());
                if (HttpClientSelectedEnvironments.isSelectBeforeRun(env)) {
                    HttpRequestRunFileAction.showEnvironmentsPopup(project, e, (HttpRequestPsiFile)file);
                    return;
                }
                HttpRequestFileExecutionConfig config = new HttpRequestFileExecutionConfig((HttpRequestPsiFile)file);
                if (env != null) {
                    new RunHttpRequestAction.RunRequestWithEnvAction(config, env, null).actionPerformed(e);
                } else {
                    new RunHttpRequestAction.RunRequestWithoutEnvAction(config, null).actionPerformed(e);
                }
                return;
            }
            HttpRequestRunFileAction.showEnvironmentsPopup(project, e, (HttpRequestPsiFile)file);
        }
    }

    private static void showEnvironmentsPopup(@NotNull Project project, final @NotNull AnActionEvent event, @NotNull HttpRequestPsiFile containingFile) {
        if (project == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(3);
        }
        String title = RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]);
        Pair<Map<String, AnAction>, String> actionsAndFirstEnvAction = HttpRequestRunFileAction.getActionsForPopup(project, containingFile);
        final Map actions2 = (Map)actionsAndFirstEnvAction.getFirst();
        if (actions2.size() == 1) {
            AnAction action2 = (AnAction)((Map.Entry)ContainerUtil.getFirstItem(actions2.entrySet())).getValue();
            action2.actionPerformed(event);
            return;
        }
        final String firstEnvAction = (String)actionsAndFirstEnvAction.getSecond();
        ListPopup runActionsPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, new ArrayList(actions2.keySet())){

            @Nullable
            public ListSeparator getSeparatorAbove(String value2) {
                if (firstEnvAction != null && firstEnvAction.equals(value2)) {
                    return new ListSeparator();
                }
                return null;
            }

            public PopupStep onChosen(String requestName, boolean finalChoice) {
                return this.doFinalStep(() -> ((AnAction)actions2.get(requestName)).actionPerformed(event));
            }
        });
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event.getDataContext().getData(HttpClientDataKeys.RUN_ALL_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            runActionsPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else if (Boolean.TRUE.equals(event.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2))) {
            runActionsPopup.showUnderneathOf(event.getInputEvent().getComponent());
        } else {
            runActionsPopup.showInBestPositionFor(event.getDataContext());
        }
    }

    @NotNull
    private static Pair<Map<String, AnAction>, String> getActionsForPopup(@NotNull Project project, @NotNull HttpRequestPsiFile containingFile) {
        if (project == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(4);
        }
        if (containingFile == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(5);
        }
        HttpRequestEnvironment.clearDefaultIfInvalid(project, (PsiFile)containingFile);
        HttpRequestFileExecutionConfig config = new HttpRequestFileExecutionConfig(containingFile);
        String actionName = DefaultRunExecutor.getRunExecutorInstance().getActionName();
        ArrayList<String> envs2 = new ArrayList<String>(HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments((PsiFile)containingFile).asListOfNames());
        LinkedHashMap<String, RunHttpRequestAction> actions2 = new LinkedHashMap<String, RunHttpRequestAction>();
        if (!envs2.isEmpty()) {
            actions2.put(RestClientBundle.message("rest.client.request.execute.with.default.environment", actionName), new RunHttpRequestAction.RunRequestWithDefaultEnvAction(config, null));
        }
        actions2.put(RestClientBundle.message("rest.client.request.execute.with.no.environment", actionName), new RunHttpRequestAction.RunRequestWithoutEnvAction(config, null));
        Collections.sort(envs2);
        for (String env : envs2) {
            actions2.put(RestClientBundle.message("rest.client.request.execute.with.environment", actionName, env), new RunHttpRequestAction.RunRequestWithEnvAction(config, env, null));
        }
        String firstEnvAction = !envs2.isEmpty() ? RestClientBundle.message("rest.client.request.execute.with.environment", actionName, ContainerUtil.getFirstItem(envs2)) : null;
        Pair pair = Pair.create(actions2, firstEnvAction);
        if (pair == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(6);
        }
        return pair;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(7);
        }
        e.getPresentation().setEnabledAndVisible(e.getData(CommonDataKeys.PSI_FILE) instanceof HttpRequestPsiFile && e.getProject() != null);
        if (Boolean.TRUE.equals(e.getData(HttpClientNotificationPanelV2Kt.HTTP_CLIENT_IS_TOOLBAR_V2))) {
            e.getPresentation().setIcon(AllIcons.Actions.RunAll);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(8);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/HttpRequestRunFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/HttpRequestRunFileAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsForPopup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showEnvironmentsPopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionsForPopup";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

