/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PowerService;
import com.intellij.util.io.PowerStatus;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/io/LinuxPowerService;", "Lcom/intellij/util/io/PowerService;", "()V", "classDirectory", "Ljava/io/File;", "read", "", "device", "key", "status", "Lcom/intellij/util/io/PowerStatus;", "intellij.platform.ide.util.io"})
@SourceDebugExtension(value={"SMAP\nPowerStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerStatus.kt\ncom/intellij/util/io/LinuxPowerService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
final class LinuxPowerService
implements PowerService {
    @NotNull
    private final File classDirectory = new File("/sys/class/power_supply");

    public LinuxPowerService() {
        if (!this.classDirectory.isDirectory()) {
            throw new IOException("not a directory: " + this.classDirectory);
        }
    }

    @Override
    @NotNull
    public PowerStatus status() {
        File[] fileArray = this.classDirectory.listFiles();
        if (fileArray == null) {
            throw new IOException("can't enumerate devices");
        }
        File[] devices = fileArray;
        if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
            PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug("devices=" + devices.length);
        }
        boolean online = false;
        boolean discharging = false;
        for (File device : devices) {
            String state;
            Intrinsics.checkNotNull((Object)device);
            String type = this.read(device, "type");
            if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
                PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug(device.getName() + " type=" + type);
            }
            if (Intrinsics.areEqual((Object)type, (Object)"Mains")) {
                state = this.read(device, "online");
                if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
                    PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug("  online=" + state);
                }
                if (!Intrinsics.areEqual((Object)state, (Object)"1")) continue;
                online = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"Battery")) continue;
            state = this.read(device, "status");
            if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
                PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug("  status=" + state);
            }
            if (!Intrinsics.areEqual((Object)state, (Object)"Discharging")) continue;
            discharging = true;
        }
        return online ? PowerStatus.AC : (discharging ? PowerStatus.BATTERY : PowerStatus.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String read(File device, String key) {
        String string;
        try {
            String string2;
            Closeable closeable = new BufferedReader(new FileReader(new File(device, key)));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                string2 = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
            Intrinsics.checkNotNull((Object)string);
        }
        catch (IOException iOException) {
            string = "-";
        }
        return string;
    }
}

