/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.nextjs.references;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.JSXmlAttributePathUtil;
import com.intellij.lang.javascript.frameworks.html.JSStaticDirectoriesFileReferenceHelperKt;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceContext;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSFileReferenceContext;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J5\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/frameworks/nextjs/references/NextJsPathReferenceProvider;", "Lcom/intellij/openapi/paths/PathReferenceProviderBase;", "()V", "createReferences", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "", "references", "", "Lcom/intellij/psi/PsiReference;", "soft", "getPathReference", "Lcom/intellij/openapi/paths/PathReference;", "path", "element", "jsReferences", "", "isSoft", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;IZ)[Lcom/intellij/psi/PsiReference;", "intellij.nextjs"})
public final class NextJsPathReferenceProvider
extends PathReferenceProviderBase {
    public boolean createReferences(@NotNull PsiElement psiElement, int offset, @Nullable String text, @NotNull List<? super PsiReference> references, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        if (!(psiElement instanceof XmlAttributeValue) || text == null) {
            return true;
        }
        if (!DialectDetector.isJSX((PsiElement)psiElement) || !StringsKt.startsWith$default((String)text, (String)"/", (boolean)false, (int)2, null)) {
            return true;
        }
        references.addAll(0, ArraysKt.toList((Object[])this.jsReferences(text, psiElement, offset, soft)));
        return true;
    }

    private final PsiReference[] jsReferences(String text, PsiElement psiElement, int offset, boolean isSoft) {
        JSDefaultFileReferenceContext context2 = new JSDefaultFileReferenceContext(text, psiElement, isSoft){
            final /* synthetic */ PsiElement $psiElement;
            final /* synthetic */ boolean $isSoft;
            {
                this.$psiElement = $psiElement;
                this.$isSoft = $isSoft;
                super($text, $psiElement, null);
            }

            @NotNull
            public Collection<VirtualFile> getDefaultRoots(@NotNull Project project, @NotNull String moduleName, @NotNull VirtualFile contextFile) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
                Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
                Collection collection = super.getDefaultRoots(project, moduleName, contextFile);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDefaultRoots(...)");
                Collection defaultContexts = collection;
                PsiFile psiFile = this.myContext.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null) {
                    return defaultContexts;
                }
                PsiFile file = psiFile;
                Collection items = JSStaticDirectoriesFileReferenceHelperKt.getFixedVirtualFiles$default((PsiFileSystemItem)((PsiFileSystemItem)file), (Collection)JSXmlAttributePathUtil.additionalRoots((PsiElement)this.$psiElement), (boolean)false, (int)4, null);
                if (items.isEmpty()) {
                    return defaultContexts;
                }
                return CollectionsKt.plus((Collection)items, (Iterable)CollectionsKt.toSet((Iterable)defaultContexts));
            }

            public boolean isSoft() {
                return this.$isSoft;
            }
        };
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(text, (JSFileReferenceContext)context2, psiElement, offset).getAllReferences();
        Intrinsics.checkNotNullExpressionValue((Object)fileReferenceArray, (String)"getAllReferences(...)");
        return (PsiReference[])fileReferenceArray;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof XmlAttributeValue)) {
            return null;
        }
        PsiElement psiElement = ((XmlAttributeValue)element).getParent();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (object == null) {
            return null;
        }
        PsiElement parent = object;
        if (!(parent instanceof XmlTag) || !DialectDetector.isJSX((PsiElement)parent)) {
            return null;
        }
        Object[] jsReferences2 = this.jsReferences(path, element, 0, true);
        if (jsReferences2.length == 0) {
            return null;
        }
        PsiElement psiElement2 = ((PsiReference)ArraysKt.last((Object[])jsReferences2)).resolve();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement resolve = psiElement2;
        PathReference.ResolveFunction resolveFunction = new PathReference.ResolveFunction(null);
        return new PathReference(path, resolve, resolveFunction){
            final /* synthetic */ PsiElement $resolve;
            {
                this.$resolve = $resolve;
                super($path, (Function)$super_call_param$1);
            }

            @NotNull
            public PsiElement resolve() {
                return this.$resolve;
            }
        };
    }
}

