/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.fortea.psi.T4FileElementTypes;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\n0\rj\b\u0012\u0004\u0012\u00020\n`\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\rj\b\u0012\u0004\u0012\u00020\n`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/fortea/psi/T4FileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiManager;ZLcom/intellij/lang/Language;)V", "languages", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "getBaseLanguage", "getLanguages", "getTemplateDataLanguage", "Lcom/jetbrains/rider/languages/fileTypes/csharp/CSharpLanguage;", "intellij.rider.plugins.for.tea"})
public final class T4FileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language language;
    @NotNull
    private final HashSet<Language> languages;

    public T4FileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        super(manager, file, physical);
        this.language = language;
        Object[] objectArray = new Language[]{this.language, CSharpLanguage.INSTANCE};
        this.languages = SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public Language getBaseLanguage() {
        return this.language;
    }

    @NotNull
    public HashSet<Language> getLanguages() {
        return this.languages;
    }

    @NotNull
    protected T4FileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new T4FileViewProvider(fileCopy, (PsiManager)psiManagerEx, false, this.language);
    }

    @NotNull
    public CSharpLanguage getTemplateDataLanguage() {
        return CSharpLanguage.INSTANCE;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (Intrinsics.areEqual((Object)lang, (Object)CSharpLanguage.INSTANCE)) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            PsiFile psiFile = ((ParserDefinition)object).createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl file = (PsiFileImpl)psiFile;
            file.setContentElementType((IElementType)T4FileElementTypes.INSTANCE.getT4_CODE_DATA());
            return (PsiFile)file;
        }
        if (lang == this.getBaseLanguage()) {
            Object object = LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            Intrinsics.checkNotNull((Object)object);
            return ((ParserDefinition)object).createFile((FileViewProvider)this);
        }
        return null;
    }
}

