/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.EditorHighlighterUpdater;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.fortea.highlighting.T4SyntaxHighlighter;
import com.jetbrains.fortea.highlighting.T4SyntaxHighlightingHost;
import com.jetbrains.fortea.psi.T4ElementTypes;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.document.DocumentExKt;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpFileType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/fortea/highlighting/T4EditorSyntaxHighlighter;", "Lcom/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "colors", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "highlighterLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "rawTextLayerExtension", "", "registerLayers", "", "subscribeToOutputExtensionUpdates", "Companion", "intellij.rider.plugins.for.tea"})
public final class T4EditorSyntaxHighlighter
extends LayeredLexerEditorHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final LifetimeDefinition highlighterLifetime;
    @Nullable
    private final String rawTextLayerExtension;
    @NotNull
    private static final Key<String> OUTPUT_EXTENSION_KEY = new Key("OUTPUT_EXTENSION_KEY");

    public T4EditorSyntaxHighlighter(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        super((SyntaxHighlighter)T4SyntaxHighlighter.INSTANCE, colors);
        this.project = project;
        this.virtualFile = virtualFile;
        this.highlighterLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.rawTextLayerExtension = T4EditorSyntaxHighlighter.Companion.getT4OutputExtension(this.virtualFile);
        this.registerLayers();
        this.subscribeToOutputExtensionUpdates();
    }

    private final void registerLayers() {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)((FileType)CSharpFileType.INSTANCE), (Project)this.project, (VirtualFile)this.virtualFile);
        Intrinsics.checkNotNull((Object)syntaxHighlighter);
        SyntaxHighlighter codeHighlighter = syntaxHighlighter;
        this.registerLayer(T4ElementTypes.RAW_CODE, new LayerDescriptor(codeHighlighter, ""));
        if (this.rawTextLayerExtension == null) {
            return;
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName("dummy." + this.rawTextLayerExtension);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType rawTextFileType = fileType;
        SyntaxHighlighter syntaxHighlighter2 = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)rawTextFileType, (Project)this.project, (VirtualFile)this.virtualFile);
        if (syntaxHighlighter2 == null) {
            return;
        }
        SyntaxHighlighter rawTextHighlighter = syntaxHighlighter2;
        this.registerLayer(T4ElementTypes.RAW_TEXT, new LayerDescriptor(rawTextHighlighter, "\n"));
    }

    private final void subscribeToOutputExtensionUpdates() {
        block2: {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                return;
            }
            Document document2 = document;
            Editor editor = DocumentExKt.getFirstEditor((Document)document2, (Project)this.project);
            if (!(editor instanceof EditorEx)) {
                return;
            }
            Disposable highlighterDisposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.highlighterLifetime.getLifetime(), null, (int)1, null);
            IProperty<String> iProperty = T4SyntaxHighlightingHost.Companion.getT4RdDocumentModel(document2, this.project);
            if (iProperty == null || (iProperty = iProperty.getRawTextExtension()) == null) break block2;
            iProperty.advise((Lifetime)this.highlighterLifetime, (Function1)new Function1<String, Unit>(this, highlighterDisposable, editor){
                final /* synthetic */ T4EditorSyntaxHighlighter this$0;
                final /* synthetic */ Disposable $highlighterDisposable;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$highlighterDisposable = $highlighterDisposable;
                    this.$editor = $editor;
                    super(1);
                }

                public final void invoke(@Nullable String extension) {
                    if (Intrinsics.areEqual((Object)extension, (Object)T4EditorSyntaxHighlighter.access$getRawTextLayerExtension$p(this.this$0))) {
                        return;
                    }
                    com.jetbrains.fortea.highlighting.T4EditorSyntaxHighlighter$Companion.access$setT4OutputExtension(T4EditorSyntaxHighlighter.Companion, T4EditorSyntaxHighlighter.access$getVirtualFile$p(this.this$0), extension);
                    EditorHighlighterUpdater updater = new EditorHighlighterUpdater(T4EditorSyntaxHighlighter.access$getProject$p(this.this$0), this.$highlighterDisposable, (EditorEx)this.$editor, T4EditorSyntaxHighlighter.access$getVirtualFile$p(this.this$0));
                    updater.updateHighlighters();
                    T4EditorSyntaxHighlighter.access$getHighlighterLifetime$p(this.this$0).terminate(true);
                }
            });
        }
    }

    public static final /* synthetic */ String access$getRawTextLayerExtension$p(T4EditorSyntaxHighlighter $this) {
        return $this.rawTextLayerExtension;
    }

    public static final /* synthetic */ VirtualFile access$getVirtualFile$p(T4EditorSyntaxHighlighter $this) {
        return $this.virtualFile;
    }

    public static final /* synthetic */ Project access$getProject$p(T4EditorSyntaxHighlighter $this) {
        return $this.project;
    }

    public static final /* synthetic */ LifetimeDefinition access$getHighlighterLifetime$p(T4EditorSyntaxHighlighter $this) {
        return $this.highlighterLifetime;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u0004\u0018\u00010\u0005*\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/fortea/highlighting/T4EditorSyntaxHighlighter$Companion;", "", "()V", "OUTPUT_EXTENSION_KEY", "Lcom/intellij/openapi/util/Key;", "", "value", "t4OutputExtension", "Lcom/intellij/openapi/vfs/VirtualFile;", "getT4OutputExtension", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "setT4OutputExtension", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "intellij.rider.plugins.for.tea"})
    public static final class Companion {
        private Companion() {
        }

        private final String getT4OutputExtension(VirtualFile $this$t4OutputExtension) {
            return (String)$this$t4OutputExtension.getUserData(OUTPUT_EXTENSION_KEY);
        }

        private final void setT4OutputExtension(VirtualFile $this$t4OutputExtension, String value) {
            $this$t4OutputExtension.putUserData(OUTPUT_EXTENSION_KEY, (Object)value);
        }

        public static final /* synthetic */ void access$setT4OutputExtension(Companion $this, VirtualFile $receiver, String value) {
            $this.setT4OutputExtension($receiver, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

