/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fortea.configuration.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.fortea.configuration.T4BuildSessionView;
import com.jetbrains.fortea.configuration.T4BuildToolWindowFactory;
import com.jetbrains.fortea.configuration.T4ProtocolModelExtensionsKt;
import com.jetbrains.fortea.model.T4BuildMessage;
import com.jetbrains.fortea.model.T4BuildMessageKind;
import com.jetbrains.fortea.model.T4BuildResult;
import com.jetbrains.fortea.model.T4PreprocessingResult;
import com.jetbrains.fortea.utils.RiderT4Bundle;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rider.build.diagnostics.BuildDiagnostic;
import com.jetbrains.rider.build.diagnostics.DiagnosticKind;
import com.jetbrains.rider.build.ui.old.BuildToolWindowContext;
import com.jetbrains.rider.model.BuildEventBase;
import com.jetbrains.rider.model.BuildMessageKind;
import com.jetbrains.rider.model.BuildResultKind;
import com.jetbrains.rider.model.MessageBuildEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/fortea/configuration/impl/T4BuildSessionViewImpl;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "Lcom/jetbrains/fortea/configuration/T4BuildSessionView;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "initializeContext", "Lcom/jetbrains/rider/build/ui/old/BuildToolWindowContext;", "windowHeader", "", "openWindow", "", "message", "showMessages", "result", "Lcom/jetbrains/fortea/model/T4BuildResult;", "file", "context", "showT4BuildResult", "showT4PreprocessingResult", "Lcom/jetbrains/fortea/model/T4PreprocessingResult;", "toBuildDiagnostic", "Lcom/jetbrains/rider/build/diagnostics/BuildDiagnostic;", "Lcom/jetbrains/fortea/model/T4BuildMessage;", "toDiagnosticKind", "Lcom/jetbrains/rider/build/diagnostics/DiagnosticKind;", "kind", "Lcom/jetbrains/fortea/model/T4BuildMessageKind;", "Companion", "intellij.rider.plugins.for.tea"})
@SourceDebugExtension(value={"SMAP\nT4BuildSessionViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 T4BuildSessionViewImpl.kt\ncom/jetbrains/fortea/configuration/impl/T4BuildSessionViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,87:1\n1549#2:88\n1620#2,3:89\n1855#2,2:92\n1549#2:96\n1620#2,3:97\n1855#2,2:100\n31#3,2:94\n*S KotlinDebug\n*F\n+ 1 T4BuildSessionViewImpl.kt\ncom/jetbrains/fortea/configuration/impl/T4BuildSessionViewImpl\n*L\n52#1:88\n52#1:89,3\n54#1:92,2\n44#1:96\n44#1:97,3\n44#1:100,2\n57#1:94,2\n*E\n"})
public final class T4BuildSessionViewImpl
extends LifetimedService
implements T4BuildSessionView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String ExecutingT4BuildHeader = RiderT4Bundle.Companion.message("status.executing.t4.build", new Object[0]);
    @NotNull
    private static final String PreprocessingT4Header = RiderT4Bundle.Companion.message("status.preprocessing.t4", new Object[0]);
    @NotNull
    private static final String T4BuildHeader = RiderT4Bundle.Companion.message("status.t4.build", new Object[0]);
    @NotNull
    private static final String T4PreprocessingHeader = RiderT4Bundle.Companion.message("status.t4.preprocessing", new Object[0]);

    public T4BuildSessionViewImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void openWindow(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ApplicationKt.getApplication().invokeLater(() -> T4BuildSessionViewImpl.openWindow$lambda$0(this, message));
    }

    @Override
    public void showT4BuildResult(@NotNull T4BuildResult result, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationKt.getApplication().invokeLater(() -> T4BuildSessionViewImpl.showT4BuildResult$lambda$1(this, result, file));
    }

    @Override
    public void showT4PreprocessingResult(@NotNull T4PreprocessingResult result, @NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ApplicationKt.getApplication().invokeLater(() -> T4BuildSessionViewImpl.showT4PreprocessingResult$lambda$3(this, result, file));
    }

    /*
     * WARNING - void declaration
     */
    private final void showMessages(T4BuildResult result, String file, BuildToolWindowContext context) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = result.getMessages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            T4BuildMessage t4BuildMessage = (T4BuildMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toBuildDiagnostic((T4BuildMessage)it, file));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildDiagnostic p0 = (BuildDiagnostic)element$iv;
            boolean bl = false;
            context.addBuildEvent(p0);
        }
    }

    private final BuildToolWindowContext initializeContext(String windowHeader) {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<T4BuildToolWindowFactory> serviceClass$iv = T4BuildToolWindowFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildToolWindowContext context = ((T4BuildToolWindowFactory)((Object)object)).getOrCreateContext(windowHeader);
        if (!context.isActive()) {
            context.showToolWindowIfHidden(true);
        }
        return context;
    }

    private final BuildDiagnostic toBuildDiagnostic(T4BuildMessage message, String file) {
        DiagnosticKind kind = this.toDiagnosticKind(message.getBuildMessageKind());
        int line = message.getLocation().getLine() + 1;
        int column = message.getLocation().getColumn() + 1;
        CharSequence charSequence = message.getFile();
        String filePath = !(charSequence == null || charSequence.length() == 0) ? message.getFile() : file;
        return new BuildDiagnostic(kind, message.getContent(), message.getId(), Integer.valueOf(message.getProjectId()), null, filePath, Integer.valueOf(line), Integer.valueOf(column));
    }

    private final DiagnosticKind toDiagnosticKind(T4BuildMessageKind kind) {
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1 -> DiagnosticKind.Error;
            case 2 -> DiagnosticKind.Warning;
            case 3 -> DiagnosticKind.Warning;
            case 4 -> DiagnosticKind.Warning;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void openWindow$lambda$0(T4BuildSessionViewImpl this$0, String $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        BuildToolWindowContext context = this$0.initializeContext(ExecutingT4BuildHeader);
        context.clear();
        context.showToolWindowIfHidden(true);
        MessageBuildEvent buildEvent = new MessageBuildEvent(null, BuildMessageKind.Message, $message);
        context.addOutputMessage((BuildEventBase)buildEvent, (IMutableViewableMap)new ViewableMap(null, 1, null));
        context.invalidatePanelMode();
    }

    private static final void showT4BuildResult$lambda$1(T4BuildSessionViewImpl this$0, T4BuildResult $result, String $file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        BuildToolWindowContext context = this$0.initializeContext(ExecutingT4BuildHeader);
        context.updateStatus(T4ProtocolModelExtensionsKt.getToBuildResultKind($result.getBuildResultKind()), T4BuildHeader);
        this$0.showMessages($result, $file, context);
        context.invalidatePanelMode();
    }

    /*
     * WARNING - void declaration
     */
    private static final void showT4PreprocessingResult$lambda$3(T4BuildSessionViewImpl this$0, T4PreprocessingResult $result, String $file) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        BuildToolWindowContext context = this$0.initializeContext(PreprocessingT4Header);
        BuildResultKind succeeded = $result.getSucceeded() ? BuildResultKind.Successful : BuildResultKind.HasErrors;
        context.updateStatus(succeeded, T4PreprocessingHeader);
        Iterable $this$map$iv = $result.getMessage();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            T4BuildMessage t4BuildMessage = (T4BuildMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.toBuildDiagnostic((T4BuildMessage)it, $file));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildDiagnostic p0 = (BuildDiagnostic)element$iv;
            boolean bl = false;
            context.addBuildEvent(p0);
        }
        context.invalidatePanelMode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/fortea/configuration/impl/T4BuildSessionViewImpl$Companion;", "", "()V", "ExecutingT4BuildHeader", "", "getExecutingT4BuildHeader", "()Ljava/lang/String;", "PreprocessingT4Header", "getPreprocessingT4Header", "T4BuildHeader", "getT4BuildHeader", "T4PreprocessingHeader", "getT4PreprocessingHeader", "intellij.rider.plugins.for.tea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getExecutingT4BuildHeader() {
            return ExecutingT4BuildHeader;
        }

        @NotNull
        public final String getPreprocessingT4Header() {
            return PreprocessingT4Header;
        }

        @NotNull
        public final String getT4BuildHeader() {
            return T4BuildHeader;
        }

        @NotNull
        public final String getT4PreprocessingHeader() {
            return T4PreprocessingHeader;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[T4BuildMessageKind.values().length];
            try {
                nArray[T4BuildMessageKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[T4BuildMessageKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[T4BuildMessageKind.Message.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[T4BuildMessageKind.Success.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

