/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.platform.lvcs.impl.ActivityDiffData;
import com.intellij.platform.lvcs.impl.ActivityFileChange;
import com.intellij.platform.lvcs.impl.settings.ActivityViewApplicationSettings;
import com.intellij.platform.lvcs.impl.ui.ActivityChangesBrowser;
import com.intellij.platform.lvcs.impl.ui.ActivityChangesBrowserKt;
import com.intellij.platform.lvcs.impl.ui.ActivityViewDataKeys;
import com.intellij.platform.lvcs.impl.ui.LinkNode;
import com.intellij.platform.lvcs.impl.ui.PresentableChangeNode;
import com.intellij.platform.lvcs.impl.ui.PresentableDirectoryChangeNode;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.Side;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0017\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u001aJ\r\u0010\u001b\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010#\u001a\u00020$*\u00020%2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/ActivityChangesBrowser;", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesBrowserBase;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "isSwitchingDiffModeAllowed", "", "(Lcom/intellij/openapi/project/Project;Z)V", "changesTreeModel", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "getChangesTreeModel", "()Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "diffData", "Lcom/intellij/platform/lvcs/impl/ActivityDiffData;", "createPopupMenuActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "createToolbarActions", "dispose", "", "getDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "userObject", "", "loadingFinished", "data", "loadingFinished$intellij_platform_lvcs_impl", "loadingStarted", "loadingStarted$intellij_platform_lvcs_impl", "switchDiffMode", "activityDiffData", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "updateEmptyText", "buildTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nActivityChangesBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityChangesBrowser.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityChangesBrowser\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,146:1\n40#2,3:147\n*S KotlinDebug\n*F\n+ 1 ActivityChangesBrowser.kt\ncom/intellij/platform/lvcs/impl/ui/ActivityChangesBrowser\n*L\n80#1:147,3\n*E\n"})
public final class ActivityChangesBrowser
extends AsyncChangesBrowserBase
implements Disposable {
    private final boolean isSwitchingDiffModeAllowed;
    @Nullable
    private ActivityDiffData diffData;

    public ActivityChangesBrowser(@NotNull Project project, boolean isSwitchingDiffModeAllowed) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false, false);
        this.isSwitchingDiffModeAllowed = isSwitchingDiffModeAllowed;
        this.init();
        this.hideViewerBorder();
        JScrollPane jScrollPane = this.getViewerScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getViewerScrollPane(...)");
        ScrollableContentBorder.Companion.setup$default((ScrollableContentBorder.Companion)ScrollableContentBorder.Companion, (JScrollPane)jScrollPane, (Side)Side.TOP, null, (int)4, null);
    }

    @NotNull
    protected AsyncChangesTreeModel getChangesTreeModel() {
        return SimpleAsyncChangesTreeModel.Companion.create(arg_0 -> ActivityChangesBrowser._get_changesTreeModel_$lambda$0(this, arg_0));
    }

    private final DefaultTreeModel buildTreeModel(TreeModelBuilder $this$buildTreeModel, ActivityDiffData activityDiffData) {
        if (activityDiffData == null) {
            DefaultTreeModel defaultTreeModel = $this$buildTreeModel.build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"build(...)");
            return defaultTreeModel;
        }
        Iterable<PresentableChange> changesList = activityDiffData.getPresentableChanges();
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> ActivityChangesBrowser.buildTreeModel$lambda$1(buildTreeModel.sortedChangesList.1.INSTANCE, arg_0), TreeModelBuilder.PATH_COMPARATOR);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        List sortedChangesList2 = CollectionsKt.sortedWith(changesList, comparator);
        for (PresentableChange presentableChange : sortedChangesList2) {
            FilePath filePath;
            Intrinsics.checkNotNullExpressionValue((Object)presentableChange.getFilePath(), (String)"getFilePath(...)");
            PresentableChangeNode filePathNode = filePath.isDirectory() ? (PresentableChangeNode)new PresentableDirectoryChangeNode(presentableChange) : new PresentableChangeNode(presentableChange);
            $this$buildTreeModel.insertChangeNode(filePath, $this$buildTreeModel.myRoot, (ChangesBrowserNode)filePathNode);
        }
        if (this.isSwitchingDiffModeAllowed && activityDiffData.isSingleSelection() && !((Collection)sortedChangesList2).isEmpty()) {
            $this$buildTreeModel.insertSubtreeRoot((ChangesBrowserNode)new LinkNode(ActivityChangesBrowserKt.access$getDiffModeText(activityDiffData), ActivityChangesBrowserKt.access$getSwitchDiffModeLink(activityDiffData), (Function0<Unit>)((Function0)new Function0<Unit>(this, activityDiffData){
                final /* synthetic */ ActivityChangesBrowser this$0;
                final /* synthetic */ ActivityDiffData $activityDiffData;
                {
                    this.this$0 = $receiver;
                    this.$activityDiffData = $activityDiffData;
                    super(0);
                }

                public final void invoke() {
                    ActivityChangesBrowser.access$switchDiffMode(this.this$0, this.$activityDiffData);
                }
            })));
        }
        DefaultTreeModel defaultTreeModel = $this$buildTreeModel.build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultTreeModel, (String)"build(...)");
        return defaultTreeModel;
    }

    public final void loadingStarted$intellij_platform_lvcs_impl() {
        this.getViewer().setEmptyText(LocalHistoryBundle.message("activity.empty.text.loading", new Object[0]));
    }

    public final void loadingFinished$intellij_platform_lvcs_impl(@Nullable ActivityDiffData data) {
        this.updateEmptyText(data);
        this.diffData = data;
        this.getViewer().rebuildTree();
    }

    private final void updateEmptyText(ActivityDiffData data) {
        String emptyText = data == null ? LocalHistoryBundle.message("activity.browser.empty.text.no.selection", new Object[0]) : LocalHistoryBundle.message("activity.browser.empty.text", new Object[0]);
        this.getViewer().setEmptyText(emptyText);
        if (this.isSwitchingDiffModeAllowed) {
            ActivityDiffData activityDiffData = data;
            boolean bl = activityDiffData != null ? activityDiffData.isSingleSelection() : false;
            if (bl) {
                this.getViewer().getEmptyText().appendLine(ActivityChangesBrowserKt.access$getSwitchDiffModeLink(data), ActivityChangesBrowserKt.access$getGRAY_LINK_ATTRIBUTES$p(), arg_0 -> ActivityChangesBrowser.updateEmptyText$lambda$2(this, data, arg_0));
            }
        }
    }

    private final void switchDiffMode(ActivityDiffData activityDiffData) {
        boolean $i$f$service = false;
        Class<ActivityViewApplicationSettings> serviceClass$iv = ActivityViewApplicationSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((ActivityViewApplicationSettings)((Object)object)).setDiffMode(ActivityChangesBrowserKt.access$opposite(activityDiffData.getDiffMode()));
    }

    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object userObject) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        ActivityFileChange activityFileChange = userObject instanceof ActivityFileChange ? (ActivityFileChange)userObject : null;
        if (activityFileChange == null) {
            return null;
        }
        ActivityFileChange activityFileChange2 = activityFileChange;
        return activityFileChange2.createProducer(this.myProject);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(ActivityViewDataKeys.INSTANCE.getSELECTED_DIFFERENCES(), (Object)VcsTreeModelData.selected((JTree)((JTree)this.myViewer)).iterateUserObjects(PresentableChange.class));
    }

    @NotNull
    protected List<AnAction> createToolbarActions() {
        List list = super.createToolbarActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createToolbarActions(...)");
        return CollectionsKt.plus((Collection)list, (Object)ActionManager.getInstance().getAction("ActivityView.ChangesBrowser.Toolbar"));
    }

    @NotNull
    protected List<AnAction> createPopupMenuActions() {
        List list = super.createPopupMenuActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createPopupMenuActions(...)");
        return CollectionsKt.plus((Collection)list, (Object)ActionManager.getInstance().getAction("ActivityView.ChangesBrowser.Popup"));
    }

    public void dispose() {
        this.shutdown();
    }

    private static final DefaultTreeModel _get_changesTreeModel_$lambda$0(ActivityChangesBrowser this$0, ChangesGroupingPolicyFactory grouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        return this$0.buildTreeModel(new TreeModelBuilder(this$0.myProject, grouping), this$0.diffData);
    }

    private static final FilePath buildTreeModel$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FilePath)$tmp0.invoke(p0);
    }

    private static final void updateEmptyText$lambda$2(ActivityChangesBrowser this$0, ActivityDiffData $data, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.switchDiffMode($data);
    }

    public static final /* synthetic */ void access$switchDiffMode(ActivityChangesBrowser $this, ActivityDiffData activityDiffData) {
        $this.switchDiffMode(activityDiffData);
    }
}

