/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.operations;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.DifferenceReverter;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.revertion.SelectionReverter;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.project.Project;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.DirectoryDiffMode;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityDataKt;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.DiffUtilsKt;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\r\u0010\u0003\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a!\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a<\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a>\u0010\u0017\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\u001c"}, d2={"getRevertCommandName", "", "Lorg/jetbrains/annotations/Nls;", "name", "Lcom/intellij/openapi/util/NlsSafe;", "timestamp", "", "isOldContentUsed", "", "item", "Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "createDifferenceReverter", "Lcom/intellij/history/integration/revertion/Reverter;", "Lcom/intellij/history/core/LocalHistoryFacade;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "differences", "", "Lcom/intellij/history/core/revisions/Difference;", "createReverter", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "diffMode", "Lcom/intellij/platform/lvcs/impl/DirectoryDiffMode;", "intellij.platform.lvcs.impl"})
public final class RevertKt {
    @Nullable
    public static final Reverter createReverter(@NotNull LocalHistoryFacade $this$createReverter, @NotNull Project project, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, @NotNull DirectoryDiffMode diffMode, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$createReverter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)((Object)diffMode), (String)"diffMode");
        RevisionId targetRevisionId = ChangeSetSelectionKt.getLeftRevision(selection);
        if (Intrinsics.areEqual((Object)targetRevisionId, (Object)RevisionId.Current.INSTANCE)) {
            return null;
        }
        Supplier<String> commandNameSupplier = () -> RevertKt.createReverter$lambda$0(selection, isOldContentUsed);
        if (scope instanceof ActivityScope.Selection) {
            SelectionCalculator calculator = LocalHistoryActivityDataKt.getSelectionCalculator(selection.getData(), $this$createReverter, gateway, (ActivityScope.Selection)scope, isOldContentUsed);
            return new SelectionReverter(project, $this$createReverter, gateway, calculator, targetRevisionId, DiffUtilsKt.getEntryPath(gateway, (ActivityScope.File)scope), ((ActivityScope.Selection)scope).getFrom(), ((ActivityScope.Selection)scope).getTo(), commandNameSupplier);
        }
        List<Difference> diff = DiffUtilsKt.getDiff($this$createReverter, gateway, scope, selection, diffMode, isOldContentUsed);
        return new DifferenceReverter(project, $this$createReverter, gateway, diff, commandNameSupplier);
    }

    @Nullable
    public static final Reverter createDifferenceReverter(@NotNull LocalHistoryFacade $this$createDifferenceReverter, @NotNull Project project, @NotNull IdeaGateway gateway, @NotNull ChangeSetSelection selection, @NotNull List<Difference> differences, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$createDifferenceReverter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(differences, (String)"differences");
        RevisionId targetRevisionId = ChangeSetSelectionKt.getLeftRevision(selection);
        if (Intrinsics.areEqual((Object)targetRevisionId, (Object)RevisionId.Current.INSTANCE)) {
            return null;
        }
        if (differences.isEmpty()) {
            return null;
        }
        return new DifferenceReverter(project, $this$createDifferenceReverter, gateway, differences, () -> RevertKt.createDifferenceReverter$lambda$1(selection, isOldContentUsed));
    }

    private static final String getRevertCommandName(ChangeSetActivityItem item, boolean isOldContentUsed) {
        if (item == null) {
            return LocalHistoryBundle.message("activity.name.revert", new Object[0]);
        }
        return RevertKt.getRevertCommandName(item.getName(), item.getTimestamp(), isOldContentUsed);
    }

    @Nullable
    public static final String getRevertCommandName(@Nullable String name, long timestamp, boolean isOldContentUsed) {
        String string = DateFormatUtil.formatDateTime((long)timestamp);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String date = string;
        if (isOldContentUsed) {
            if (name != null) {
                Object[] objectArray = new Object[]{name, date};
                return LocalHistoryBundle.message("activity.name.revert.change.date", objectArray);
            }
            Object[] objectArray = new Object[]{date};
            return LocalHistoryBundle.message("activity.name.revert.date", objectArray);
        }
        if (name != null) {
            Object[] objectArray = new Object[]{name, date};
            return LocalHistoryBundle.message("activity.name.revert.to.change.date", objectArray);
        }
        Object[] objectArray = new Object[]{date};
        return LocalHistoryBundle.message("activity.name.revert.to.date", objectArray);
    }

    private static final String createReverter$lambda$0(ChangeSetSelection $selection, boolean $isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$selection, (String)"$selection");
        return RevertKt.getRevertCommandName($selection.getLeftItem(), $isOldContentUsed);
    }

    private static final String createDifferenceReverter$lambda$1(ChangeSetSelection $selection, boolean $isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$selection, (String)"$selection");
        return RevertKt.getRevertCommandName($selection.getLeftItem(), $isOldContentUsed);
    }
}

