/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.history.integration.ui.views.RevisionProcessingProgressAdapter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItemKt;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.DifferenceDiffRequestProducer;
import com.intellij.platform.lvcs.impl.diff.EntryDiffContentKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0013\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/SelectionDiffRequestProducer;", "Lcom/intellij/platform/lvcs/impl/diff/DifferenceDiffRequestProducer$WithLazyDiff;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope$Selection;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "loadDifference", "Lkotlin/Function0;", "Lcom/intellij/history/core/revisions/Difference;", "selectionCalculator", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "isOldContentUsed", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope$Selection;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lkotlin/jvm/functions/Function0;Lcom/intellij/history/integration/ui/models/SelectionCalculator;Z)V", "getScope", "()Lcom/intellij/platform/lvcs/impl/ActivityScope$Selection;", "createContent", "Lcom/intellij/diff/contents/DiffContent;", "entry", "Lcom/intellij/history/core/tree/Entry;", "revision", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "equals", "other", "", "hashCode", "", "process", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "intellij.platform.lvcs.impl"})
public final class SelectionDiffRequestProducer
extends DifferenceDiffRequestProducer.WithLazyDiff {
    @NotNull
    private final ActivityScope.Selection scope;
    @NotNull
    private final SelectionCalculator selectionCalculator;

    public SelectionDiffRequestProducer(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull ActivityScope.Selection scope, @NotNull ChangeSetSelection selection, @NotNull Function0<Difference> loadDifference2, @NotNull SelectionCalculator selectionCalculator, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(loadDifference2, (String)"loadDifference");
        Intrinsics.checkNotNullParameter((Object)selectionCalculator, (String)"selectionCalculator");
        super(project, gateway, scope, selection, loadDifference2, isOldContentUsed);
        this.scope = scope;
        this.selectionCalculator = selectionCalculator;
    }

    @Override
    @NotNull
    protected ActivityScope.Selection getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        DiffContent leftContent = this.createContent(this.getDifference().getLeft(), ChangeSetActivityItemKt.getRevisionId(this.getLeftItem()), indicator);
        DiffContent rightContent = this.createContent(this.getDifference().getRight(), ChangeSetActivityItemKt.getRevisionId(this.getRightItem()), indicator);
        String leftContentTitle = this.getTitle(this.getLeftItem());
        String rightContentTitle = this.getTitle(this.getRightItem());
        return (DiffRequest)new SimpleDiffRequest(this.getName(), leftContent, rightContent, leftContentTitle, rightContentTitle);
    }

    private final DiffContent createContent(Entry entry, RevisionId revision, ProgressIndicator indicator) {
        if (entry == null) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        if (revision instanceof RevisionId.ChangeSet) {
            return EntryDiffContentKt.createDiffContent(this.getGateway(), entry, ((RevisionId.ChangeSet)revision).getId(), this.selectionCalculator, new RevisionProcessingProgressAdapter(indicator));
        }
        Project project = this.getProject();
        IdeaGateway ideaGateway = this.getGateway();
        String string = entry.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return EntryDiffContentKt.createCurrentDiffContent(project, ideaGateway, string, this.getScope().getFrom(), this.getScope().getTo());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SelectionDiffRequestProducer)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual(this.selectionCalculator.getRevisions$intellij_platform_lvcs_impl(), ((SelectionDiffRequestProducer)other).selectionCalculator.getRevisions$intellij_platform_lvcs_impl());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + ((Object)this.selectionCalculator.getRevisions$intellij_platform_lvcs_impl()).hashCode();
        return result2;
    }
}

