/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.RevisionId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a.\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u000b\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\r\u001a\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002\u00a8\u0006\u0018"}, d2={"createCurrentDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "path", "", "from", "", "to", "createDiffContent", "entry", "Lcom/intellij/history/core/tree/Entry;", "changeSetId", "", "calculator", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "progress", "Lcom/intellij/history/integration/ui/models/RevisionProcessingProgress;", "e", "createUnavailableContent", "Lcom/intellij/diff/contents/DocumentContent;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public final class EntryDiffContentKt {
    @NotNull
    public static final DiffContent createDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull Entry e) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        byte[] content = e.getContent().getBytes();
        VirtualFile virtualFile = gateway.findVirtualFile(e.getPath());
        if (virtualFile != null) {
            DocumentContent documentContent = DiffContentFactoryEx.getInstanceEx().createDocumentFromBytes(project, content, virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createDocumentFromBytes(...)");
            return (DiffContent)documentContent;
        }
        FileType fileType = gateway.getFileType(e.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        DocumentContent documentContent = DiffContentFactoryEx.getInstanceEx().createDocumentFromBytes(project, content, fileType2, e.getName());
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createDocumentFromBytes(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createCurrentDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Document document2 = (Document)ActionsKt.runReadAction((Function0)((Function0)new Function0<Document>(gateway, path){
            final /* synthetic */ IdeaGateway $gateway;
            final /* synthetic */ String $path;
            {
                this.$gateway = $gateway;
                this.$path = $path;
                super(0);
            }

            @Nullable
            public final Document invoke() {
                return this.$gateway.getDocument(this.$path);
            }
        }));
        if (document2 == null) {
            return (DiffContent)EntryDiffContentKt.createUnavailableContent();
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, document2);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createDiffContent(@NotNull IdeaGateway gateway, @NotNull Entry entry, long changeSetId, @NotNull SelectionCalculator calculator, @NotNull RevisionProcessingProgress progress) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)calculator, (String)"calculator");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        String string = calculator.getSelectionFor(new RevisionId.ChangeSet(changeSetId), (Progress)progress).getBlockContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlockContent(...)");
        String content = string;
        VirtualFile virtualFile = gateway.findVirtualFile(entry.getPath());
        if (virtualFile != null) {
            DocumentContent documentContent = DiffContentFactory.getInstance().create(content, virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
            return (DiffContent)documentContent;
        }
        FileType fileType = gateway.getFileType(entry.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        DocumentContent documentContent = DiffContentFactory.getInstance().create(content, fileType2);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return (DiffContent)documentContent;
    }

    @NotNull
    public static final DiffContent createCurrentDiffContent(@Nullable Project project, @NotNull IdeaGateway gateway, @NotNull String path, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (DiffContent)ActionsKt.runReadAction((Function0)((Function0)new Function0<DocumentContent>(gateway, path, from, to, project){
            final /* synthetic */ IdeaGateway $gateway;
            final /* synthetic */ String $path;
            final /* synthetic */ int $from;
            final /* synthetic */ int $to;
            final /* synthetic */ Project $project;
            {
                this.$gateway = $gateway;
                this.$path = $path;
                this.$from = $from;
                this.$to = $to;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final DocumentContent invoke() {
                Document document2 = this.$gateway.getDocument(this.$path);
                if (document2 == null) {
                    return EntryDiffContentKt.access$createUnavailableContent();
                }
                int fromOffset = document2.getLineStartOffset(this.$from);
                int toOffset = document2.getLineEndOffset(this.$to);
                DocumentContent documentContent = DiffContentFactory.getInstance().createFragment(this.$project, document2, new TextRange(fromOffset, toOffset));
                Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"createFragment(...)");
                return documentContent;
            }
        }));
    }

    private static final DocumentContent createUnavailableContent() {
        DocumentContent documentContent = DiffContentFactory.getInstance().create(LocalHistoryBundle.message("content.not.available", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
        return documentContent;
    }

    public static final /* synthetic */ DocumentContent access$createUnavailableContent() {
        return EntryDiffContentKt.createUnavailableContent();
    }
}

