/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.ActivityId;
import com.intellij.history.ByteContent;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.history.core.ByteContentRetriever;
import com.intellij.history.core.ChangeAndPathProcessor;
import com.intellij.history.core.ChangeList;
import com.intellij.history.core.ChangeListStorage;
import com.intellij.history.core.ChangeListStorageImpl;
import com.intellij.history.core.InMemoryChangeListStorage;
import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.CommonActivity;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryActionImpl;
import com.intellij.history.integration.LocalHistoryEventDispatcher;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.revertion.DifferenceReverter;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.platform.lvcs.impl.diff.DiffUtilsKt;
import com.intellij.platform.lvcs.impl.operations.RevertKt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0007J\b\u0010 \u001a\u00020\u001cH\u0007J\b\u0010!\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u001cH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u000f\u0010)\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u001cH\u0002J\b\u0010,\u001a\u00020\u001cH\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020&H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010/\u001a\u000201H\u0002J%\u00102\u001a\u0002002\u0006\u00103\u001a\u0002042\u000b\u00105\u001a\u000706\u00a2\u0006\u0002\b72\u0006\u00108\u001a\u000209H\u0016J%\u0010:\u001a\u0002002\u0006\u00103\u001a\u0002042\u000b\u00105\u001a\u000706\u00a2\u0006\u0002\b72\u0006\u0010;\u001a\u00020\u0007H\u0016J\u001d\u0010<\u001a\u0002002\u0006\u00103\u001a\u0002042\u000b\u00105\u001a\u000706\u00a2\u0006\u0002\b7H\u0016J \u0010=\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\u0006\u0010>\u001a\u00020&2\u0006\u0010/\u001a\u000201H\u0002J!\u0010?\u001a\u00020@2\r\u00105\u001a\t\u0018\u000106\u00a2\u0006\u0002\b72\b\u00108\u001a\u0004\u0018\u000109H\u0016J\f\u0010A\u001a\u00020\u001c*\u00020BH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/history/integration/LocalHistoryImpl;", "Lcom/intellij/history/LocalHistory;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "daysToKeep", "", "eventDispatcher", "Lcom/intellij/history/integration/LocalHistoryEventDispatcher;", "<set-?>", "Lcom/intellij/history/core/LocalHistoryFacade;", "facade", "getFacade", "()Lcom/intellij/history/core/LocalHistoryFacade;", "flusherTask", "Lkotlinx/coroutines/Job;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "getGateway", "()Lcom/intellij/history/integration/IdeaGateway;", "initialFlush", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "isDisabled", "()Z", "isInitialized", "addVFSListenerAfterLocalHistoryOne", "", "virtualFileListener", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "disposable", "cleanupForNextTest", "dispose", "doDispose", "getByteContent", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "condition", "Lcom/intellij/history/FileRevisionTimestampComparator;", "getEventDispatcher", "getEventDispatcher$intellij_platform_lvcs_impl", "init", "initHistory", "isUnderControl", "file", "label", "Lcom/intellij/history/Label;", "Lcom/intellij/history/core/LabelImpl;", "putEventLabel", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "putSystemLabel", "color", "putUserLabel", "revertToLabel", "f", "startAction", "Lcom/intellij/history/LocalHistoryAction;", "purgeObsolete", "Lcom/intellij/history/core/ChangeList;", "Companion", "intellij.platform.lvcs.impl"})
public final class LocalHistoryImpl
extends LocalHistory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    private int daysToKeep;
    private boolean isDisabled;
    @Nullable
    private LocalHistoryFacade facade;
    @NotNull
    private final IdeaGateway gateway;
    @Nullable
    private Job flusherTask;
    @NotNull
    private final AtomicBoolean initialFlush;
    @Nullable
    private LocalHistoryEventDispatcher eventDispatcher;
    @NotNull
    private final AtomicBoolean isInitialized;
    @NotNull
    private static final String DAYS_TO_KEEP = "localHistory.daysToKeep";

    public LocalHistoryImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.daysToKeep = AdvancedSettings.Companion.getInt(DAYS_TO_KEEP);
        this.gateway = new IdeaGateway();
        this.initialFlush = new AtomicBoolean(true);
        this.isInitialized = new AtomicBoolean();
        this.init();
    }

    public final boolean isDisabled() {
        return this.isDisabled;
    }

    @Nullable
    public final LocalHistoryFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final IdeaGateway getGateway() {
        return this.gateway;
    }

    @Nullable
    public final LocalHistoryEventDispatcher getEventDispatcher$intellij_platform_lvcs_impl() {
        return this.eventDispatcher;
    }

    private final void init() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isHeadlessEnvironment()) {
            return;
        }
        if (SystemProperties.getBooleanProperty((String)"lvcs.disable.local.history", (boolean)false)) {
            LocalHistoryLog.LOG.warn("Local history is disabled");
            this.isDisabled = true;
            return;
        }
        ShutDownTracker.getInstance().registerShutdownTask(() -> LocalHistoryImpl.init$lambda$0(this));
        this.initHistory();
        app.getMessageBus().simpleConnect().subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(this){
            final /* synthetic */ LocalHistoryImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)"localHistory.daysToKeep")) {
                    LocalHistoryImpl.access$setDaysToKeep$p(this.this$0, (Integer)newValue);
                }
            }
        });
        this.flusherTask = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LocalHistoryImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl6:
                        // 3 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if ((v1 = this.this$0.getFacade()) == null || (v1 = v1.getChangeList$intellij_platform_lvcs_impl()) == null) ** GOTO lbl6
                        changeList = v1;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (ChangeList)changeList, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ LocalHistoryImpl this$0;
                            final /* synthetic */ ChangeList $changeList;
                            {
                                this.this$0 = $receiver;
                                this.$changeList = $changeList;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                        if (LocalHistoryImpl.access$getInitialFlush$p(this.this$0).compareAndSet(true, false)) {
                                            LocalHistoryImpl.access$purgeObsolete(this.this$0, this.$changeList);
                                        }
                                        JobKt.ensureActive((CoroutineContext)$this$withContext.getCoroutineContext());
                                        this.$changeList.force();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl26:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.isInitialized.set(true);
    }

    private final void initHistory() {
        ChangeListStorage storage = null;
        try {
            storage = new ChangeListStorageImpl(Companion.getStorageDir());
        }
        catch (Throwable e) {
            LocalHistoryLog.LOG.warn("cannot create storage, in-memory  implementation will be used", e);
            storage = new InMemoryChangeListStorage();
        }
        LocalHistoryFacade localHistoryFacade = this.facade = new LocalHistoryFacade(new ChangeList(storage));
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        this.eventDispatcher = new LocalHistoryEventDispatcher(localHistoryFacade, this.gateway);
    }

    public void dispose() {
        this.doDispose();
    }

    private final void doDispose() {
        Object object;
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        Job job = this.flusherTask;
        if (job != null) {
            Job it = job;
            boolean bl = false;
            Job.DefaultImpls.cancel$default((Job)it, null, (int)1, null);
            this.flusherTask = null;
        }
        if ((object = this.facade) != null && (object = ((LocalHistoryFacade)object).getChangeList$intellij_platform_lvcs_impl()) != null) {
            ((ChangeList)object).close();
        }
        LocalHistoryLog.LOG.debug("Local history storage successfully closed.");
    }

    private final void purgeObsolete(ChangeList $this$purgeObsolete) {
        long period = (long)this.daysToKeep * 1000L * 60L * 60L * 24L;
        LocalHistoryLog.LOG.debug("Purging local history...");
        $this$purgeObsolete.purgeObsolete(period);
    }

    @TestOnly
    public final void cleanupForNextTest() {
        this.doDispose();
        PathKt.delete$default((Path)Companion.getStorageDir(), (boolean)false, (int)1, null);
        this.init();
    }

    @NotNull
    public LocalHistoryAction startAction(@Nullable String name, @Nullable ActivityId activityId) {
        if (!this.isInitialized()) {
            LocalHistoryAction localHistoryAction = LocalHistoryAction.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)localHistoryAction, (String)"NULL");
            return localHistoryAction;
        }
        LocalHistoryActionImpl a = new LocalHistoryActionImpl(this.eventDispatcher, name, activityId);
        a.start();
        return a;
    }

    @NotNull
    public Label putEventLabel(@NotNull Project project, @NotNull String name, @NotNull ActivityId activityId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        if (!this.isInitialized()) {
            Label label2 = Label.NULL_INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"NULL_INSTANCE");
            return label2;
        }
        LocalHistoryAction action = this.startAction(name, activityId);
        LocalHistoryFacade localHistoryFacade = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        Label label3 = this.label(localHistoryFacade.putUserLabel(name, LocalHistoryImpl.Companion.getProjectId(project)));
        action.finish();
        return label3;
    }

    @NotNull
    public Label putUserLabel(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.putEventLabel(project, name, CommonActivity.UserLabel);
    }

    @NotNull
    public Label putSystemLabel(@NotNull Project project, @NotNull String name, int color) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.isInitialized()) {
            Label label2 = Label.NULL_INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"NULL_INSTANCE");
            return label2;
        }
        LocalHistoryFacade localHistoryFacade = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        this.gateway.registerUnsavedDocuments(localHistoryFacade);
        LocalHistoryFacade localHistoryFacade2 = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade2);
        return this.label(localHistoryFacade2.putSystemLabel(name, LocalHistoryImpl.Companion.getProjectId(project), color));
    }

    @ApiStatus.Internal
    public final void addVFSListenerAfterLocalHistoryOne(@NotNull BulkFileListener virtualFileListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)virtualFileListener, (String)"virtualFileListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        LocalHistoryEventDispatcher localHistoryEventDispatcher = this.eventDispatcher;
        Intrinsics.checkNotNull((Object)localHistoryEventDispatcher);
        localHistoryEventDispatcher.addVirtualFileListener(virtualFileListener, disposable);
    }

    private final Label label(LabelImpl label2) {
        return new Label(this, label2){
            final /* synthetic */ LocalHistoryImpl this$0;
            final /* synthetic */ LabelImpl $label;
            {
                this.this$0 = $receiver;
                this.$label = $label;
            }

            public void revert(@NotNull Project project, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                LocalHistoryImpl.access$revertToLabel(this.this$0, project, file, this.$label);
            }

            @NotNull
            public ByteContent getByteContent(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Object object = ApplicationManager.getApplication().runReadAction(() -> label.1.getByteContent$lambda$0(this.$label, this.this$0, path));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                return (ByteContent)object;
            }

            private static final ByteContent getByteContent$lambda$0(LabelImpl $label, LocalHistoryImpl this$0, String $path) {
                Intrinsics.checkNotNullParameter((Object)$label, (String)"$label");
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
                return $label.getByteContent(this$0.getGateway().createTransientRootEntryForPath($path, false), $path);
            }
        };
    }

    @Nullable
    public byte[] getByteContent(@NotNull VirtualFile virtualFile, @NotNull FileRevisionTimestampComparator condition) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        if (!this.isInitialized()) {
            return null;
        }
        return (byte[])ApplicationManager.getApplication().runReadAction(() -> LocalHistoryImpl.getByteContent$lambda$2(this, virtualFile, condition));
    }

    public boolean isUnderControl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.isInitialized() && this.gateway.isVersioned(file);
    }

    private final boolean isInitialized() {
        return this.isInitialized.get();
    }

    private final void revertToLabel(Project project, VirtualFile f, LabelImpl label2) throws LocalHistoryException {
        String string = this.gateway.getPathOrUrl(f);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        String path = string;
        Ref.ObjectRef targetChangeSet = new Ref.ObjectRef();
        Ref.ObjectRef targetChange = new Ref.ObjectRef();
        Object[] objectArray = new String[]{path};
        Set targetPaths = SetsKt.mutableSetOf((Object[])objectArray);
        LocalHistoryFacade localHistoryFacade = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade);
        LocalHistoryFacadeKt.collectChanges(localHistoryFacade, path, new ChangeAndPathProcessor(project.getLocationHash(), null, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)targetPaths){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((Set)this.receiver).add(p0);
            }
        }), (Function1<? super ChangeSet, Unit>)((Function1)new Function1<ChangeSet, Unit>((Ref.ObjectRef<ChangeSet>)targetChangeSet, (Ref.ObjectRef<Change>)targetChange, label2){
            final /* synthetic */ Ref.ObjectRef<ChangeSet> $targetChangeSet;
            final /* synthetic */ Ref.ObjectRef<Change> $targetChange;
            final /* synthetic */ LabelImpl $label;
            {
                this.$targetChangeSet = $targetChangeSet;
                this.$targetChange = $targetChange;
                this.$label = $label;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ChangeSet changeSet) {
                Object v1;
                block2: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
                    List<Change> list = changeSet.getChanges();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
                    Iterable iterable = list;
                    LabelImpl labelImpl = this.$label;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Change it = (Change)element$iv;
                        boolean bl = false;
                        if (!(it.getId() == labelImpl.getLabelChangeId())) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                Change change = v1;
                if (change != null) {
                    this.$targetChangeSet.element = changeSet;
                    this.$targetChange.element = change;
                }
            }
        })));
        if (targetChangeSet.element == null || targetChange.element == null) {
            throw new LocalHistoryException("Couldn't find label");
        }
        Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<RootEntry>(this, (Set<String>)targetPaths){
            final /* synthetic */ LocalHistoryImpl this$0;
            final /* synthetic */ Set<String> $targetPaths;
            {
                this.this$0 = $receiver;
                this.$targetPaths = $targetPaths;
                super(0);
            }

            @NotNull
            public final RootEntry invoke() {
                return this.this$0.getGateway().createTransientRootEntryForPaths((Collection<String>)this.$targetPaths, true);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        RootEntry rootEntry2 = (RootEntry)object;
        LocalHistoryFacade localHistoryFacade2 = this.facade;
        Intrinsics.checkNotNull((Object)localHistoryFacade2);
        Object object2 = targetChangeSet.element;
        Intrinsics.checkNotNull((Object)object2);
        Entry leftEntry = DiffUtilsKt.findEntry(localHistoryFacade2, rootEntry2, new RevisionId.ChangeSet(((ChangeSet)object2).getId()), path, false);
        Entry rightEntry = rootEntry2.findEntry(path);
        List<Difference> list = Entry.getDifferencesBetween(leftEntry, rightEntry, true);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDifferencesBetween(...)");
        List<Difference> diff = list;
        if (diff.isEmpty()) {
            return;
        }
        DifferenceReverter reverter = new DifferenceReverter(project, this.facade, this.gateway, diff, () -> LocalHistoryImpl.revertToLabel$lambda$3(targetChange, targetChangeSet));
        try {
            reverter.revert();
        }
        catch (Exception e) {
            throw new LocalHistoryException("Couldn't revert " + f.getName() + " to local history label.", (Throwable)e);
        }
    }

    private static final void init$lambda$0(LocalHistoryImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.doDispose();
    }

    private static final byte[] getByteContent$lambda$2(LocalHistoryImpl this$0, VirtualFile $virtualFile, FileRevisionTimestampComparator $condition) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$virtualFile, (String)"$virtualFile");
        Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
        return this$0.gateway.areContentChangesVersioned($virtualFile) ? new ByteContentRetriever(this$0.gateway, this$0.facade, $virtualFile, $condition).getResult() : null;
    }

    private static final String revertToLabel$lambda$3(Ref.ObjectRef $targetChange, Ref.ObjectRef $targetChangeSet) {
        Intrinsics.checkNotNullParameter((Object)$targetChange, (String)"$targetChange");
        Intrinsics.checkNotNullParameter((Object)$targetChangeSet, (String)"$targetChangeSet");
        Object object = $targetChange.element;
        PutLabelChange putLabelChange = object instanceof PutLabelChange ? (PutLabelChange)object : null;
        String string = putLabelChange != null ? putLabelChange.getName() : null;
        Object object2 = $targetChangeSet.element;
        Intrinsics.checkNotNull((Object)object2);
        return RevertKt.getRevertCommandName(string, ((ChangeSet)object2).getTimestamp(), false);
    }

    @JvmStatic
    @NotNull
    public static final LocalHistoryImpl getInstanceImpl() {
        return Companion.getInstanceImpl();
    }

    public static final /* synthetic */ void access$setDaysToKeep$p(LocalHistoryImpl $this, int n) {
        $this.daysToKeep = n;
    }

    public static final /* synthetic */ AtomicBoolean access$getInitialFlush$p(LocalHistoryImpl $this) {
        return $this.initialFlush;
    }

    public static final /* synthetic */ void access$purgeObsolete(LocalHistoryImpl $this, ChangeList $receiver) {
        $this.purgeObsolete($receiver);
    }

    public static final /* synthetic */ void access$revertToLabel(LocalHistoryImpl $this, Project project, VirtualFile f, LabelImpl label2) {
        $this.revertToLabel(project, f, label2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/history/integration/LocalHistoryImpl$Companion;", "", "()V", "DAYS_TO_KEEP", "", "storageDir", "Ljava/nio/file/Path;", "getStorageDir", "()Ljava/nio/file/Path;", "getInstanceImpl", "Lcom/intellij/history/integration/LocalHistoryImpl;", "getProjectId", "p", "Lcom/intellij/openapi/project/Project;", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LocalHistoryImpl getInstanceImpl() {
            LocalHistory localHistory = LocalHistory.Companion.getInstance();
            Intrinsics.checkNotNull((Object)localHistory, (String)"null cannot be cast to non-null type com.intellij.history.integration.LocalHistoryImpl");
            return (LocalHistoryImpl)localHistory;
        }

        @NotNull
        public final Path getStorageDir() {
            String[] stringArray = new String[]{"LocalHistory"};
            Path path = Path.of(PathManager.getSystemPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }

        private final String getProjectId(Project p) {
            String string = p.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

