/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome;

import com.intellij.llmInstaller.AIAssistantContentExtension;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.ui.welcome.BaseWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.FeatureWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.NavigationType;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeatureSelectedAction;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeaturesOrderedNavigationService;
import com.intellij.llmInstaller.ui.welcome.features.WelcomeFeatureDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.WebAnimationUtils;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel;", "Lcom/intellij/llmInstaller/ui/welcome/BaseWelcomePanel;", "project", "Lcom/intellij/openapi/project/Project;", "featureDescriptor", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "index", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;I)V", "createAnimation", "Ljavax/swing/JComponent;", "url", "Ljava/net/URL;", "createContent", "createDescription", "Lcom/intellij/ui/components/JBHtmlPane;", "getDefaultComponent", "EditorPaneWrapper", "ScalableWrapper", "intellij.llmInstaller"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFeatureWelcomePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureWelcomePanel.kt\ncom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,170:1\n23#2:171\n*S KotlinDebug\n*F\n+ 1 FeatureWelcomePanel.kt\ncom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel\n*L\n110#1:171\n*E\n"})
public final class FeatureWelcomePanel
extends BaseWelcomePanel {
    @NotNull
    private final WelcomeFeatureDescriptor featureDescriptor;
    private final int index;

    public FeatureWelcomePanel(@NotNull Project project, @NotNull WelcomeFeatureDescriptor featureDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)featureDescriptor, (String)"featureDescriptor");
        super(project);
        this.featureDescriptor = featureDescriptor;
        this.index = index;
    }

    @Override
    @NotNull
    protected JComponent createContent() {
        DialogPanel dialogPanel;
        DialogPanel $this$createContent_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ FeatureWelcomePanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), (Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ FeatureWelcomePanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$customizeSpacingConfiguration) {
                        Object it;
                        FeatureWelcomePanel featureWelcomePanel;
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
                        URL uRL = FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getWebmPreview();
                        if (uRL != null) {
                            object = uRL;
                            featureWelcomePanel = this.this$0;
                            it = object;
                            boolean bl = false;
                            JComponent animationComponent = FeatureWelcomePanel.access$createAnimation(featureWelcomePanel, (URL)it);
                            if (animationComponent != null) {
                                Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(animationComponent){
                                    final /* synthetic */ JComponent $animationComponent;
                                    {
                                        this.$animationComponent = $animationComponent;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Row $this$row) {
                                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                        ScalableWrapper wrapper = new ScalableWrapper(this.$animationComponent, 1.7777777777777777);
                                        $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
                                    }
                                }), (int)1, null);
                            }
                        }
                        this.this$0.title($this$customizeSpacingConfiguration, FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getTitle());
                        String string = FeatureWelcomePanel.access$getFeatureDescriptor$p(this.this$0).getDescription().getAsHtml();
                        if (string != null) {
                            object = string;
                            featureWelcomePanel = this.this$0;
                            it = object;
                            boolean bl = false;
                            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(featureWelcomePanel, (String)it){
                                final /* synthetic */ FeatureWelcomePanel this$0;
                                final /* synthetic */ String $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(1);
                                }

                                public final void invoke(@NotNull Row $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    EditorPaneWrapper wrapper = new EditorPaneWrapper((JEditorPane)FeatureWelcomePanel.access$createDescription(this.this$0), this.$it);
                                    $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
                                }
                            }), (int)1, null);
                        }
                        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ FeatureWelcomePanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                block1: {
                                    Pair<WelcomeFeatureDescriptor, Integer> pair;
                                    FeatureWelcomePanel featureWelcomePanel;
                                    Pair<WelcomeFeatureDescriptor, Integer> pair2;
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    WelcomeFeaturesOrderedNavigationService navigationService = WelcomeFeaturesOrderedNavigationService.Companion.getInstance(FeatureWelcomePanel.access$getProject(this.this$0));
                                    Pair<WelcomeFeatureDescriptor, Integer> pair3 = navigationService.getPreviousFeature(FeatureWelcomePanel.access$getIndex$p(this.this$0));
                                    if (pair3 != null) {
                                        pair2 = pair3;
                                        featureWelcomePanel = this.this$0;
                                        pair = pair2;
                                        boolean bl = false;
                                        WelcomeFeatureDescriptor previousFeature = (WelcomeFeatureDescriptor)pair.component1();
                                        int previousFeatureIndex = ((Number)pair.component2()).intValue();
                                        $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.previous.feature.button", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(featureWelcomePanel, previousFeature, previousFeatureIndex){
                                            final /* synthetic */ FeatureWelcomePanel this$0;
                                            final /* synthetic */ WelcomeFeatureDescriptor $previousFeature;
                                            final /* synthetic */ int $previousFeatureIndex;
                                            {
                                                this.this$0 = $receiver;
                                                this.$previousFeature = $previousFeature;
                                                this.$previousFeatureIndex = $previousFeatureIndex;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ActionEvent it) {
                                                block0: {
                                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                    WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this.this$0.getOnFeatureSelected();
                                                    if (welcomeFeatureSelectedAction == null) break block0;
                                                    welcomeFeatureSelectedAction.onFeatureSelected(this.$previousFeature, this.$previousFeatureIndex, this.this$0.getClass(), NavigationType.PREVIOUS);
                                                }
                                            }
                                        }).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)6, (int)7, null));
                                    }
                                    Pair<WelcomeFeatureDescriptor, Integer> pair4 = navigationService.getNextFeature(FeatureWelcomePanel.access$getIndex$p(this.this$0));
                                    if (pair4 == null) break block1;
                                    pair2 = pair4;
                                    featureWelcomePanel = this.this$0;
                                    pair = pair2;
                                    boolean bl = false;
                                    WelcomeFeatureDescriptor nextFeature = (WelcomeFeatureDescriptor)pair.component1();
                                    int nextFeatureIndex = ((Number)pair.component2()).intValue();
                                    Object[] objectArray = new Object[]{nextFeature.getTitle()};
                                    $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.next.feature.button", objectArray), (Function1)new Function1<ActionEvent, Unit>(featureWelcomePanel, nextFeature, nextFeatureIndex){
                                        final /* synthetic */ FeatureWelcomePanel this$0;
                                        final /* synthetic */ WelcomeFeatureDescriptor $nextFeature;
                                        final /* synthetic */ int $nextFeatureIndex;
                                        {
                                            this.this$0 = $receiver;
                                            this.$nextFeature = $nextFeature;
                                            this.$nextFeatureIndex = $nextFeatureIndex;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ActionEvent it) {
                                            block0: {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this.this$0.getOnFeatureSelected();
                                                if (welcomeFeatureSelectedAction == null) break block0;
                                                welcomeFeatureSelectedAction.onFeatureSelected(this.$nextFeature, this.$nextFeatureIndex, this.this$0.getClass(), NavigationType.NEXT);
                                            }
                                        }
                                    });
                                }
                            }
                        }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)24, (int)0, (int)2, null));
                        if (CollectionsKt.firstOrNull((List)AIAssistantContentExtension.Companion.getEP_NAME().getExtensionList()) == null) {
                            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                                final /* synthetic */ FeatureWelcomePanel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull Row $this$row) {
                                    void $this$invoke_u24lambda_u241;
                                    InlineBanner inlineBanner;
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    InlineBanner inlineBanner2 = inlineBanner = new InlineBanner(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.message", new Object[0]), null, 2, null).setIcon(null).addAction(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.action", new Object[0]), () -> createContent.4.invoke$lambda$0(this.this$0));
                                    Row row = $this$row;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u241.showCloseButton(false);
                                    row.cell((JComponent)inlineBanner).align((Align)AlignX.FILL.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)12, (int)0, (int)12, (int)5, null));
                                }

                                private static final void invoke$lambda$0(FeatureWelcomePanel this$0) {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                        Runnable runnable = this$0.getOnInstallPlugin();
                                        if (runnable == null) break block0;
                                        runnable.run();
                                    }
                                }
                            }), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)36, (int)0, (int)2, null));
                        }
                    }
                });
            }
        }));
        boolean bl = false;
        $this$createContent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)20, (int)20, (int)22, (int)20));
        return (JComponent)dialogPanel;
    }

    @Override
    @Nullable
    public JComponent getDefaultComponent() {
        return null;
    }

    private final JBHtmlPane createDescription() {
        JBHtmlPane jBHtmlPane;
        JBHtmlPaneStyleConfiguration styleConfiguration = new JBHtmlPaneStyleConfiguration();
        JBHtmlPaneConfiguration paneConfiguration2 = new JBHtmlPaneConfiguration((Function1)createDescription.paneConfiguration.1.INSTANCE);
        JBHtmlPane $this$createDescription_u24lambda_u241 = jBHtmlPane = new JBHtmlPane(styleConfiguration, paneConfiguration2);
        boolean bl = false;
        $this$createDescription_u24lambda_u241.setOpaque(false);
        return jBHtmlPane;
    }

    private final JComponent createAnimation(URL url) {
        byte[] byArray;
        try {
            byArray = TextStreamsKt.readBytes((URL)url);
        }
        catch (IOException e) {
            FeatureWelcomePanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FeatureWelcomePanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot load " + url);
            return null;
        }
        byte[] videoBytes = byArray;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setMouseWheelEventEnable(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        JComponent jComponent = browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent result = jComponent;
        String videoBase64 = Base64.getEncoder().encodeToString(videoBytes);
        Intrinsics.checkNotNull((Object)videoBase64);
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        String pageHtml = WebAnimationUtils.INSTANCE.createVideoHtmlPage(videoBase64, color);
        browser.loadHTML(pageHtml);
        return result;
    }

    public static final /* synthetic */ WelcomeFeatureDescriptor access$getFeatureDescriptor$p(FeatureWelcomePanel $this) {
        return $this.featureDescriptor;
    }

    public static final /* synthetic */ Project access$getProject(FeatureWelcomePanel $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ int access$getIndex$p(FeatureWelcomePanel $this) {
        return $this.index;
    }

    public static final /* synthetic */ JComponent access$createAnimation(FeatureWelcomePanel $this, URL url) {
        return $this.createAnimation(url);
    }

    public static final /* synthetic */ JBHtmlPane access$createDescription(FeatureWelcomePanel $this) {
        return $this.createDescription();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$EditorPaneWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JEditorPane;", "htmlText", "", "Lorg/jetbrains/annotations/Nls;", "(Ljavax/swing/JEditorPane;Ljava/lang/String;)V", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "updateUI", "", "intellij.llmInstaller"})
    private static final class EditorPaneWrapper
    extends JPanel {
        @NotNull
        private final JEditorPane component;
        @NotNull
        private final String htmlText;

        public EditorPaneWrapper(@NotNull JEditorPane component, @NotNull String htmlText) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
            super(new BorderLayout());
            this.component = component;
            this.htmlText = htmlText;
            this.component.setText(this.htmlText);
            this.add((Component)this.component, "Center");
        }

        @Override
        public void updateUI() {
            block0: {
                super.updateUI();
                String string = this.htmlText;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                this.component.setText(this.htmlText);
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int availableWidth = n - UiSizeUtilKt.getWidth((Insets)insets);
            this.component.setSize(new Dimension(availableWidth, Short.MAX_VALUE));
            Dimension preferredSize = this.component.getPreferredSize();
            return new Dimension(this.getMinimumSize().width, preferredSize.height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)new JBDimension(50, 10);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$ScalableWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "proportion", "", "(Ljavax/swing/JComponent;D)V", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "intellij.llmInstaller"})
    private static final class ScalableWrapper
    extends JPanel {
        private final double proportion;

        public ScalableWrapper(@NotNull JComponent component, double proportion) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super(new BorderLayout());
            this.proportion = proportion;
            this.add((Component)component, "Center");
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            double height = (double)(n - UiSizeUtilKt.getWidth((Insets)insets)) / this.proportion;
            return new Dimension(this.getMinimumSize().width, (int)height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)new JBDimension(50, 10);
        }
    }
}

