/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/llmInstaller/Agreement;", "", "()V", "ACCEPTED_AI_PRIVACY_POLICY_KEY", "", "AGREEMENT_DOC", "AI_RELATIVE_RESOURCE_PATH", "getAcceptedAiPrivacyPolicyVersion", "Lcom/intellij/ide/gdpr/Version;", "getAiDocumentContentFile", "Ljava/nio/file/Path;", "isAiPrivacyPolicyAccepted", "", "intellij.llmInstaller"})
@ApiStatus.Internal
public final class Agreement {
    @NotNull
    public static final Agreement INSTANCE = new Agreement();
    @NotNull
    public static final String AGREEMENT_DOC = "aiEua";
    @NotNull
    public static final String ACCEPTED_AI_PRIVACY_POLICY_KEY = "JetBrains.privacy_policy.aiEua_accepted_version";
    @NotNull
    private static final String AI_RELATIVE_RESOURCE_PATH = "PrivacyPolicy";

    private Agreement() {
    }

    @NotNull
    public final Path getAiDocumentContentFile() {
        Path path = PathManager.getCommonDataPath().resolve(AI_RELATIVE_RESOURCE_PATH).resolve("aiEua.cached");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public final boolean isAiPrivacyPolicyAccepted() {
        return !this.getAcceptedAiPrivacyPolicyVersion().isUnknown();
    }

    @NotNull
    public final Version getAcceptedAiPrivacyPolicyVersion() {
        Version version = Version.fromString((String)Prefs.get((String)ACCEPTED_AI_PRIVACY_POLICY_KEY, null));
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"fromString(...)");
        return version;
    }
}

