/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uml.core.actions.ShowDiagram;
import com.intellij.uml.core.actions.ShowDiagramBase;
import com.intellij.uml.java.JavaUmlProvider;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import java.awt.Point;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0015\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J$\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/uml/java/ShowDiagramIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "ShowDiagramAction", "intellij.diagram.java"})
public final class ShowDiagramIntentionAction
implements IntentionAction,
Iconable,
LowPriorityAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        String string = DiagramJavaBundle.message("intention.name.show.diagram", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) {
            return false;
        }
        int offset = editor2.getOffset();
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = (UIdentifier)UastContextKt.findUElementAt((PsiFile)psiFile, (int)offset, UIdentifier.class)) == null) {
            return false;
        }
        PsiFile uIdentifier = psiFile;
        return uIdentifier.getUastParent() instanceof UClass;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile = file;
        if (psiFile == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        new ShowDiagramAction().showDiagram(psiFile);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.FileTypes.Diagram;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Diagram");
        return icon;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/uml/java/ShowDiagramIntentionAction$ShowDiagramAction;", "Lcom/intellij/uml/core/actions/ShowDiagram;", "()V", "showDiagram", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.diagram.java"})
    private static final class ShowDiagramAction
    extends ShowDiagram {
        public ShowDiagramAction() {
            super(false, false, 3, null);
        }

        public final void showDiagram(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ShowDiagramBase.DiagramSeed diagramSeed = ShowDiagramBase.createSeed(file.getProject(), new JavaUmlProvider(), (PsiElement)file, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)diagramSeed, (String)"createSeed(...)");
            ShowDiagramBase.DiagramSeed seed = diagramSeed;
            this.show(seed, new RelativePoint(new Point()), null);
        }
    }
}

