/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNodeEditor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramNodeEditorManager
implements DiagramNodeEditingManager {
    @Nullable
    private DiagramNodeEditor myCurrentNodeEditor;
    @Nullable
    private DiagramNodeEditor myLastActiveNodeEditor;

    private DiagramNodeEditorManager() {
    }

    @Override
    @Nullable
    public DiagramNodeEditor getCurrentNodeEditor() {
        return this.myCurrentNodeEditor;
    }

    @Override
    @Nullable
    public DiagramNodeEditor getLastActiveNodeEditor() {
        return this.myLastActiveNodeEditor;
    }

    @Override
    public void dropLastActiveNodeEditor() {
        this.myLastActiveNodeEditor = null;
    }

    @Override
    public void startEditing(@NotNull DiagramNodeEditor editor, @NotNull DiagramBuilder builder) {
        if (editor == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(1);
        }
        this.myLastActiveNodeEditor = this.myCurrentNodeEditor = editor;
        JComponent editorComponent = this.getCurrentEditorComponent();
        if (editorComponent != null) {
            this.setupEscapeListener(editorComponent, builder);
            IdeFocusManager.getInstance((Project)builder.getProject()).requestFocus((Component)editorComponent, true);
        }
    }

    private void setupEscapeListener(@NotNull JComponent editorComponent, final @NotNull DiagramBuilder builder) {
        if (editorComponent == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(3);
        }
        editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DiagramNodeEditorManager.this.stopEditing(builder);
                }
            }
        });
    }

    @Override
    public void stopEditing(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(4);
        }
        if (this.myCurrentNodeEditor != null) {
            this.myCurrentNodeEditor.stopCellEditing();
            this.myLastActiveNodeEditor = this.myCurrentNodeEditor;
            this.myCurrentNodeEditor = null;
        }
    }

    @Override
    public void cancelEditing(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(5);
        }
        if (this.myCurrentNodeEditor != null) {
            this.myCurrentNodeEditor.cancelCellEditing();
            this.myLastActiveNodeEditor = this.myCurrentNodeEditor;
            this.myCurrentNodeEditor = null;
        }
    }

    @Override
    public boolean isEditing() {
        return this.myCurrentNodeEditor != null;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(6);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            Object selection = ObjectUtils.chooseNotNull((Object)this.getCurrentValue(), (Object)this.getLastActiveValue());
            return selection == null ? null : slowId -> DiagramNodeEditorManager.getSlowData(slowId, selection);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull Object value) {
        if (dataId == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(7);
        }
        if (value == null) {
            DiagramNodeEditorManager.$$$reportNull$$$0(8);
        }
        if (CommonDataKeys.LANGUAGE.is(dataId)) {
            return value instanceof PsiElement ? ((PsiElement)value).getLanguage() : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Navigatable[] navigatableArray;
            if (value instanceof Navigatable) {
                Navigatable[] navigatableArray2 = new Navigatable[1];
                navigatableArray = navigatableArray2;
                navigatableArray2[0] = (Navigatable)value;
            } else {
                navigatableArray = Navigatable.EMPTY_NAVIGATABLE_ARRAY;
            }
            return navigatableArray;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return value instanceof PsiElement ? (PsiElement)value : null;
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return value instanceof PsiElement ? ((PsiElement)value).getContainingFile() : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return value instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)) : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            VirtualFile[] virtualFileArray;
            VirtualFile file;
            VirtualFile virtualFile = file = value instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)) : null;
            if (file != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = file;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            VirtualFile file = value instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)value)) : null;
            return file != null ? Collections.singleton(file) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/editors/DiagramNodeEditorManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startEditing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setupEscapeListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditing";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelEditing";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

