/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.CommonBundle;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.v2.GraphChartFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.uml.EmptyDiagramProvider;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.UmlFileConverter;
import com.intellij.uml.v2.GraphChartFactoryImpl;
import com.intellij.uml.v2.handles.GraphChartHandleImpl;
import com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramElementManager;
import com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramProvider;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jdom.Document;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UmlEditorProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    @NonNls
    public static final String TYPE_ID = "UmlEditorProvider";
    @NotNull
    private static final Logger LOG = Logger.getInstance(UmlEditorProvider.class);

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(1);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && "uml".equalsIgnoreCase(file.getExtension())) {
            if (DumbService.isDumb((Project)project)) {
                return false;
            }
            if (UmlEditorProvider.isNewUmlFormat(file)) {
                return true;
            }
            if (UmlEditorProvider.isOldUmlFormat(file)) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    return this.convertFile(project, file);
                }
                ApplicationManager.getApplication().invokeLater(() -> this.convertFile(project, file));
            }
            return false;
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            UmlVirtualFileSystem.UmlVirtualFile umlVirtualFile = (UmlVirtualFileSystem.UmlVirtualFile)file;
            if (DumbService.isDumb((Project)project)) {
                return false;
            }
            DiagramProvider provider = umlVirtualFile.getUmlProvider();
            if (provider != null) {
                return UmlEditorProvider.getElementFromFile(project, umlVirtualFile) != null || UmlVirtualFileSystem.isShowChangesFile(file);
            }
        }
        return false;
    }

    private boolean convertFile(@NotNull Project project, @NotNull VirtualFile file) {
        Boolean success;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(3);
        }
        if (Messages.showOkCancelDialog((Project)project, (String)DiagramBundle.message("dialog.message.this.file.has.old.format.would.you.like.to.convert.it", new Object[0]), (String)DiagramBundle.message("dialog.title.old.diagram.format", new Object[0]), (Icon)AllIcons.FileTypes.Diagram) == 0 && !(success = (Boolean)WriteAction.computeAndWait(() -> {
            try {
                VirtualFile copy = file.copy((Object)this, file.getParent(), file.getName() + ".bak.xml");
                PsiFile xml = PsiManager.getInstance((Project)project).findFile(copy);
                if (!(xml instanceof XmlFile)) {
                    return false;
                }
                XmlDocument xmlDoc = ((XmlFile)xml).getDocument();
                if (xmlDoc == null) {
                    return false;
                }
                Document doc = UmlFileConverter.convert(xmlDoc);
                boolean result = DiagramState.writeXml(file, project, doc);
                copy.delete(null);
                return result;
            }
            catch (IOException iOException) {
                return false;
            }
        })).booleanValue()) {
            Messages.showErrorDialog((Project)project, (String)DiagramBundle.message("dialog.message.can.t.save.converted.content.into.file.check.read.only.status", new Object[0]), (String)CommonBundle.getErrorTitle());
            return true;
        }
        return false;
    }

    private static boolean isNewUmlFormat(@NotNull VirtualFile file) {
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(4);
        }
        try {
            String beginning = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            return beginning.contains("<Diagramm>") || beginning.contains("<Diagram>");
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static boolean isOldUmlFormat(@NotNull VirtualFile file) {
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(5);
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file, (int)100).contains("<ClassDiagramm>");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Nullable
    private static Object getElementFromFile(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        Object result;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(7);
        }
        DiagramProvider umlProvider = file.getUmlProvider();
        String fileFqn = file.getFQN();
        Object v0 = result = umlProvider != null && fileFqn != null ? umlProvider.getVfsResolver().resolveElementByFQN(fileFqn, project) : null;
        if (result == null && umlProvider != null) {
            Object element = file.getUserData(DiagramDataKeys.ORIGINAL_ELEMENT);
            if (umlProvider.getElementManager().canBeBuiltFrom(element)) {
                if (!(element instanceof PsiElement)) {
                    return element;
                }
                PsiFile psiFile = ((PsiElement)element).getContainingFile();
                if (psiFile != null && ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) {
                    return element;
                }
            }
        }
        return result;
    }

    @Nullable
    private static <T> DiagramProvider<T> getProviderFromFile(@NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        DiagramProvider umlProvider;
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(8);
        }
        if ((umlProvider = file.getUmlProvider()) != null) {
            try {
                Constructor<?> constructor = umlProvider.getClass().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                DiagramProvider provider = (DiagramProvider)constructor.newInstance(new Object[0]);
                if (provider instanceof GraphChartAdapterForDiagramProvider) {
                    ((GraphChartAdapterForDiagramElementManager)provider.getElementManager()).chart = ((GraphChartAdapterForDiagramElementManager)umlProvider.getElementManager()).chart;
                }
                return provider;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor editor;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(10);
        }
        if (DumbService.isDumb((Project)project)) {
            DumbService.getInstance((Project)project).showDumbModeNotificationForFunctionality(DiagramBundle.message("notification.can.t.open.diagram.while.indexing.is.in.progress", new Object[0]), DumbModeBlockedFunctionality.Uml);
            return UmlEditorProvider.createUnknownDiagramEmptyEditor(project, file);
        }
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            return UmlEditorProvider.createEditorFromPsiElement(project, (UmlVirtualFileSystem.UmlVirtualFile)file);
        }
        if (file.getFileSystem() instanceof LocalFileSystem && (editor = UmlEditorProvider.createEditorFromLocalFileSystem(project, file)) != null) {
            FileEditor fileEditor = editor;
            if (fileEditor == null) {
                UmlEditorProvider.$$$reportNull$$$0(11);
            }
            return fileEditor;
        }
        return UmlEditorProvider.createUnknownDiagramEmptyEditor(project, file);
    }

    @Nullable
    private static FileEditor createEditorFromLocalFileSystem(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(13);
        }
        try {
            DiagramState state = DiagramState.read(file.getInputStream());
            DiagramProvider provider = Objects.requireNonNull(DiagramProvider.findByID(state.getProviderID()));
            String originalFQN = state.getOriginalFQN();
            Object originalElement = originalFQN != null ? provider.getVfsResolver().resolveElementByFQN(originalFQN, project) : null;
            DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> DiagramBuilderFactory.getInstance().createBuilder(project, provider, originalElement, file));
            UmlFileEditorImpl editor = new UmlFileEditorImpl(builder, file);
            builder.getDataModel().setModelInitializationFinished();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                editor.setUmlState(state);
            } else {
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    editor.setUmlState(state);
                    EdtScheduledExecutorService.getInstance().schedule(() -> state.restorePositionsOnlyTo(editor.getModelBuilder()), 1L, TimeUnit.SECONDS);
                });
            }
            return editor;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static FileEditor createUnknownDiagramEmptyEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(15);
        }
        DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> DiagramBuilderFactory.getInstance().create(project, new EmptyDiagramProvider(), null, file));
        return new UmlFileEditorImpl(builder, file);
    }

    @NotNull
    private static FileEditor createEditorFromPsiElement(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file) {
        Object originalElement;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(16);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(17);
        }
        if ((originalElement = UmlEditorProvider.getElementFromFile(project, file)) instanceof GraphChartHandleImpl && file.getBuilder() == null) {
            return UmlEditorProvider.createEditorFromGraphChartBuilder((GraphChartHandleImpl)originalElement);
        }
        EmptyDiagramProvider providerFromFile = UmlEditorProvider.getProviderFromFile(file);
        EmptyDiagramProvider provider = providerFromFile != null ? providerFromFile : new EmptyDiagramProvider();
        DiagramBuilder builder = UmlEditorProvider.getOrCreateBuilderForNewEditor(project, file, originalElement, provider);
        if (originalElement != null) {
            String title = ((DiagramProvider)provider).getElementManager().getElementTitle(originalElement);
            file.setPresentableName(title);
        }
        UmlFileEditorImpl editor = new UmlFileEditorImpl(builder, file);
        ReopenInfo.apply(file, builder, originalElement);
        UmlFileEditorImpl umlFileEditorImpl = editor;
        if (umlFileEditorImpl == null) {
            UmlEditorProvider.$$$reportNull$$$0(18);
        }
        return umlFileEditorImpl;
    }

    @NotNull
    private static FileEditor createEditorFromGraphChartBuilder(@NotNull GraphChartHandleImpl<?, ?> chartBuilder) {
        if (chartBuilder == null) {
            UmlEditorProvider.$$$reportNull$$$0(19);
        }
        FileEditor fileEditor = (FileEditor)((GraphChartFactoryImpl)GraphChartFactory.getInstance()).instantiateAndShowInEditorImmediately(chartBuilder).getSecond();
        if (fileEditor == null) {
            UmlEditorProvider.$$$reportNull$$$0(20);
        }
        return fileEditor;
    }

    @NotNull
    private static DiagramBuilder getOrCreateBuilderForNewEditor(@NotNull Project project, @NotNull UmlVirtualFileSystem.UmlVirtualFile file, @Nullable Object originalElement, @NotNull DiagramProvider<?> provider) {
        DiagramBuilder builderFromFile;
        if (project == null) {
            UmlEditorProvider.$$$reportNull$$$0(21);
        }
        if (file == null) {
            UmlEditorProvider.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            UmlEditorProvider.$$$reportNull$$$0(23);
        }
        if ((builderFromFile = file.getBuilder()) == null) {
            DiagramBuilder diagramBuilder = (DiagramBuilder)WriteAction.computeAndWait(() -> DiagramBuilderFactory.getInstance().create(project, provider, originalElement, file));
            if (diagramBuilder == null) {
                UmlEditorProvider.$$$reportNull$$$0(24);
            }
            return diagramBuilder;
        }
        if (builderFromFile.getEditor() == null) {
            DiagramBuilder diagramBuilder = builderFromFile;
            if (diagramBuilder == null) {
                UmlEditorProvider.$$$reportNull$$$0(25);
            }
            return diagramBuilder;
        }
        DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> DiagramBuilderFactory.getInstance().create(project, provider, originalElement, file));
        if (!ReopenInfo.isContains(file)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ReopenInfo.apply(builderFromFile, builder, originalElement);
                builder.queryUpdate().withDataReload().withRelayout().run();
                builder.getGraphBuilder().fitContent(false);
            });
        }
        DiagramBuilder diagramBuilder = builder;
        if (diagramBuilder == null) {
            UmlEditorProvider.$$$reportNull$$$0(26);
        }
        return diagramBuilder;
    }

    @NotNull
    @NonNls
    public String getEditorTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            UmlEditorProvider.$$$reportNull$$$0(27);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 18, 20, 24, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chartBuilder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlEditorProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFromPsiElement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFromGraphChartBuilder";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuilderForNewEditor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNewUmlFormat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOldUmlFormat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProviderFromFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 11: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromLocalFileSystem";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUnknownDiagramEmptyEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromPsiElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFromGraphChartBuilder";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuilderForNewEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 18, 20, 24, 25, 26, 27 -> new IllegalStateException(string);
        };
    }
}

