/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramAlgorithmsService {
    @NotNull
    public static DiagramAlgorithmsService getInstance() {
        DiagramAlgorithmsService diagramAlgorithmsService = (DiagramAlgorithmsService)ApplicationManager.getApplication().getService(DiagramAlgorithmsService.class);
        if (diagramAlgorithmsService == null) {
            DiagramAlgorithmsService.$$$reportNull$$$0(0);
        }
        return diagramAlgorithmsService;
    }

    @NotNull
    public <T> Graph<DiagramNode<T>> toDirectedGraph(@NotNull DiagramDataView<T> var1);

    @NotNull
    public <T> Graph<DiagramNode<T>> toUndirectedGraph(@NotNull DiagramDataView<T> var1);

    @NotNull
    public <T> Set<DiagramEdge<T>> getPathsFromRoot(@NotNull DiagramNode<T> var1, @NotNull Collection<DiagramNode> var2, @NotNull DiagramDataView<T> var3);

    @NotNull
    public <T> Set<DiagramEdge<T>> getPathsFromRoot(@NotNull DiagramNode<T> var1, @NotNull Collection<DiagramNode> var2, @NotNull DiagramDataView<T> var3, @NotNull PathDirection var4);

    @NotNull
    public <T> Set<DiagramNode<T>> collectNodes(@NotNull Collection<DiagramEdge<T>> var1);

    public <T> void removeNonSelectedDependencies(@NotNull DiagramDataModel<T> var1);

    public <T> void removeNonSelectedDependencies(@NotNull DiagramDataView<T> var1, @NotNull List<DiagramNode> var2);

    @RequiresEdt
    @NotNull
    public CompletableFuture<Set<DiagramNode<?>>> findNodesWhichBelongToAnyPathBetweenTwoNodesAsync(@NotNull DiagramBuilder var1, @NotNull PathFindingParams var2);

    @RequiresEdt
    @NotNull
    public CompletableFuture<Set<DiagramNode<?>>> findNodeNeighbourhoodAsync(@NotNull DiagramBuilder var1, @NotNull PathFindingParams var2);

    @RequiresEdt
    @NotNull
    public CompletableFuture<Set<List<DiagramNode<?>>>> findAllSimpleCyclesAsync(@NotNull DiagramBuilder var1, @NotNull PathFindingParams var2);

    @RequiresEdt
    @NotNull
    public CompletableFuture<CommonGraphCharacteristics> computeCommonGraphCharacteristicsAsync(@NotNull DiagramBuilder var1);

    @RequiresEdt
    @NotNull
    public CompletableFuture<Map<DiagramNode<?>, Double>> measureCentralityAsync(@NotNull DiagramBuilder var1, @NotNull CentralityMeasureType var2);

    @RequiresEdt
    @NotNull
    public CompletableFuture<Map<DiagramNode<?>, Integer>> runAutoClusteringAsync(@NotNull DiagramBuilder var1, @NotNull ClusteringType var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/util/DiagramAlgorithmsService", "getInstance"));
    }

    public static final class CommonGraphCharacteristics {
        private final int myNodeCount;
        private final int myEdgeCount;
        private final double myAverageDegree;
        private final double myDensity;
        private final boolean myContainsSelfLoops;
        private final boolean myIsSimple;
        private final boolean myContainsMultipleEdges;
        private final boolean myIsConnected;
        private final boolean myIsBiconnected;
        private final boolean myIsStronglyConnected;
        private final boolean myIsAcyclic;
        private final boolean myIsBipartite;
        private final boolean myIsPlanar;
        private final boolean myIsForest;
        private final boolean myIsTree;

        public CommonGraphCharacteristics(int nodeCount, int edgeCount, double averageDegree, double density, boolean containsSelfLoops, boolean isSimple, boolean containsMultipleEdges, boolean isConnected, boolean isBiconnected, boolean isStronglyConnected, boolean isAcyclic, boolean isBipartite, boolean isPlanar, boolean isForest, boolean isTree) {
            this.myNodeCount = nodeCount;
            this.myEdgeCount = edgeCount;
            this.myAverageDegree = averageDegree;
            this.myDensity = density;
            this.myContainsSelfLoops = containsSelfLoops;
            this.myIsSimple = isSimple;
            this.myContainsMultipleEdges = containsMultipleEdges;
            this.myIsConnected = isConnected;
            this.myIsBiconnected = isBiconnected;
            this.myIsStronglyConnected = isStronglyConnected;
            this.myIsAcyclic = isAcyclic;
            this.myIsBipartite = isBipartite;
            this.myIsPlanar = isPlanar;
            this.myIsForest = isForest;
            this.myIsTree = isTree;
        }

        public int getNodeCount() {
            return this.myNodeCount;
        }

        public int getEdgeCount() {
            return this.myEdgeCount;
        }

        public double getAverageDegree() {
            return this.myAverageDegree;
        }

        public double getDensity() {
            return this.myDensity;
        }

        public boolean isContainsSelfLoops() {
            return this.myContainsSelfLoops;
        }

        public boolean isSimple() {
            return this.myIsSimple;
        }

        public boolean isContainsMultipleEdges() {
            return this.myContainsMultipleEdges;
        }

        public boolean isConnected() {
            return this.myIsConnected;
        }

        public boolean isBiconnected() {
            return this.myIsBiconnected;
        }

        public boolean isStronglyConnected() {
            return this.myIsStronglyConnected;
        }

        public boolean isAcyclic() {
            return this.myIsAcyclic;
        }

        public boolean isBipartite() {
            return this.myIsBipartite;
        }

        public boolean isPlanar() {
            return this.myIsPlanar;
        }

        public boolean isForest() {
            return this.myIsForest;
        }

        public boolean isTree() {
            return this.myIsTree;
        }
    }

    public static interface ClusteringType {

        public static final class KMeans
        implements ClusteringType {
            private int myBound;

            public KMeans(int bound) {
                this.myBound = bound;
            }

            public int getBound() {
                return this.myBound;
            }
        }

        public static final class EdgeBetweenness
        implements ClusteringType {
            private double myQualityTimeRatio;

            public EdgeBetweenness(double qualityTimeRatio) {
                this.myQualityTimeRatio = qualityTimeRatio;
            }

            public double getQualityTimeRatio() {
                return this.myQualityTimeRatio;
            }
        }

        public static final class Biconnected
        implements ClusteringType {
        }
    }

    public static interface CentralityMeasureType {

        public static final class ClosenessCentrality
        implements CentralityMeasureType {
            private final boolean myConsiderEdgeDirections;

            public ClosenessCentrality(boolean directions) {
                this.myConsiderEdgeDirections = directions;
            }

            public boolean isConsiderEdgeDirections() {
                return this.myConsiderEdgeDirections;
            }
        }

        public static final class GraphCentrality
        implements CentralityMeasureType {
            private final boolean myConsiderEdgeDirections;

            public GraphCentrality(boolean directions) {
                this.myConsiderEdgeDirections = directions;
            }

            public boolean isConsiderEdgeDirections() {
                return this.myConsiderEdgeDirections;
            }
        }

        public static final class NodeBetweenness
        implements CentralityMeasureType {
            private final boolean myConsiderEdgeDirections;

            public NodeBetweenness(boolean directions) {
                this.myConsiderEdgeDirections = directions;
            }

            public boolean isConsiderEdgeDirections() {
                return this.myConsiderEdgeDirections;
            }
        }

        public static final class DegreeCentrality
        implements CentralityMeasureType {
            private final boolean myConsiderInEdges;
            private final boolean myConsiderOutEdges;

            public DegreeCentrality(boolean considerInEdges, boolean considerOutEdges) {
                this.myConsiderInEdges = considerInEdges;
                this.myConsiderOutEdges = considerOutEdges;
            }

            public boolean isConsiderInEdges() {
                return this.myConsiderInEdges;
            }

            public boolean isConsiderOutEdges() {
                return this.myConsiderOutEdges;
            }
        }
    }

    public static final class PathFindingParams {
        @Nullable
        private DiagramNode<?> mySource;
        @Nullable
        private DiagramNode<?> myTarget;
        @NotNull
        private PathDirection myPathDirection;
        @NotNull
        private PathFilter myPathFilter;

        public PathFindingParams(@Nullable DiagramNode<?> source, @Nullable DiagramNode<?> target, @NotNull PathDirection pathDirection, @NotNull PathFilter pathFilter) {
            if (pathDirection == null) {
                PathFindingParams.$$$reportNull$$$0(0);
            }
            if (pathFilter == null) {
                PathFindingParams.$$$reportNull$$$0(1);
            }
            this.mySource = source;
            this.myTarget = target;
            this.myPathDirection = pathDirection;
            this.myPathFilter = pathFilter;
        }

        @Nullable
        public DiagramNode<?> getSource() {
            return this.mySource;
        }

        @Nullable
        public DiagramNode<?> getTarget() {
            return this.myTarget;
        }

        @NotNull
        public PathDirection getPathDirection() {
            PathDirection pathDirection = this.myPathDirection;
            if (pathDirection == null) {
                PathFindingParams.$$$reportNull$$$0(2);
            }
            return pathDirection;
        }

        @NotNull
        public PathFilter getPathFilter() {
            PathFilter pathFilter = this.myPathFilter;
            if (pathFilter == null) {
                PathFindingParams.$$$reportNull$$$0(3);
            }
            return pathFilter;
        }

        public void setSource(@Nullable DiagramNode<?> source) {
            this.mySource = source;
        }

        public void setTarget(@Nullable DiagramNode<?> target) {
            this.myTarget = target;
        }

        public void setPathDirection(@NotNull PathDirection pathDirection) {
            if (pathDirection == null) {
                PathFindingParams.$$$reportNull$$$0(4);
            }
            this.myPathDirection = pathDirection;
        }

        public void setPathFilter(@NotNull PathFilter pathFilter) {
            if (pathFilter == null) {
                PathFindingParams.$$$reportNull$$$0(5);
            }
            this.myPathFilter = pathFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathFindingParams params = (PathFindingParams)o;
            return Objects.equals(this.mySource, params.mySource) && Objects.equals(this.myTarget, params.myTarget) && this.myPathDirection == params.myPathDirection && this.myPathFilter.equals(params.myPathFilter);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mySource, this.myTarget, this.myPathDirection, this.myPathFilter});
        }

        public String toString() {
            return "PathFindingParams{mySource=" + this.mySource + ", myTarget=" + this.myTarget + ", myPathDirection=" + this.myPathDirection + ", myPathFilter=" + this.myPathFilter + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathDirection";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathFilter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFindingParams";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFindingParams";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathDirection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setPathDirection";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setPathFilter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface PathFilter {

        public static final class ContainingAnyControlPoints
        implements PathFilter {
            @NotNull
            private final Collection<DiagramNode<?>> myControlPoints;

            public ContainingAnyControlPoints(@NotNull Collection<DiagramNode<?>> points) {
                if (points == null) {
                    ContainingAnyControlPoints.$$$reportNull$$$0(0);
                }
                this.myControlPoints = points;
            }

            @NotNull
            public Collection<DiagramNode<?>> getControlPoints() {
                Collection<DiagramNode<?>> collection = this.myControlPoints;
                if (collection == null) {
                    ContainingAnyControlPoints.$$$reportNull$$$0(1);
                }
                return collection;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ContainingAnyControlPoints points = (ContainingAnyControlPoints)o;
                return this.myControlPoints.equals(points.myControlPoints);
            }

            public int hashCode() {
                return Objects.hash(this.myControlPoints);
            }

            public String toString() {
                return "ContainingAnyControlPoints{myControlPoints=" + this.myControlPoints + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "points";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFilter$ContainingAnyControlPoints";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFilter$ContainingAnyControlPoints";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getControlPoints";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public static final class ContainingAllControlPoints
        implements PathFilter {
            @NotNull
            private final Collection<DiagramNode<?>> myControlPoints;

            public ContainingAllControlPoints(@NotNull Collection<DiagramNode<?>> points) {
                if (points == null) {
                    ContainingAllControlPoints.$$$reportNull$$$0(0);
                }
                this.myControlPoints = points;
            }

            @NotNull
            public Collection<DiagramNode<?>> getControlPoints() {
                Collection<DiagramNode<?>> collection = this.myControlPoints;
                if (collection == null) {
                    ContainingAllControlPoints.$$$reportNull$$$0(1);
                }
                return collection;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ContainingAllControlPoints points = (ContainingAllControlPoints)o;
                return this.myControlPoints.equals(points.myControlPoints);
            }

            public int hashCode() {
                return Objects.hash(this.myControlPoints);
            }

            public String toString() {
                return "ContainingAllControlPoints{myControlPoints=" + this.myControlPoints + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "points";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFilter$ContainingAllControlPoints";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diagram/util/DiagramAlgorithmsService$PathFilter$ContainingAllControlPoints";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getControlPoints";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public static final class KShortest
        implements PathFilter {
            private final int myBound;

            public KShortest(int bound) {
                this.myBound = bound;
            }

            public int getBound() {
                return this.myBound;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                KShortest shortest = (KShortest)o;
                return this.myBound == shortest.myBound;
            }

            public int hashCode() {
                return Objects.hash(this.myBound);
            }

            public String toString() {
                return "KShortest{myBound=" + this.myBound + "}";
            }
        }

        public static final class All
        implements PathFilter {
            @NotNull
            private static final All INSTANCE = new All();

            private All() {
            }

            @NotNull
            public static All getInstance() {
                All all = INSTANCE;
                if (all == null) {
                    All.$$$reportNull$$$0(0);
                }
                return all;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/util/DiagramAlgorithmsService$PathFilter$All", "getInstance"));
            }
        }
    }

    public static enum PathDirection {
        DIRECTED_SOURCE_TO_TARGET,
        DIRECTED_TARGET_TO_SOURCE,
        DIRECTED_BOTH,
        UNDIRECTED;

    }
}

