/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.diagram.state.DiagramSnapshotFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class DiagramEdgesParamSnapshot<P extends EdgeParamSnapshot>
implements DiagramSnapshot {
    @NotNull
    private final Map<DiagramEdgeIdentity<Object>, P> myEdgesParams;

    private DiagramEdgesParamSnapshot(@NotNull Map<DiagramEdgeIdentity<Object>, P> edgesParams) {
        if (edgesParams == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(0);
        }
        this.myEdgesParams = edgesParams;
    }

    public boolean containsRecordFor(@NotNull DiagramEdge<?> edge) {
        if (edge == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(1);
        }
        return this.myEdgesParams.containsKey(DiagramEdgeIdentity.of(edge));
    }

    @NotNull
    public Set<DiagramEdgeIdentity<Object>> getRecordedEdgeElements() {
        Set<DiagramEdgeIdentity<Object>> set = this.myEdgesParams.keySet();
        if (set == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(3);
        }
        CompletableFuture completableFuture = builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            for (DiagramEdge<?> edge : builder.getEdgeObjects()) {
                EdgeParamSnapshot param = (EdgeParamSnapshot)this.myEdgesParams.get(DiagramEdgeIdentity.of(edge));
                if (param == null) continue;
                param.restoreTo(builder, edge);
            }
        });
        if (completableFuture == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    public void restore(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramEdgesParamSnapshot.$$$reportNull$$$0(5);
        }
        for (DiagramEdge<?> edge : builder.getEdgeObjects()) {
            EdgeParamSnapshot param = (EdgeParamSnapshot)this.myEdgesParams.get(DiagramEdgeIdentity.of(edge));
            if (param == null) continue;
            param.restoreTo(builder, edge);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgesParams";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramEdgesParamSnapshot";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramEdgesParamSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordedEdgeElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsRecordFor";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static interface EdgeParamSnapshot {
        public void restoreTo(@NotNull DiagramBuilder var1, @NotNull DiagramEdge<?> var2);
    }

    public static final class Factory<P extends EdgeParamSnapshot>
    implements DiagramSnapshotFactory<DiagramEdgesParamSnapshot<P>> {
        @NotNull
        private final EdgeParamSnapshotFactory<P> myEdgeSnapshotFactory;

        private Factory(@NotNull EdgeParamSnapshotFactory<P> edgeParamSnapshotFactory) {
            if (edgeParamSnapshotFactory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            this.myEdgeSnapshotFactory = edgeParamSnapshotFactory;
        }

        @NotNull
        public static <P extends EdgeParamSnapshot> Factory<P> create(@NotNull EdgeParamSnapshotFactory<P> edgeParamSnapshotFactory) {
            if (edgeParamSnapshotFactory == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new Factory<P>(edgeParamSnapshotFactory);
        }

        @Override
        @NotNull
        public DiagramEdgesParamSnapshot<P> makeSnapshot(@NotNull DiagramBuilder builder) {
            if (builder == null) {
                Factory.$$$reportNull$$$0(2);
            }
            builder.getGraphBuilder().getActionExecutor().assertReadAccess();
            return new DiagramEdgesParamSnapshot(ContainerUtil.map2Map(builder.getEdgeObjects(), edge -> Pair.create(DiagramEdgeIdentity.of(edge), this.myEdgeSnapshotFactory.makeSnapshot(builder, (DiagramEdge<?>)edge))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeParamSnapshotFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/state/DiagramEdgesParamSnapshot$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "makeSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface EdgeParamSnapshotFactory<P extends EdgeParamSnapshot> {
        @NotNull
        public P makeSnapshot(@NotNull DiagramBuilder var1, @NotNull DiagramEdge<?> var2);
    }
}

