/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.options;

import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.typescript.service.volar.VolarExecutableDownloader;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsState;

@Service(value={Service.Level.PROJECT})
@State(name="VueSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/vuejs/options/VueSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/jetbrains/vuejs/options/VueSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "packageRef", "getPackageRef", "()Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "setPackageRef", "(Lcom/intellij/javascript/nodejs/util/NodePackageRef;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/vuejs/options/VueServiceSettings;", "serviceType", "getServiceType", "()Lorg/jetbrains/vuejs/options/VueServiceSettings;", "setServiceType", "(Lorg/jetbrains/vuejs/options/VueServiceSettings;)V", "intellij.vuejs"})
public final class VueSettings
extends SimplePersistentStateComponent<VueSettingsState> {
    @NotNull
    private final Project project;

    public VueSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new VueSettingsState());
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VueServiceSettings getServiceType() {
        return ((VueSettingsState)this.getState()).getInnerServiceType();
    }

    public final void setServiceType(@NotNull VueServiceSettings value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        boolean changed = ((VueSettingsState)this.getState()).getInnerServiceType() != value;
        ((VueSettingsState)this.getState()).setInnerServiceType(value);
        if (changed) {
            JSFrameworkLspServerDescriptorKt.restartTypeScriptServicesAsync((Project)this.project);
        }
    }

    @NotNull
    public final NodePackageRef getPackageRef() {
        return ExternalDefinitionsNodePackageKt.createPackageRef((String)((VueSettingsState)this.getState()).getPackageName(), (TypeScriptPackageName)VolarExecutableDownloader.INSTANCE.getPackageDescriptor().getServerPackage());
    }

    public final void setPackageRef(@NotNull NodePackageRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String refText = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)value);
        boolean changed = !Intrinsics.areEqual((Object)((VueSettingsState)this.getState()).getPackageName(), (Object)refText);
        ((VueSettingsState)this.getState()).setPackageName(refText);
        if (changed) {
            JSFrameworkLspServerDescriptorKt.restartTypeScriptServicesAsync((Project)this.project);
        }
    }
}

