/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.model.Pointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueEntitiesContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "name", "", "source", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "defaultName", "getDefaultName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "getSource", "()Lcom/intellij/psi/PsiElement;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs"})
public final class VueSourceDirective
implements VueDirective {
    @NotNull
    private final PsiElement source;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<VueEntitiesContainer> parents;

    public VueSourceDirective(@NotNull String name, @NotNull PsiElement source2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.source = source2;
        this.defaultName = name;
        this.parents = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceDirective && Intrinsics.areEqual((Object)((VueSourceDirective)other).getDefaultName(), (Object)this.getDefaultName()) && Intrinsics.areEqual((Object)((VueSourceDirective)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getDefaultName(), this.getSource()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "VueSourceDirective(" + this.getDefaultName() + ")";
    }

    @NotNull
    public Pointer<VueDirective> createPointer() {
        String name = this.getDefaultName();
        SmartPsiElementPointer source2 = SmartPointersKt.createSmartPointer((PsiElement)this.getSource());
        return () -> VueSourceDirective.createPointer$lambda$0(source2, name);
    }

    private static final VueDirective createPointer$lambda$0(SmartPsiElementPointer $source, String $name) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        PsiElement psiElement = $source.dereference();
        if (psiElement == null) {
            return null;
        }
        PsiElement newSource = psiElement;
        return new VueSourceDirective($name, newSource);
    }
}

