/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.nuxt.library;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderEntity;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderLibrary;
import org.jetbrains.vuejs.libraries.nuxt.library.NuxtFolderManagerState;

@Service(value={Service.Level.PROJECT})
@State(name="DotNuxtFolderManager", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002$%B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0002H\u0016R4\u0010\u0007\u001a(\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n \f*\u0012\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n0\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManagerState;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "nuxtFolders", "", "getNuxtFolders", "()Ljava/util/List;", "addExcludeEntity", "", "nuxtFolder", "addIfMissing", "addOrUpdateLibraryEntity", "dispose", "doCreateLibrary", "findEntities", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "nuxtFolderUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getState", "isAccepted", "", "asNewFolder", "loadState", "state", "Companion", "NuxtFileListener", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n766#2:187\n857#2,2:188\n1549#2:190\n1620#2,3:191\n1603#2,9:194\n1855#2:203\n1856#2:205\n1612#2:206\n1#3:204\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager\n*L\n32#1:187\n32#1:188,2\n40#1:190\n40#1:191,3\n45#1:194,9\n45#1:203\n45#1:205\n45#1:206\n45#1:204\n*E\n"})
public final class NuxtFolderManager
implements PersistentStateComponent<NuxtFolderManagerState>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> folders;

    public NuxtFolderManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"newConcurrentSet(...)");
        this.folders = set;
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new NuxtFileListener(), (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getNuxtFolders() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.folders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NuxtFolderManagerState getState() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        NuxtFolderManagerState nuxtFolderManagerState;
        NuxtFolderManagerState it = nuxtFolderManagerState = new NuxtFolderManagerState();
        boolean bl = false;
        Iterable iterable = this.folders;
        NuxtFolderManagerState nuxtFolderManagerState2 = it;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void folder;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(folder.getPath());
        }
        nuxtFolderManagerState2.setFolders$intellij_vuejs((List)destination$iv$iv);
        return nuxtFolderManagerState;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull NuxtFolderManagerState state2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Iterable $this$mapNotNull$iv = state2.getFolders$intellij_vuejs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(it);
            if ((file != null && this.isAccepted(file, false) ? file : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newFolders = (List)destination$iv$iv;
        this.folders.clear();
        this.folders.addAll(newFolders);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccepted(VirtualFile nuxtFolder, boolean asNewFolder) {
        if (!nuxtFolder.isValid()) return false;
        if (!NuxtFolderManager.Companion.isNuxtFolder(nuxtFolder)) return false;
        Object object = ReadAction.compute(() -> NuxtFolderManager.isAccepted$lambda$4(asNewFolder, this, nuxtFolder));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        if ((Boolean)object == false) return false;
        return true;
    }

    public final void addIfMissing(@NotNull VirtualFile nuxtFolder) {
        Intrinsics.checkNotNullParameter((Object)nuxtFolder, (String)"nuxtFolder");
        if (!this.folders.contains(nuxtFolder) && this.isAccepted(nuxtFolder, true) && this.folders.add(nuxtFolder)) {
            this.addExcludeEntity(nuxtFolder);
            this.addOrUpdateLibraryEntity(nuxtFolder);
        }
    }

    private final void addExcludeEntity(VirtualFile nuxtFolder) {
        Companion.invokeUnderWriteAction(this.project, () -> NuxtFolderManager.addExcludeEntity$lambda$5(this, nuxtFolder));
    }

    private final void addOrUpdateLibraryEntity(VirtualFile nuxtFolder) {
        Function0 runnable2 = (Function0)new Function0<Unit>(this, nuxtFolder){
            final /* synthetic */ NuxtFolderManager this$0;
            final /* synthetic */ VirtualFile $nuxtFolder;
            {
                this.this$0 = $receiver;
                this.$nuxtFolder = $nuxtFolder;
                super(0);
            }

            public final void invoke() {
                NuxtFolderManager.access$doCreateLibrary(this.this$0, this.$nuxtFolder);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || !application.isDispatchThread() && !application.isReadAccessAllowed()) {
            runnable2.invoke();
        } else {
            application.executeOnPooledThread(() -> NuxtFolderManager.addOrUpdateLibraryEntity$lambda$6(runnable2));
        }
    }

    private final void doCreateLibrary(VirtualFile nuxtFolder) {
        NuxtFolderLibrary library = new NuxtFolderLibrary(nuxtFolder);
        Companion.invokeUnderWriteAction(this.project, () -> NuxtFolderManager.doCreateLibrary$lambda$7(this, nuxtFolder, library));
    }

    private final List<WorkspaceEntity> findEntities(EntityStorage storage, VirtualFileUrl nuxtFolderUrl) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)storage.getVirtualFileUrlIndex().findEntitiesByUrl(nuxtFolderUrl), (Function1)((Function1)new Function1<WorkspaceEntity, Boolean>(nuxtFolderUrl){
            final /* synthetic */ VirtualFileUrl $nuxtFolderUrl;
            {
                this.$nuxtFolderUrl = $nuxtFolderUrl;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WorkspaceEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof NuxtFolderEntity && Intrinsics.areEqual((Object)((NuxtFolderEntity)it).getNuxtFolderUrl(), (Object)this.$nuxtFolderUrl);
            }
        })));
    }

    public void dispose() {
    }

    private static final Boolean isAccepted$lambda$4(boolean $asNewFolder, NuxtFolderManager this$0, VirtualFile $nuxtFolder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nuxtFolder, (String)"$nuxtFolder");
        return $asNewFolder ? ProjectFileIndex.getInstance((Project)this$0.project).isInContent($nuxtFolder) : JSLibraryUtil.isInProjectAndOutsideOfLibraryRoots((Project)this$0.project, (VirtualFile)$nuxtFolder);
    }

    private static final void addExcludeEntity$lambda$5(NuxtFolderManager this$0, VirtualFile $nuxtFolder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nuxtFolder, (String)"$nuxtFolder");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this$0.project);
        workspaceModel.updateProjectModel("Exclude .nuxt/ for " + $nuxtFolder.getPath(), (Function1)new Function1<MutableEntityStorage, Unit>(workspaceModel, $nuxtFolder, this$0){
            final /* synthetic */ WorkspaceModel $workspaceModel;
            final /* synthetic */ VirtualFile $nuxtFolder;
            final /* synthetic */ NuxtFolderManager this$0;
            {
                this.$workspaceModel = $workspaceModel;
                this.$nuxtFolder = $nuxtFolder;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage storage) {
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                VirtualFileUrlManager virtualFileUrlManager = this.$workspaceModel.getVirtualFileUrlManager();
                VirtualFileUrl nuxtFolderUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)this.$nuxtFolder, (VirtualFileUrlManager)virtualFileUrlManager);
                List entities = NuxtFolderManager.access$findEntities(this.this$0, (EntityStorage)storage, nuxtFolderUrl);
                Iterable $this$forEach$iv = entities;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WorkspaceEntity p0 = (WorkspaceEntity)element$iv;
                    boolean bl = false;
                    storage.removeEntity(p0);
                }
                storage.addEntity((WorkspaceEntity.Builder)NuxtFolderEntity.Companion.create$default(NuxtFolderEntity.Companion, nuxtFolderUrl, CollectionsKt.emptyList(), NuxtFolderEntity.MyEntitySource.INSTANCE, null, 8, null));
            }
        });
    }

    private static final void addOrUpdateLibraryEntity$lambda$6(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void doCreateLibrary$lambda$7(NuxtFolderManager this$0, VirtualFile $nuxtFolder, NuxtFolderLibrary $library) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nuxtFolder, (String)"$nuxtFolder");
        Intrinsics.checkNotNullParameter((Object)$library, (String)"$library");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this$0.project);
        workspaceModel.updateProjectModel("Include library files from .nuxt/ for " + $nuxtFolder.getPath(), (Function1)new Function1<MutableEntityStorage, Unit>(workspaceModel, $nuxtFolder, this$0, $library){
            final /* synthetic */ WorkspaceModel $workspaceModel;
            final /* synthetic */ VirtualFile $nuxtFolder;
            final /* synthetic */ NuxtFolderManager this$0;
            final /* synthetic */ NuxtFolderLibrary $library;
            {
                this.$workspaceModel = $workspaceModel;
                this.$nuxtFolder = $nuxtFolder;
                this.this$0 = $receiver;
                this.$library = $library;
                super(1);
            }

            public final void invoke(@NotNull MutableEntityStorage storage) {
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                VirtualFileUrlManager virtualFileUrlManager = this.$workspaceModel.getVirtualFileUrlManager();
                VirtualFileUrl nuxtFolderUrl = VirtualFileUrls.toVirtualFileUrl((VirtualFile)this.$nuxtFolder, (VirtualFileUrlManager)virtualFileUrlManager);
                List entities = NuxtFolderManager.access$findEntities(this.this$0, (EntityStorage)storage, nuxtFolderUrl);
                Iterable $this$forEach$iv = entities;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    WorkspaceEntity p0 = (WorkspaceEntity)element$iv;
                    boolean bl = false;
                    storage.removeEntity(p0);
                }
                storage.addEntity((WorkspaceEntity.Builder)NuxtFolderManager.Companion.createEntity$intellij_vuejs(this.$library, virtualFileUrlManager));
            }
        });
    }

    public static final /* synthetic */ void access$doCreateLibrary(NuxtFolderManager $this, VirtualFile nuxtFolder) {
        $this.doCreateLibrary(nuxtFolder);
    }

    public static final /* synthetic */ void access$addOrUpdateLibraryEntity(NuxtFolderManager $this, VirtualFile nuxtFolder) {
        $this.addOrUpdateLibraryEntity(nuxtFolder);
    }

    public static final /* synthetic */ Set access$getFolders$p(NuxtFolderManager $this) {
        return $this.folders;
    }

    public static final /* synthetic */ List access$findEntities(NuxtFolderManager $this, EntityStorage storage, VirtualFileUrl nuxtFolderUrl) {
        return $this.findEntities(storage, nuxtFolderUrl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion;", "", "()V", "createEntity", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderEntity$Builder;", "library", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderLibrary;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "createEntity$intellij_vuejs", "getInstance", "Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;", "project", "Lcom/intellij/openapi/project/Project;", "invokeUnderWriteAction", "", "runnable", "Ljava/lang/Runnable;", "isNuxtFolder", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n31#2,2:187\n1549#3:189\n1620#3,3:190\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$Companion\n*L\n122#1:187,2\n143#1:189\n143#1:190,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NuxtFolderManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NuxtFolderManager> serviceClass$iv = NuxtFolderManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NuxtFolderManager)object;
        }

        private final boolean isNuxtFolder(VirtualFile file) {
            return file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)".nuxt");
        }

        public final void invokeUnderWriteAction(@NotNull Project project, @NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                WriteAction.runAndWait(() -> Companion.invokeUnderWriteAction$lambda$0(runnable2));
            }
            Function0 runnableUnderWriteAction2 = (Function0)new Function0<Unit>(application, runnable2){
                final /* synthetic */ Application $application;
                final /* synthetic */ Runnable $runnable;
                {
                    this.$application = $application;
                    this.$runnable = $runnable;
                    super(0);
                }

                public final void invoke() {
                    this.$application.runWriteAction(this.$runnable);
                }
            };
            if (application.isWriteIntentLockAcquired()) {
                runnableUnderWriteAction2.invoke();
            } else {
                application.invokeLater(() -> Companion.invokeUnderWriteAction$lambda$1(runnableUnderWriteAction2), application.getDefaultModalityState(), project.getDisposed());
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NuxtFolderEntity.Builder createEntity$intellij_vuejs(@NotNull NuxtFolderLibrary library, @NotNull VirtualFileUrlManager virtualFileUrlManager) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
            Iterable $this$map$iv = library.getLibraryFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VirtualFileUrls.toVirtualFileUrl((VirtualFile)it, (VirtualFileUrlManager)virtualFileUrlManager));
            }
            List fileUrls = (List)destination$iv$iv;
            return NuxtFolderEntity.Companion.create$default(NuxtFolderEntity.Companion, VirtualFileUrls.toVirtualFileUrl((VirtualFile)library.getNuxtFolder(), (VirtualFileUrlManager)virtualFileUrlManager), fileUrls, NuxtFolderEntity.MyEntitySource.INSTANCE, null, 8, null);
        }

        private static final void invokeUnderWriteAction$lambda$0(Runnable $runnable) {
            Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
            $runnable.run();
        }

        private static final void invokeUnderWriteAction$lambda$1(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "(Lorg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager;)V", "findNuxtFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "isRelevantEvent", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "intellij.vuejs"})
    @SourceDebugExtension(value={"SMAP\nNuxtFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n766#2:187\n857#2,2:188\n*S KotlinDebug\n*F\n+ 1 NuxtFolderManager.kt\norg/jetbrains/vuejs/libraries/nuxt/library/NuxtFolderManager$NuxtFileListener\n*L\n150#1:187\n150#1:188,2\n*E\n"})
    private final class NuxtFileListener
    implements AsyncFileListener {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable $this$filter$iv = events;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VFileEvent it = (VFileEvent)element$iv$iv;
                boolean bl = false;
                if (!this.isRelevantEvent(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List relevantEvents = (List)destination$iv$iv;
            return relevantEvents.isEmpty() ? null : (AsyncFileListener.ChangeApplier)new AsyncFileListener.ChangeApplier(relevantEvents, this, NuxtFolderManager.this){
                final /* synthetic */ List<VFileEvent> $relevantEvents;
                final /* synthetic */ NuxtFileListener this$0;
                final /* synthetic */ NuxtFolderManager this$1;
                {
                    this.$relevantEvents = $relevantEvents;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void afterVfsChange() {
                    for (VFileEvent event : this.$relevantEvents) {
                        VirtualFile virtualFile;
                        if (!(event instanceof VFileCreateEvent)) continue;
                        VirtualFile virtualFile2 = ((VFileCreateEvent)event).getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
                        if (NuxtFileListener.access$findNuxtFolder(this.this$0, virtualFile2) == null) continue;
                        NuxtFolderManager nuxtFolderManager = this.this$1;
                        VirtualFile it = virtualFile;
                        boolean bl = false;
                        NuxtFolderManager.access$addOrUpdateLibraryEntity(nuxtFolderManager, it);
                    }
                }
            };
        }

        private final VirtualFile findNuxtFolder(VirtualFile file) {
            return (VirtualFile)JSProjectUtil.traverseUpAndFindFirst((VirtualFile)file, arg_0 -> NuxtFileListener.findNuxtFolder$lambda$1((Function1)new Function1<VirtualFile, VirtualFile>(NuxtFolderManager.this){
                final /* synthetic */ NuxtFolderManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final VirtualFile invoke(VirtualFile it) {
                    return NuxtFolderManager.access$getFolders$p(this.this$0).contains(it) ? it : null;
                }
            }, arg_0));
        }

        private final boolean isRelevantEvent(VFileEvent event) {
            if (event instanceof VFileCreateEvent) {
                VirtualFile virtualFile = ((VFileCreateEvent)event).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                return this.findNuxtFolder(virtualFile) != null;
            }
            return false;
        }

        private static final VirtualFile findNuxtFolder$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (VirtualFile)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ VirtualFile access$findNuxtFolder(NuxtFileListener $this, VirtualFile file) {
            return $this.findNuxtFolder(file);
        }
    }
}

