/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service.volar;

import com.google.gson.JsonElement;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetElementTypeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetSymbolTypeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetTypePropertiesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptService;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.expr.VueTSLanguage;
import org.jetbrains.vuejs.lang.typescript.service.VueServiceSetActivationRule;
import org.jetbrains.vuejs.lang.typescript.service.volar.VolarSupportProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/volar/VolarTypeScriptService;", "Lcom/intellij/lang/typescript/lsp/BaseLspTypeScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "name", "", "getName", "()Ljava/lang/String;", "prefix", "getPrefix", "createQuickInfoResponse", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptQuickInfoResponse;", "markupContent", "Lorg/eclipse/lsp4j/MarkupContent;", "getIdeSymbolType", "Lcom/google/gson/JsonElement;", "args", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetSymbolTypeRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetSymbolTypeRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIdeType", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetElementTypeRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetElementTypeRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIdeTypeProperties", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetTypePropertiesRequestArgs;", "(Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptGetTypePropertiesRequestArgs;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAcceptable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "supportsInjectedFile", "Lcom/intellij/psi/PsiFile;", "supportsTypeEvaluation", "virtualFile", "element", "Lcom/intellij/psi/PsiElement;", "intellij.vuejs"})
public final class VolarTypeScriptService
extends BaseLspTypeScriptService {
    public VolarTypeScriptService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, VolarSupportProvider.class);
    }

    @NotNull
    public String getName() {
        return VueBundle.message("vue.service.name", new Object[0]);
    }

    @NotNull
    public String getPrefix() {
        return VueBundle.message("vue.service.prefix", new Object[0]);
    }

    public boolean isAcceptable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return VueServiceSetActivationRule.INSTANCE.isLspServerEnabledAndAvailable(this.getProject(), file);
    }

    @NotNull
    protected TypeScriptQuickInfoResponse createQuickInfoResponse(@NotNull MarkupContent markupContent) {
        Intrinsics.checkNotNullParameter((Object)markupContent, (String)"markupContent");
        String internalVolarLeakMarker = "```typescript\nlet __VLS_ctx";
        String hrMarker = "\n\n---\n\n";
        String string = markupContent.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        if (StringsKt.startsWith$default((String)string, (String)internalVolarLeakMarker, (boolean)false, (int)2, null)) {
            String string2 = markupContent.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            int index = StringsKt.indexOf$default((CharSequence)string2, (String)hrMarker, (int)0, (boolean)false, (int)6, null);
            if (index > -1) {
                String string3 = markupContent.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                String string4 = string3;
                int n = index + hrMarker.length();
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                markupContent.setValue(string5);
            }
        }
        return super.createQuickInfoResponse(markupContent);
    }

    @Nullable
    public Object getIdeType(@NotNull TypeScriptGetElementTypeRequestArgs args, @NotNull Continuation<? super JsonElement> $completion) {
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl server = lspServerImpl;
        return server.sendRequest((Function1)new Function1<LanguageServer, CompletableFuture<JsonElement>>(args){
            final /* synthetic */ TypeScriptGetElementTypeRequestArgs $args;
            {
                this.$args = $args;
                super(1);
            }

            @NotNull
            public final CompletableFuture<JsonElement> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ((JSFrameworkLsp4jServer)it).getElementType(this.$args);
            }
        }, $completion);
    }

    @Nullable
    public Object getIdeSymbolType(@NotNull TypeScriptGetSymbolTypeRequestArgs args, @NotNull Continuation<? super JsonElement> $completion) {
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl server = lspServerImpl;
        return server.sendRequest((Function1)new Function1<LanguageServer, CompletableFuture<JsonElement>>(args){
            final /* synthetic */ TypeScriptGetSymbolTypeRequestArgs $args;
            {
                this.$args = $args;
                super(1);
            }

            @NotNull
            public final CompletableFuture<JsonElement> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ((JSFrameworkLsp4jServer)it).getSymbolType(this.$args);
            }
        }, $completion);
    }

    @Nullable
    public Object getIdeTypeProperties(@NotNull TypeScriptGetTypePropertiesRequestArgs args, @NotNull Continuation<? super JsonElement> $completion) {
        LspServerImpl lspServerImpl = this.getServer();
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl server = lspServerImpl;
        return server.sendRequest((Function1)new Function1<LanguageServer, CompletableFuture<JsonElement>>(args){
            final /* synthetic */ TypeScriptGetTypePropertiesRequestArgs $args;
            {
                this.$args = $args;
                super(1);
            }

            @NotNull
            public final CompletableFuture<JsonElement> invoke(@NotNull LanguageServer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ((JSFrameworkLsp4jServer)it).getTypeProperties(this.$args);
            }
        }, $completion);
    }

    public boolean supportsTypeEvaluation(@NotNull VirtualFile virtualFile, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"vue") || super.supportsTypeEvaluation(virtualFile, element);
    }

    public boolean supportsInjectedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getLanguage() instanceof VueJSLanguage || file.getLanguage() instanceof VueTSLanguage;
    }
}

