/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.lsp.JSServiceSetActivationRule;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VueServicesKt;
import org.jetbrains.vuejs.lang.typescript.service.volar.VolarExecutableDownloader;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueServiceSetActivationRule;", "Lcom/intellij/lang/typescript/lsp/JSServiceSetActivationRule;", "()V", "isEnabledInSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "isFileAcceptableForLspServer", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectContext", "context", "intellij.vuejs"})
public final class VueServiceSetActivationRule
extends JSServiceSetActivationRule {
    @NotNull
    public static final VueServiceSetActivationRule INSTANCE = new VueServiceSetActivationRule();

    private VueServiceSetActivationRule() {
        super((LspServerDownloader)VolarExecutableDownloader.INSTANCE, null);
    }

    public boolean isFileAcceptableForLspServer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value((Object)file)) {
            return false;
        }
        return VueFileTypeKt.isVueFile(file) || TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file);
    }

    protected boolean isProjectContext(@NotNull Project project, @NotNull VirtualFile context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return VueServicesKt.access$isVueServiceContext(project, context);
    }

    protected boolean isEnabledInSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return switch (WhenMappings.$EnumSwitchMapping$0[VueSettingsKt.getVueSettings(project).getServiceType().ordinal()]) {
            case 1, 2 -> true;
            case 3 -> false;
            case 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueServiceSettings.values().length];
            try {
                nArray[VueServiceSettings.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.VOLAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.TS_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.DISABLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

