/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentIntentionKt;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentRefactoring;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "intellij.vuejs"})
public final class VueExtractComponentIntention
extends JavaScriptIntention {
    @NotNull
    public String getFamilyName() {
        return VueBundle.message("vue.template.intention.extract.component.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return VueBundle.message("action.VueExtractComponentAction.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!VueFileTypeKt.isVueFile(psiFile)) {
            return false;
        }
        return VueExtractComponentIntentionKt.getContextForExtractComponentIntention(editor, element) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return;
        }
        List<XmlTag> list = VueExtractComponentIntentionKt.getContextForExtractComponentIntention(editor, element);
        if (list == null) {
            return;
        }
        List<XmlTag> context = list;
        VueExtractComponentRefactoring.perform$default(new VueExtractComponentRefactoring(project, context, editor), null, false, 3, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

