/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.html.webSymbols.elements.WebSymbolElementDescriptor;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webSymbols.PsiSourcedWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.xml.XmlElementDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.inspections.quickfixes.VueImportComponentQuickFix;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.web.symbols.VueComponentSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/intentions/VueImportComponentIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getText", "invoke", "", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "getElementToImport", "Lcom/intellij/webSymbols/WebSymbol;", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueImportComponentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueImportComponentIntention.kt\norg/jetbrains/vuejs/intentions/VueImportComponentIntention\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n14#2:74\n14#2:75\n14#2:77\n14#2:78\n1#3:76\n*S KotlinDebug\n*F\n+ 1 VueImportComponentIntention.kt\norg/jetbrains/vuejs/intentions/VueImportComponentIntention\n*L\n31#1:74\n32#1:75\n51#1:77\n65#1:78\n*E\n"})
public final class VueImportComponentIntention
extends JavaScriptIntention
implements HighPriorityAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        WebSymbolElementDescriptor webSymbolElementDescriptor;
        XmlTag xmlTag;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)XmlElementType.XML_NAME)) return false;
        PsiElement $this$asSafely$iv = element.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof XmlTag)) {
            psiElement = null;
        }
        XmlElementDescriptor $this$asSafely$iv2 = (xmlTag = (XmlTag)psiElement) != null ? xmlTag.getDescriptor() : null;
        boolean $i$f$asSafely2 = false;
        XmlElementDescriptor xmlElementDescriptor = $this$asSafely$iv2;
        if (!(xmlElementDescriptor instanceof WebSymbolElementDescriptor)) {
            xmlElementDescriptor = null;
        }
        if ((webSymbolElementDescriptor = (WebSymbolElementDescriptor)xmlElementDescriptor) == null) return false;
        xmlTag = webSymbolElementDescriptor.getSymbol();
        if (xmlTag == null) return false;
        WebSymbol webSymbol = VueUtilKt.extractComponentSymbol((WebSymbol)xmlTag);
        if (webSymbol == null) return false;
        Object object = webSymbol;
        WebSymbol it = object;
        boolean bl = false;
        if (this.getElementToImport(it) == null) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        WebSymbol webSymbol2 = object;
        WebSymbol webSymbol3 = webSymbol2;
        if (webSymbol3 == null) return false;
        object = webSymbol3.getProperties();
        if (object == null) return false;
        Object it2 = object;
        boolean bl3 = false;
        if (Intrinsics.areEqual(it2.get("x-vue-composition-component"), (Object)true)) return true;
        Object proximity2 = it2.get("x-vue-proximity");
        boolean bl4 = false;
        if (proximity2 == null) return true;
        if (proximity2 == VueModelVisitor.Proximity.LOCAL) return false;
        if (proximity2 == VueModelVisitor.Proximity.OUT_OF_SCOPE) return false;
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return VueBundle.message("vue.template.intention.import.component.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return VueBundle.message("vue.template.intention.import.component.family.name", new Object[0]);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        PsiElement psiElement;
        WebSymbol webSymbol;
        WebSymbol webSymbol2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = element.getParent();
        XmlTag xmlTag = psiElement2 instanceof XmlTag ? (XmlTag)psiElement2 : null;
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        XmlElementDescriptor $this$asSafely$iv = tag.getDescriptor();
        boolean $i$f$asSafely = false;
        XmlElementDescriptor xmlElementDescriptor = $this$asSafely$iv;
        if (!(xmlElementDescriptor instanceof WebSymbolElementDescriptor)) {
            xmlElementDescriptor = null;
        }
        if ((psiElement2 = (WebSymbolElementDescriptor)xmlElementDescriptor) == null || (webSymbol2 = psiElement2.getSymbol()) == null || (webSymbol = VueUtilKt.extractComponentSymbol(webSymbol2)) == null || (psiElement = this.getElementToImport(webSymbol)) == null) {
            return;
        }
        PsiElement elementToImport = psiElement;
        String string = tag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        new VueImportComponentQuickFix(element, VueUtilKt.toAsset$default(string, false, 2, null), elementToImport).applyFix();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiElement getElementToImport(WebSymbol $this$getElementToImport) {
        PsiSourcedWebSymbol psiSourcedWebSymbol;
        WebSymbol $this$asSafely$iv = $this$getElementToImport;
        boolean $i$f$asSafely = false;
        WebSymbol webSymbol = $this$asSafely$iv;
        if (!(webSymbol instanceof PsiSourcedWebSymbol)) {
            webSymbol = null;
        }
        if ((psiSourcedWebSymbol = (PsiSourcedWebSymbol)webSymbol) == null) return null;
        PsiSourcedWebSymbol it = psiSourcedWebSymbol;
        boolean bl = false;
        PsiElement psiElement = it instanceof VueComponentSymbol ? ((VueComponentSymbol)it).getRawSource() : it.getSource();
        if (psiElement == null) return null;
        PsiElement psiElement2 = psiElement;
        it = psiElement2;
        boolean bl2 = false;
        if (it instanceof JSLiteralExpression) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        PsiElement psiElement3 = psiElement2;
        return psiElement3;
    }
}

