/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.html.webSymbols.elements.WebSymbolElementDescriptor;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.model.VueModelDirectiveProperties;
import org.jetbrains.vuejs.web.WebSymbolsUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/vuejs/intentions/VueExpandVModelIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "()V", "validModifiers", "", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "element", "isValidVModel", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.vuejs"})
public final class VueExpandVModelIntention
extends JavaScriptIntention {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Set<String> validModifiers;

    public VueExpandVModelIntention() {
        Object[] objectArray = new String[]{"lazy", "number", "trim"};
        this.validModifiers = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return VueBundle.message("vue.template.intention.v-model.expand.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)XmlElementType.XML_NAME)) return false;
        PsiElement psiElement = element.getParent();
        if (psiElement == null) return false;
        PsiElement it = psiElement;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)XmlElementType.XML_ATTRIBUTE)) return false;
        if (!it.isValid()) return false;
        if (!(it instanceof XmlAttribute)) return false;
        XmlTag xmlTag = ((XmlAttribute)it).getParent();
        if (!((xmlTag != null ? xmlTag.getDescriptor() : null) instanceof WebSymbolElementDescriptor)) return false;
        if (!this.isValidVModel((XmlAttribute)it)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (!VueContextKt.isVueContext(element)) return false;
        return true;
    }

    private final boolean isValidVModel(XmlAttribute attribute) {
        String string = attribute.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        XmlTag xmlTag = attribute.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getParent(...)");
        VueAttributeNameParser.VueAttributeInfo info2 = VueAttributeNameParser.Companion.parse(charSequence, xmlTag);
        VueAttributeNameParser.VueDirectiveInfo vueDirectiveInfo = info2 instanceof VueAttributeNameParser.VueDirectiveInfo ? (VueAttributeNameParser.VueDirectiveInfo)info2 : null;
        return (vueDirectiveInfo != null ? vueDirectiveInfo.getDirectiveKind() : null) == VueAttributeNameParser.VueDirectiveKind.MODEL && this.validModifiers.containsAll((Collection)info2.getModifiers());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement psiElement) {
        String string;
        String event;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (editor == null) {
            return;
        }
        PsiElement psiElement2 = psiElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
        PsiElement parent = psiElement2;
        XmlAttribute modelAttribute = (XmlAttribute)parent;
        XmlTag componentTag = modelAttribute.getParent();
        XmlElementDescriptor xmlElementDescriptor = componentTag.getDescriptor();
        WebSymbolElementDescriptor webSymbolElementDescriptor = xmlElementDescriptor instanceof WebSymbolElementDescriptor ? (WebSymbolElementDescriptor)xmlElementDescriptor : null;
        if (webSymbolElementDescriptor == null) {
            return;
        }
        WebSymbolElementDescriptor componentDescriptor = webSymbolElementDescriptor;
        VueModelDirectiveProperties model = WebSymbolsUtilsKt.getModel(componentDescriptor);
        VueModelDirectiveProperties defaultModel = VueModelDirectiveProperties.Companion.getDefault(psiElement);
        String string2 = model.getEvent();
        if (string2 == null) {
            string2 = event = defaultModel.getEvent();
        }
        if ((string = model.getProp()) == null) {
            string = defaultModel.getProp();
        }
        String prop = string;
        String string3 = ((XmlAttribute)parent).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        CharSequence charSequence = string3;
        XmlTag xmlTag = ((XmlAttribute)parent).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"getParent(...)");
        VueAttributeNameParser.VueAttributeInfo info2 = VueAttributeNameParser.Companion.parse(charSequence, xmlTag);
        Set<String> modifiers = info2.getModifiers();
        Object eventValue = "$event";
        if (modifiers.contains("trim")) {
            eventValue = "typeof " + (String)eventValue + " === 'string' ? " + (String)eventValue + ".trim() : " + (String)eventValue;
        }
        if (modifiers.contains("number")) {
            eventValue = "isNaN(parseFloat(" + (String)eventValue + ")) ? " + (String)eventValue + " : parseFloat(" + (String)eventValue + ")";
        }
        if (modifiers.contains("lazy")) {
            event = "change";
        }
        modelAttribute.setName(":" + prop);
        componentTag.setAttribute("@" + event, modelAttribute.getValue() + " = " + (String)eventValue);
    }
}

