/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs;

import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigServiceImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueDefaultTemplatePropertiesProvider;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.index.VueComponentStylesIndexKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/VueDefaultTemplatePropertiesProvider;", "Lcom/intellij/ide/fileTemplates/DefaultTemplatePropertiesProvider;", "()V", "countFiles", "", "style", "", "project", "Lcom/intellij/openapi/project/Project;", "fillProperties", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "props", "Ljava/util/Properties;", "getAllStyles", "", "getDefaultVueStyleLang", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueDefaultTemplatePropertiesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueDefaultTemplatePropertiesProvider.kt\norg/jetbrains/vuejs/VueDefaultTemplatePropertiesProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1433#2,14:65\n1#3:79\n*S KotlinDebug\n*F\n+ 1 VueDefaultTemplatePropertiesProvider.kt\norg/jetbrains/vuejs/VueDefaultTemplatePropertiesProvider\n*L\n42#1:65,14\n*E\n"})
public final class VueDefaultTemplatePropertiesProvider
implements DefaultTemplatePropertiesProvider {
    public void fillProperties(@NotNull PsiDirectory directory, @NotNull Properties props) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Project project = directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!VueContextKt.hasVueFiles(project) && !VueContextKt.isVueContext((PsiElement)directory)) {
            return;
        }
        Collection collection = TypeScriptConfigServiceImpl.getNearestParentTsConfigs((VirtualFile)directory.getVirtualFile(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNearestParentTsConfigs(...)");
        if (!collection.isEmpty()) {
            ((Map)props).put("SCRIPT_LANG_ATTR", " lang=\"ts\"");
            ((Map)props).put("USE_DEFINE_COMPONENT", VueContextKt.supportsDefineComponent((PsiElement)directory));
            ((Map)props).put("USE_VUE_EXTEND", true);
        }
        Project project2 = directory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = this.getDefaultVueStyleLang(project2);
        if (string != null) {
            String it = string;
            boolean bl = false;
            ((Map)props).put("STYLE_LANG_ATTR", " lang=\"" + it + "\"");
        }
        Map map2 = props;
        String string2 = "CLASS_COMPONENT_LIB";
        String string3 = VueContextKt.getVueClassComponentLibrary((PsiElement)directory);
        if (string3 == null) {
            string3 = "vue-class-component";
        }
        String string4 = string3;
        map2.put(string2, string4);
        ((Map)props).put("CLASS_COMPONENT_DECORATOR", VueContextKt.getVueClassComponentDecoratorName((PsiElement)directory));
    }

    private final String getDefaultVueStyleLang(Project project) {
        return DumbService.Companion.isDumb(project) ? null : (String)FileBasedIndexEx.disableUpToDateCheckIn(() -> VueDefaultTemplatePropertiesProvider.getDefaultVueStyleLang$lambda$3(this, project));
    }

    private final Set<String> getAllStyles(Project project) {
        Set styles = new LinkedHashSet();
        FileBasedIndex.getInstance().processAllKeys(VueComponentStylesIndexKt.getVUE_COMPONENT_STYLES_INDEX_KEY(), arg_0 -> VueDefaultTemplatePropertiesProvider.getAllStyles$lambda$4((Function1)new Function1<String, Boolean>((Set<String>)styles){
            final /* synthetic */ Set<String> $styles;
            {
                this.$styles = $styles;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String style) {
                Intrinsics.checkNotNull((Object)style);
                this.$styles.add(style);
                return true;
            }
        }, arg_0), project);
        return styles;
    }

    private final int countFiles(String style, Project project) {
        return FileBasedIndex.getInstance().getContainingFiles(VueComponentStylesIndexKt.getVUE_COMPONENT_STYLES_INDEX_KEY(), (Object)style, GlobalSearchScope.projectScope((Project)project)).size();
    }

    private static final String getDefaultVueStyleLang$lambda$3(VueDefaultTemplatePropertiesProvider this$0, Project $project) {
        String string;
        String string2;
        Object v0;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Sequence $this$maxByOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this$0.getAllStyles($project)), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Integer>>(this$0, $project){
            final /* synthetic */ VueDefaultTemplatePropertiesProvider this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final Pair<String, Integer> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new Pair((Object)it, (Object)VueDefaultTemplatePropertiesProvider.access$countFiles(this.this$0, it, this.$project));
            }
        })), (Function1)getDefaultVueStyleLang.1.2.INSTANCE);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Pair it = (Pair)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getSecond()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-maxByOrNull-VueDefaultTemplatePropertiesProvider$getDefaultVueStyleLang$1$3 = false;
                    int v$iv = ((Number)it2.getSecond()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Pair pair = v0;
        if (pair != null && (string2 = (String)pair.getFirst()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean getAllStyles$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$countFiles(VueDefaultTemplatePropertiesProvider $this, String style, Project project) {
        return $this.countFiles(style, project);
    }
}

