/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.treetable.ColumnsWrapper;
import com.intellij.database.run.ui.treetable.LazyValueWrapper;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.database.run.ui.treetable.NodeWithCache;
import com.intellij.database.run.ui.treetable.ValueWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/ui/treetable/RowNode;", "Lcom/intellij/database/run/ui/treetable/NodeWithCache;", "Lcom/intellij/database/run/ui/treetable/Node;", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/ModelIndex;Lcom/intellij/database/datagrid/DataGrid;)V", "name", "", "getName", "()Ljava/lang/String;", "getRowIdx", "()Lcom/intellij/database/datagrid/ModelIndex;", "clearCachedValue", "", "createWrapper", "Lcom/intellij/database/run/ui/treetable/ValueWrapper;", "intellij.grid.impl"})
public final class RowNode
extends NodeWithCache<Node> {
    @NotNull
    private final ModelIndex<GridRow> rowIdx;
    @NotNull
    private final DataGrid grid;

    public RowNode(@NotNull ModelIndex<GridRow> rowIdx, @NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.rowIdx = rowIdx;
        this.grid = grid;
    }

    @NotNull
    public final ModelIndex<GridRow> getRowIdx() {
        return this.rowIdx;
    }

    @Override
    @NotNull
    protected ValueWrapper<Node> createWrapper() {
        return new ColumnsWrapper(this.grid, this.rowIdx);
    }

    public final void clearCachedValue() {
        ValueWrapper valueWrapper = this.getWrapper();
        Intrinsics.checkNotNull(valueWrapper, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.treetable.LazyValueWrapper<*>");
        ((LazyValueWrapper)valueWrapper).clearCachedValue();
    }

    @Override
    @NotNull
    public String getName() {
        String string = GridUtil.getRowName(this.grid, this.rowIdx.asInteger());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRowName(...)");
        return string;
    }
}

