/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/run/ui/table/SingleRowModeHelper;", "", "()V", "calculateHeightForInEditorResult", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "maxRows", "(Lcom/intellij/database/datagrid/DataGrid;I)Ljava/lang/Integer;", "expandRowIfNeeded", "", "linesCount", "(Lcom/intellij/database/datagrid/DataGrid;)Ljava/lang/Integer;", "intellij.grid.impl"})
public final class SingleRowModeHelper {
    @NotNull
    public static final SingleRowModeHelper INSTANCE = new SingleRowModeHelper();

    private SingleRowModeHelper() {
    }

    @JvmStatic
    private static final Integer linesCount(DataGrid grid) {
        if (!(grid.getResultView() instanceof TableResultView)) {
            return null;
        }
        GridModel gridModel = grid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model2 = gridModel;
        if (model2.getRowCount() == 1 && model2.getColumnCount() == 1) {
            String string = GridUtil.getText(grid, (ModelIndex<GridRow>)ViewIndex.forRow((CoreGrid)grid, (int)0).toModel((CoreGrid)grid), (ModelIndex<GridColumn>)ViewIndex.forColumn((CoreGrid)grid, (int)0).toModel((CoreGrid)grid));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String cellText = string;
            return Math.max(1, StringUtil.getLineBreakCount((CharSequence)cellText) + 1);
        }
        return null;
    }

    @JvmStatic
    public static final void expandRowIfNeeded(@NotNull DataGrid grid) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Integer singleRowLinesCount = SingleRowModeHelper.linesCount(grid);
            if (singleRowLinesCount == null) break block1;
            ResultView resultView = grid.getResultView();
            TableResultView tableResultView = resultView instanceof TableResultView ? (TableResultView)resultView : null;
            if (tableResultView != null) {
                TableResultView view = tableResultView;
                boolean bl = false;
                view.setRowHeight(0, singleRowLinesCount * view.getTextLineHeight());
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Integer calculateHeightForInEditorResult(@NotNull DataGrid grid, int maxRows) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Integer n = SingleRowModeHelper.linesCount(grid);
        if (n == null) {
            return null;
        }
        int count = n;
        int rows = Math.min(maxRows, count);
        ResultView resultView = grid.getResultView();
        ResultViewWithRows resultViewWithRows = resultView instanceof ResultViewWithRows ? (ResultViewWithRows)((Object)resultView) : null;
        return resultViewWithRows != null ? Integer.valueOf(resultViewWithRows.getRowHeight() * rows) : null;
    }
}

