/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002*+B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u001d\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001f\u001a\u00020\fJ\u001c\u0010 \u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001f\u001a\u00020\fJ.\u0010!\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tJ\u0006\u0010$\u001a\u00020\u001cJ4\u0010%\u001a\u00020\u001c2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0'2\u001e\u0010(\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0)R&\u0010\u0007\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0010\"\u0004\b\u0011\u0010\u0012R1\u0010\u0013\u001a%\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/run/ui/table/LocalFilterState;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "isEnabled", "", "(Lcom/intellij/database/datagrid/DataGrid;Z)V", "allowedValuesForColumn", "", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridColumn;", "", "Lcom/intellij/database/run/ui/table/LocalFilterState$Value;", "alwaysShowMutationTypes", "", "Lcom/intellij/database/datagrid/MutationType;", "()Z", "setEnabled", "(Z)V", "mutator", "Lcom/intellij/database/datagrid/GridMutator$DatabaseMutator;", "Lcom/intellij/database/datagrid/GridRow;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Nullable;", "allowedValues", "", "column", "clearFilterForColumn", "", "columnFilterEnabled", "disableForColumn", "value", "enableForColumn", "include", "rowIdx", "ignoreFilterForColumn", "reset", "shiftColumns", "columnIndices", "Lcom/intellij/database/datagrid/ModelIndexSet;", "toOriginalIndex", "Lkotlin/Function1;", "Listener", "Value", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nLocalFilterState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFilterState.kt\ncom/intellij/database/run/ui/table/LocalFilterState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n372#2,7:88\n372#2,7:95\n167#3,3:102\n1855#4:105\n1856#4:107\n1#5:106\n*S KotlinDebug\n*F\n+ 1 LocalFilterState.kt\ncom/intellij/database/run/ui/table/LocalFilterState\n*L\n19#1:88,7\n23#1:95,7\n51#1:102,3\n61#1:105\n61#1:107\n*E\n"})
public final class LocalFilterState {
    private volatile boolean isEnabled;
    @NotNull
    private final Map<ModelIndex<GridColumn>, Set<Value>> allowedValuesForColumn;
    @Nullable
    private final GridMutator.DatabaseMutator<GridRow, GridColumn> mutator;
    @NotNull
    private final List<MutationType> alwaysShowMutationTypes;

    public LocalFilterState(@NotNull DataGrid grid, boolean isEnabled) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.isEnabled = isEnabled;
        this.allowedValuesForColumn = new LinkedHashMap();
        this.mutator = GridUtil.getDatabaseMutator(grid);
        Object[] objectArray = new MutationType[]{MutationType.DELETE, MutationType.INSERT};
        this.alwaysShowMutationTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ LocalFilterState(DataGrid dataGrid, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(dataGrid, bl);
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public final void enableForColumn(@NotNull ModelIndex<GridColumn> column, @NotNull Value value) {
        Set set;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<ModelIndex<GridColumn>, Set<Value>> $this$getOrPut$iv = this.allowedValuesForColumn;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(column);
        if (value$iv == null) {
            boolean bl = false;
            Object[] objectArray = new Value[]{value};
            Set answer$iv = SetsKt.mutableSetOf((Object[])objectArray);
            $this$getOrPut$iv.put(column, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((Value)value);
    }

    public final void disableForColumn(@NotNull ModelIndex<GridColumn> column, @NotNull Value value) {
        Set set;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<ModelIndex<GridColumn>, Set<Value>> $this$getOrPut$iv = this.allowedValuesForColumn;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(column);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(column, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.remove(value);
    }

    public final void clearFilterForColumn(@NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.allowedValuesForColumn.remove(column);
    }

    @NotNull
    public final Set<Value> allowedValues(@NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.allowedValuesForColumn.getOrDefault(column, new LinkedHashSet());
    }

    public final boolean columnFilterEnabled(@NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Set<Value> set = this.allowedValuesForColumn.get(column);
        return set != null ? !((Collection)set).isEmpty() : false;
    }

    public final void reset() {
        this.allowedValuesForColumn.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean include(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @Nullable ModelIndex<GridColumn> ignoreFilterForColumn) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        if (!this.isEnabled) {
            return true;
        }
        if (this.mutator != null && CollectionsKt.contains((Iterable)this.alwaysShowMutationTypes, (Object)this.mutator.getMutationType(rowIdx))) {
            return true;
        }
        Map<ModelIndex<GridColumn>, Set<Value>> $this$all$iv = this.allowedValuesForColumn;
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<ModelIndex<GridColumn>, Set<Value>>> iterator = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry<ModelIndex<GridColumn>, Set<Value>> element$iv;
            if (!iterator.hasNext()) return true;
            Map.Entry<ModelIndex<GridColumn>, Set<Value>> allowedValues = element$iv = iterator.next();
            boolean bl2 = false;
            if (!allowedValues.getValue().isEmpty() && !Intrinsics.areEqual(allowedValues.getKey(), ignoreFilterForColumn)) {
                String string = GridUtil.getText(grid, rowIdx, allowedValues.getKey(), DataAccessType.DATA_WITH_MUTATIONS);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!allowedValues.getValue().contains(new Value(null, string))) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    public static /* synthetic */ boolean include$default(LocalFilterState localFilterState, DataGrid dataGrid, ModelIndex modelIndex, ModelIndex modelIndex2, int n, Object object) {
        if ((n & 4) != 0) {
            modelIndex2 = null;
        }
        return localFilterState.include(dataGrid, (ModelIndex<GridRow>)modelIndex, (ModelIndex<GridColumn>)modelIndex2);
    }

    public final void shiftColumns(@NotNull ModelIndexSet<GridColumn> columnIndices, @NotNull Function1<? super ModelIndex<GridColumn>, ? extends ModelIndex<GridColumn>> toOriginalIndex) {
        Intrinsics.checkNotNullParameter(columnIndices, (String)"columnIndices");
        Intrinsics.checkNotNullParameter(toOriginalIndex, (String)"toOriginalIndex");
        Map originalValues = MapsKt.toMap(this.allowedValuesForColumn);
        this.allowedValuesForColumn.clear();
        JBIterable jBIterable = columnIndices.asIterable();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"asIterable(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set value;
            ModelIndex it = (ModelIndex)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Set originalValue = (Set)originalValues.get(toOriginalIndex.invoke((Object)it));
            if (originalValue == null) continue;
            boolean bl2 = false;
            this.allowedValuesForColumn.put((ModelIndex<GridColumn>)it, value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/run/ui/table/LocalFilterState$Listener;", "", "onLocalFilterStateChanged", "", "intellij.grid.impl"})
    public static interface Listener {
        default public void onLocalFilterStateChanged() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/run/ui/table/LocalFilterState$Value;", "", "obj", "", "text", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getObj", "()Ljava/lang/Object;", "getText", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "hashCode", "intellij.grid.impl"})
    public static final class Value
    implements Comparable<Value> {
        @Nullable
        private final Object obj;
        @NotNull
        private final String text;

        public Value(@Nullable Object obj, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.obj = obj;
            this.text = text;
        }

        @Nullable
        public final Object getObj() {
            return this.obj;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Override
        public int compareTo(@NotNull Value other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.text.compareTo(other.text);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)((Value)other).text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }
    }
}

