/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.util.Collection;
import java.util.List;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CollapsedCellRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    private CollapsedCellRenderer myTextRenderer;

    public CollapsedCellRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    public boolean supports(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        HierarchicalColumnsCollapseManager collapseManager;
        if (row == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(2);
        }
        return (collapseManager = this.myGrid.getHierarchicalColumnsCollapseManager()) != null && collapseManager.isColumnCollapsedSubtree(column);
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(3);
        }
        if (column == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(4);
        }
        if (this.myTextRenderer == null) {
            this.myTextRenderer = new CollapsedCellRenderer(this.myGrid);
            Disposer.register((Disposable)this.myGrid, (Disposable)this.myTextRenderer);
        }
        CollapsedCellRenderer collapsedCellRenderer = this.myTextRenderer;
        if (collapsedCellRenderer == null) {
            CollapsedCellRendererFactory.$$$reportNull$$$0(5);
        }
        return collapsedCellRenderer;
    }

    @Override
    public void reinitSettings() {
        if (this.myTextRenderer == null) {
            return;
        }
        this.myTextRenderer.reinitSettings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/CollapsedCellRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/CollapsedCellRendererFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class CollapsedCellRenderer
    extends DefaultTextRendererFactory.TextRenderer {
        private static final char BULLET = '\u2022';

        public CollapsedCellRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(0);
            }
            super(grid, (Border)new JBEmptyBorder(0, 1, 0, 3));
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            HierarchicalColumnsCollapseManager collapseManager;
            if (row == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(1);
            }
            if (column == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(2);
            }
            return (collapseManager = this.myGrid.getHierarchicalColumnsCollapseManager()) != null && collapseManager.isColumnCollapsedSubtree(column) ? 2 : 0;
        }

        @Override
        @NotNull
        protected String getValueText(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Object value) {
            if (columnIdx == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(3);
            }
            if (value == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(4);
            }
            GridModel model2 = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            GridColumn column = (GridColumn)model2.getColumn(columnIdx);
            if (model2.getHierarchicalReader() == null || !(column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn)) {
                return "\u2022\u2022\u2022";
            }
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
            List childrenNames = ContainerUtil.map((Collection)model2.getHierarchicalReader().getSiblings(hierarchicalColumn), HierarchicalColumnsDataGridModel.HierarchicalGridColumn::getName);
            String string = String.format("{ %s }", String.join((CharSequence)", ", childrenNames));
            if (string == null) {
                CollapsedCellRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/CollapsedCellRendererFactory$CollapsedCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/CollapsedCellRendererFactory$CollapsedCellRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

