/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.EditorCellViewerFactory;
import com.intellij.database.run.ui.EmptyCellViewerFactory;
import com.intellij.database.run.ui.ImageCellViewerFactory;
import com.intellij.database.run.ui.ReadonlyEditorCellViewerFactory;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/run/ui/ValueTabInfoProvider;", "Lcom/intellij/database/run/ui/TabInfoProvider;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "currentViewerFactory", "Lcom/intellij/database/run/ui/CellViewerFactory;", "viewer", "Lcom/intellij/database/run/ui/CellViewer;", "viewerFactories", "", "chooseViewerFactory", "dispose", "", "getViewer", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "updateViewer", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nValueTabInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueTabInfoProvider.kt\ncom/intellij/database/run/ui/ValueTabInfoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1963#2,14:68\n*S KotlinDebug\n*F\n+ 1 ValueTabInfoProvider.kt\ncom/intellij/database/run/ui/ValueTabInfoProvider\n*L\n35#1:68,14\n*E\n"})
public final class ValueTabInfoProvider
extends TabInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private CellViewerFactory currentViewerFactory;
    @NotNull
    private final List<CellViewerFactory> viewerFactories;
    @NotNull
    private CellViewer viewer;
    @NotNull
    private static final Logger LOG;

    public ValueTabInfoProvider(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        String string = DataGridBundle.message((String)"EditMaximized.ValueEditor.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = ActionManager.getInstance().getAction("Console.TableResult.EditMaximized.Value.Group");
        super(string, objectArray instanceof ActionGroup ? (ActionGroup)objectArray : null);
        this.grid = grid;
        objectArray = new CellViewerFactory[]{EditorCellViewerFactory.INSTANCE, ReadonlyEditorCellViewerFactory.INSTANCE, EmptyCellViewerFactory.INSTANCE, ImageCellViewerFactory.INSTANCE};
        this.viewerFactories = CollectionsKt.listOf((Object[])objectArray);
        this.currentViewerFactory = this.chooseViewerFactory();
        this.viewer = this.currentViewerFactory.createViewer(this.grid);
        this.updateTabInfo();
    }

    private final CellViewerFactory chooseViewerFactory() {
        CellViewerFactory cellViewerFactory;
        Object v2;
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex rowIdx = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex columnIdx = modelIndex2;
        Iterable $this$maxByOrNull$iv = this.viewerFactories;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                CellViewerFactory it = (CellViewerFactory)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)it.getSuitability(this.grid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx));
                do {
                    Object e$iv = iterator$iv.next();
                    CellViewerFactory it2 = (CellViewerFactory)e$iv;
                    $i$a$-maxByOrNull-ValueTabInfoProvider$chooseViewerFactory$factory$1 = false;
                    Comparable v$iv = (Comparable)((Object)it2.getSuitability(this.grid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        CellViewerFactory factory = v2;
        if (factory == null) {
            LOG.error("Cannot find cell viewer factory for " + rowIdx + " " + columnIdx);
        }
        if ((cellViewerFactory = factory) == null) {
            cellViewerFactory = EmptyCellViewerFactory.INSTANCE;
        }
        return cellViewerFactory;
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        this.updateViewer();
        super.update(event);
    }

    private final void updateViewer() {
        CellViewerFactory factory = this.chooseViewerFactory();
        if (!Intrinsics.areEqual((Object)this.currentViewerFactory, (Object)factory)) {
            this.currentViewerFactory = factory;
            CellViewer oldViewer = this.viewer;
            this.viewer = factory.createViewer(this.grid);
            this.updateTabInfo();
            Disposer.dispose((Disposable)oldViewer);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.viewer);
    }

    @Override
    @NotNull
    public CellViewer getViewer() {
        return this.viewer;
    }

    static {
        Logger logger = Logger.getInstance(ValueTabInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/run/ui/ValueTabInfoProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

