/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.Suitability;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/ui/ReadonlyEditorCellViewerFactory;", "Lcom/intellij/database/run/ui/CellViewerFactory;", "()V", "createViewer", "Lcom/intellij/database/run/ui/CellViewer;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "getSuitability", "Lcom/intellij/database/run/ui/Suitability;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "column", "Lcom/intellij/database/datagrid/GridColumn;", "intellij.grid.impl"})
public final class ReadonlyEditorCellViewerFactory
implements CellViewerFactory {
    @NotNull
    public static final ReadonlyEditorCellViewerFactory INSTANCE = new ReadonlyEditorCellViewerFactory();

    private ReadonlyEditorCellViewerFactory() {
    }

    @Override
    @NotNull
    public Suitability getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!row.isValid((CoreGrid)grid) || !column.isValid((CoreGrid)grid)) {
            return Suitability.NONE;
        }
        if (!grid.isEditable()) {
            return Suitability.MIN_2;
        }
        Object object = GridCellEditorFactoryProvider.get(grid);
        if (object == null || (object = object.getEditorFactory(grid, row, column)) == null) {
            return Suitability.NONE;
        }
        Object factory = object;
        Object value = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
        boolean isEditable = factory.getIsEditableChecker().isEditable(value, grid, column);
        return isEditable ? Suitability.MIN_1 : Suitability.MIN_2;
    }

    @Override
    @NotNull
    public CellViewer createViewer(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Project project = grid.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new EditorCellViewer(project, grid, false);
    }
}

