/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u0018\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/run/ui/ImageCellViewer;", "Lcom/intellij/database/run/ui/CellViewer;", "Lcom/intellij/openapi/util/CheckedDisposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "alarm", "Lcom/intellij/util/Alarm;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "panel", "Ljavax/swing/JPanel;", "preferedFocusComponent", "getPreferedFocusComponent", "clearContent", "", "dispose", "isDisposed", "", "showImage", "image", "Ljava/awt/image/BufferedImage;", "update", "info", "Lcom/intellij/database/extractors/ImageInfo;", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "intellij.grid.impl"})
public final class ImageCellViewer
implements CellViewer,
CheckedDisposable {
    @NotNull
    private final DataGrid grid;
    private final /* synthetic */ CheckedDisposable $$delegate_0;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final JComponent component;
    @Nullable
    private final JComponent preferedFocusComponent;

    public ImageCellViewer(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.$$delegate_0 = Disposer.newCheckedDisposable();
        this.panel = new JPanel(new BorderLayout());
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.component = this.panel;
    }

    public boolean isDisposed() {
        return this.$$delegate_0.isDisposed();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @Nullable
    public JComponent getPreferedFocusComponent() {
        return this.preferedFocusComponent;
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        ImageInfo info;
        if (event instanceof UpdateEvent.ValueChanged) {
            if (((UpdateEvent.ValueChanged)event).getValue() instanceof ImageInfo) {
                this.update((ImageInfo)((UpdateEvent.ValueChanged)event).getValue());
            } else {
                this.clearContent();
            }
            return;
        }
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex rowIdx = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex columnIdx = modelIndex2;
        if (!rowIdx.isValid((CoreGrid)this.grid) || !columnIdx.isValid((CoreGrid)this.grid)) {
            this.clearContent();
            return;
        }
        Object object = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(rowIdx, columnIdx);
        ImageInfo imageInfo = info = object instanceof ImageInfo ? (ImageInfo)object : null;
        if (info == null) {
            this.clearContent();
        } else {
            this.update(info);
        }
    }

    private final void clearContent() {
        LayoutManager layoutManager = this.panel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
        Component prev = ((BorderLayout)layoutManager).getLayoutComponent("Center");
        if (prev != null) {
            this.panel.remove(prev);
            if (prev instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)prev));
            }
        }
    }

    private final void showImage(BufferedImage image) {
        this.clearContent();
        ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
        Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"createImageEditorUI(...)");
        JComponent ui = (JComponent)imageEditorUI;
        if (ui instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)ui));
        }
        this.panel.add((Component)ui, "Center");
        this.panel.revalidate();
        this.panel.repaint();
    }

    private final void update(ImageInfo info) {
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(() -> ImageCellViewer.update$lambda$1(info, this), 0);
    }

    public void dispose() {
    }

    private static final void update$lambda$1$lambda$0(ImageCellViewer this$0, BufferedImage $image) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$image, (String)"$image");
        if (!this$0.isDisposed()) {
            this$0.showImage($image);
        }
    }

    private static final void update$lambda$1(ImageInfo $info, ImageCellViewer this$0) {
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BufferedImage bufferedImage = $info.createImage();
        if (bufferedImage == null) {
            return;
        }
        BufferedImage image = bufferedImage;
        ApplicationManager.getApplication().invokeLater(() -> ImageCellViewer.update$lambda$1$lambda$0(this$0, image));
    }
}

