/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.application.options.CodeStyle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.JsonMinimizedFormat;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.database.run.ui.MongoJSFormat;
import com.intellij.database.run.ui.XmlMinimizedFormat;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a2\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0005*\u00020\u0003\u00a8\u0006\u0010"}, d2={"detectFormat", "Lcom/intellij/database/run/ui/MinimizedFormat;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "value", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "runFormatter", "", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "getSelectedValue", "intellij.grid.impl"})
public final class FormattedModeHandlerKt {
    private static final MinimizedFormat detectFormat(DataGrid grid, Object value, Project project, Document document) {
        MinimizedFormat minimizedFormat;
        JsonMinimizedFormat jsonMinimizedFormat = JsonMinimizedFormat.Companion.detect(project, document);
        if (jsonMinimizedFormat != null) {
            minimizedFormat = jsonMinimizedFormat;
        } else {
            MongoJSFormat mongoJSFormat = MongoJSFormat.Companion.detect(grid, value, project, document);
            minimizedFormat = mongoJSFormat != null ? (MinimizedFormat)mongoJSFormat : (MinimizedFormat)XmlMinimizedFormat.Companion.detect(project, document);
        }
        return minimizedFormat;
    }

    @Nullable
    public static final Object getSelectedValue(@NotNull DataGrid $this$getSelectedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedValue, (String)"<this>");
        ModelIndex modelIndex = $this$getSelectedValue.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex row = modelIndex;
        ModelIndex modelIndex2 = $this$getSelectedValue.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex column = modelIndex2;
        return $this$getSelectedValue.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
    }

    private static final void runFormatter(Project project, Document document, Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyle.getSettings((PsiFile)file), null);
        FormatTextRanges ranges = new FormatTextRanges(TextRange.from((int)0, (int)document.getTextLength()), true);
        disableUpdateListener.invoke((Object)new Function0<Unit>(codeFormatter, file, ranges){
            final /* synthetic */ CodeFormatterFacade $codeFormatter;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ FormatTextRanges $ranges;
            {
                this.$codeFormatter = $codeFormatter;
                this.$file = $file;
                this.$ranges = $ranges;
                super(0);
            }

            public final void invoke() {
                this.$codeFormatter.processText(this.$file, this.$ranges, false);
            }
        });
    }

    public static final /* synthetic */ MinimizedFormat access$detectFormat(DataGrid grid, Object value, Project project, Document document) {
        return FormattedModeHandlerKt.detectFormat(grid, value, project, document);
    }

    public static final /* synthetic */ void access$runFormatter(Project project, Document document, Function1 disableUpdateListener) {
        FormattedModeHandlerKt.runFormatter(project, document, (Function1<? super Function0<Unit>, Unit>)disableUpdateListener);
    }
}

