/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.ui.AggregateView;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/ui/AggregationResult;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "exception", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "isFullTextShown", "", "getText", "()Ljava/lang/String;", "getRowsCount", "", "isScriptExceptionHappened", "processMouseClickEvent", "e", "Ljava/awt/event/MouseEvent;", "rectangle", "Ljava/awt/Rectangle;", "panel", "Lcom/intellij/database/run/ui/AggregateView$AggregatorViewPanel;", "setDecorateState", "", "show", "setFullTextShown", "intellij.grid.impl"})
public final class AggregationResult {
    @NotNull
    private final String text;
    @Nullable
    private final Throwable exception;
    private boolean isFullTextShown;

    public AggregationResult(@NotNull String text, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.exception = exception;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final Throwable getException() {
        return this.exception;
    }

    public final boolean isScriptExceptionHappened() {
        return this.exception != null;
    }

    public final int getRowsCount() {
        return !this.isFullTextShown ? 1 : 1 + StringUtil.countChars((CharSequence)this.text, (char)'\n');
    }

    public final boolean processMouseClickEvent(@NotNull MouseEvent e, @NotNull Rectangle rectangle, @NotNull AggregateView.AggregatorViewPanel panel2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        if (StringsKt.contains$default((CharSequence)this.text, (CharSequence)"\n", (boolean)false, (int)2, null) && (e.getClickCount() % 2 == 0 || panel2.isClickOnButton(e, rectangle))) {
            this.setDecorateState(!this.isFullTextShown);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public final void setDecorateState(boolean show2) {
        this.isFullTextShown = StringsKt.contains$default((CharSequence)this.text, (CharSequence)"\n", (boolean)false, (int)2, null) ? show2 : false;
    }

    public final void setFullTextShown(boolean show2) {
        this.isFullTextShown = this.exception != null ? false : show2;
    }

    public final boolean isFullTextShown() {
        return this.isFullTextShown;
    }
}

