/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.loaders;

import java.net.URL;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0004\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/loaders/RestrictedClassLoader;", "Ljava/lang/ClassLoader;", "optBaseLoader", "(Ljava/lang/ClassLoader;)V", "baseLoader", "kotlin.jvm.PlatformType", "cleanup", "", "findClass", "Ljava/lang/Class;", "name", "", "findResource", "Ljava/net/URL;", "findResources", "Ljava/util/Enumeration;", "isMyClassloader", "", "cl", "isRestrictedClass", "isRestrictedResource", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nScriptedDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptedDataLoader.kt\ncom/intellij/database/loaders/RestrictedClassLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1855#2,2:359\n*S KotlinDebug\n*F\n+ 1 ScriptedDataLoader.kt\ncom/intellij/database/loaders/RestrictedClassLoader\n*L\n311#1:359,2\n*E\n"})
final class RestrictedClassLoader
extends ClassLoader {
    private final ClassLoader baseLoader;

    public RestrictedClassLoader(@Nullable ClassLoader optBaseLoader) {
        super(ClassLoader.getSystemClassLoader().getParent());
        ClassLoader classLoader = optBaseLoader;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.baseLoader = classLoader;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isRestrictedClass(name)) {
            Class<?> clazz = super.findClass(name);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"findClass(...)");
            return clazz;
        }
        Class<?> clazz = this.baseLoader.loadClass(name);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        return clazz;
    }

    @Override
    @Nullable
    protected URL findResource(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isRestrictedResource(name)) {
            return super.findResource(name);
        }
        return this.baseLoader.getResource(name);
    }

    @Override
    @NotNull
    protected Enumeration<URL> findResources(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isRestrictedResource(name)) {
            Enumeration<URL> enumeration = super.findResources(name);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"findResources(...)");
            return enumeration;
        }
        Enumeration<URL> enumeration = this.baseLoader.getResources(name);
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        return enumeration;
    }

    private final boolean isRestrictedClass(String name) {
        return !StringsKt.startsWith$default((String)name, (String)"groovy", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"org.apache.groovy", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"org.codehaus.groovy", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"org.apache.ivy", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"com.intellij.database.extensions", (boolean)false, (int)2, null);
    }

    private final boolean isRestrictedResource(String name) {
        return StringsKt.startsWith$default((String)name, (String)"META-INF/services/javax.xml.parsers.", (boolean)false, (int)2, null);
    }

    public final void cleanup() {
        Iterable $this$forEach$iv = Thread.getAllStackTraces().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Thread t = (Thread)element$iv;
            boolean bl = false;
            boolean myThread = this.isMyClassloader(t.getClass().getClassLoader()) || this.isMyClassloader(t.getContextClassLoader());
            if (!myThread) continue;
            t.interrupt();
            t.join(10L);
        }
    }

    private final boolean isMyClassloader(ClassLoader cl) {
        for (ClassLoader tmp = cl; tmp != null; tmp = tmp.getParent()) {
            if (!Intrinsics.areEqual((Object)tmp, (Object)this)) continue;
            return true;
        }
        return false;
    }
}

