/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilKt;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\"\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"findAllGridsInFile", "", "Lcom/intellij/database/datagrid/DataGrid;", "grid", "getOuterFileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "preferredRowHeight", "", "table", "Ljavax/swing/JTable;", "row", "setPageSize", "", "hookUp", "Lcom/intellij/database/datagrid/GridDataHookUp;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "helper", "Lcom/intellij/database/datagrid/GridHelper;", "setupDynamicRowHeight", "updateRowHeights", "intellij.grid.impl"})
public final class GridUtilKt {
    @NotNull
    public static final List<DataGrid> findAllGridsInFile(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        FileEditor fileEditor = GridUtilKt.getOuterFileEditor(grid);
        Object object = fileEditor;
        if (object == null || (object = object.getComponent()) == null) {
            return CollectionsKt.emptyList();
        }
        Object editorComponent = object;
        List list = ((JBTreeTraverser)UIUtil.uiTraverser((Component)((Component)editorComponent)).expand(arg_0 -> GridUtilKt.findAllGridsInFile$lambda$0(findAllGridsInFile.1.INSTANCE, arg_0))).traverse(TreeTraversal.PRE_ORDER_DFS).filterMap(arg_0 -> GridUtilKt.findAllGridsInFile$lambda$1(findAllGridsInFile.2.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @Nullable
    public static final FileEditor getOuterFileEditor(@Nullable DataGrid grid) {
        if (grid == null) {
            return null;
        }
        Container gridParentComponent = grid.getPanel().getComponent().getParent();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)gridParentComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        return (FileEditor)dataContext2.getData(PlatformCoreDataKeys.FILE_EDITOR);
    }

    public static final void setPageSize(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp, @NotNull GridHelper helper) {
        Intrinsics.checkNotNullParameter(hookUp, (String)"hookUp");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        hookUp.getPageModel().setPageSize(helper.isLimitDefaultPageSize() ? helper.getDefaultPageSize() : -1);
    }

    public static final void setupDynamicRowHeight(@NotNull JTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        table2.getModel().addTableModelListener(arg_0 -> GridUtilKt.setupDynamicRowHeight$lambda$3(table2, arg_0));
    }

    private static final void updateRowHeights(JTable table2) {
        int rc = table2.getRowCount();
        for (int row = 0; row < rc; ++row) {
            int height = GridUtilKt.preferredRowHeight(table2, row);
            table2.setRowHeight(row, height);
        }
    }

    private static final int preferredRowHeight(JTable table2, int row) {
        int height = table2.getRowHeight();
        int cc = table2.getColumnCount();
        for (int col = 0; col < cc; ++col) {
            Component component = table2.getCellRenderer(row, col).getTableCellRendererComponent(table2, table2.getValueAt(row, col), false, false, row, col);
            Dimension size = component.getPreferredSize();
            height = RangesKt.coerceAtLeast((int)height, (int)size.height);
        }
        return height;
    }

    private static final boolean findAllGridsInFile$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DataGrid findAllGridsInFile$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataGrid)$tmp0.invoke(p0);
    }

    private static final void setupDynamicRowHeight$lambda$3$lambda$2(JTable $table) {
        Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
        GridUtilKt.updateRowHeights($table);
    }

    private static final void setupDynamicRowHeight$lambda$3(JTable $table, TableModelEvent it) {
        Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
        SwingUtilities.invokeLater(() -> GridUtilKt.setupDynamicRowHeight$lambda$3$lambda$2($table));
    }
}

