/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.DataFrameImpl;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.DoubleColumn;
import com.intellij.bigdatatools.visualization.dataframe.columns.IntColumn;
import com.intellij.bigdatatools.visualization.dataframe.columns.LongColumn;
import com.intellij.bigdatatools.visualization.dataframe.columns.StringColumn;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.util.InvalidDataException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010\t\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010\u000b\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010\r\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0006H\u0002J \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00062\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0006H\u0002J \u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00062\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/datagrid/DataGridConversionUtil;", "", "()V", "addToDoubleColumn", "Lcom/intellij/database/datagrid/DataGridConversionUtil$ValueType;", "data", "", "", "value", "addToIntColumn", "", "addToLongColumn", "", "addToStringColumn", "", "addValue", "dataType", "getDataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "getDataType", "numberToDoubleList", "", "numberToLongList", "numberToStringList", "ValueType", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nDataGridConversionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataGridConversionUtil.kt\ncom/intellij/database/datagrid/DataGridConversionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n766#2:247\n857#2,2:248\n1855#2:250\n1855#2,2:251\n1856#2:253\n1855#2,2:254\n1855#2,2:256\n1855#2,2:258\n*S KotlinDebug\n*F\n+ 1 DataGridConversionUtil.kt\ncom/intellij/database/datagrid/DataGridConversionUtil\n*L\n40#1:247\n40#1:248,2\n40#1:250\n63#1:251,2\n40#1:253\n221#1:254,2\n227#1:256,2\n233#1:258,2\n*E\n"})
public final class DataGridConversionUtil {
    @NotNull
    public static final DataGridConversionUtil INSTANCE = new DataGridConversionUtil();

    private DataGridConversionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame getDataFrame(@NotNull DataGrid grid) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model2 = gridModel;
        List list = model2.getRows();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRows(...)");
        List rows = list;
        List list2 = model2.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getColumns(...)");
        List columns = list2;
        List dataframeColumns = new ArrayList();
        Iterable $this$filter$iv = columns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GridColumn it = (GridColumn)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAttributes().contains(ColumnDescriptor.Attribute.ROW_ID))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GridColumn column = (GridColumn)element$iv;
            boolean bl = false;
            int columnNumber = column.getColumnNumber();
            ValueType dataType = null;
            dataType = switch (column.getType()) {
                case -7, -6, 4, 5 -> ValueType.INT;
                case -5 -> ValueType.LONG;
                case 2, 3, 6, 7, 8 -> ValueType.DOUBLE;
                default -> ValueType.STRING;
            };
            List<Long> data = null;
            data = switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1 -> (List<Long>)new ArrayList();
                case 2 -> new ArrayList();
                case 3 -> new ArrayList();
                default -> new ArrayList();
            };
            Iterable $this$forEach$iv2 = rows;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GridRow row = (GridRow)element$iv2;
                boolean bl2 = false;
                Object value = row.getValue(columnNumber);
                ValueType valueType = INSTANCE.addValue(dataType, data, value);
                if (valueType != dataType) {
                    data = switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                        case 1 -> {
                            switch (WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
                                case 2: {
                                    List<Long> v5 = data;
                                    Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                    yield INSTANCE.numberToLongList(TypeIntrinsics.asMutableList((Object)v5));
                                }
                                case 3: {
                                    List<Long> v7 = data;
                                    Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                    yield INSTANCE.numberToDoubleList(TypeIntrinsics.asMutableList((Object)v7));
                                }
                                case 4: {
                                    List<Long> v8 = data;
                                    Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                    yield INSTANCE.numberToStringList(TypeIntrinsics.asMutableList((Object)v8));
                                }
                            }
                            yield data;
                        }
                        case 2 -> {
                            switch (WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()]) {
                                case 3: {
                                    List<Long> v9 = data;
                                    Intrinsics.checkNotNull((Object)v9, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                    yield INSTANCE.numberToDoubleList(TypeIntrinsics.asMutableList((Object)v9));
                                }
                                case 4: {
                                    List<Long> v10 = data;
                                    Intrinsics.checkNotNull((Object)v10, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                    yield INSTANCE.numberToStringList(TypeIntrinsics.asMutableList((Object)v10));
                                }
                            }
                            yield data;
                        }
                        case 3 -> {
                            if (WhenMappings.$EnumSwitchMapping$0[valueType.ordinal()] == 4) {
                                List<Long> v11 = data;
                                Intrinsics.checkNotNull((Object)v11, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Number?>");
                                yield INSTANCE.numberToStringList(TypeIntrinsics.asMutableList(v11));
                            }
                            yield data;
                        }
                        default -> data;
                    };
                    dataType = valueType;
                    valueType = INSTANCE.addValue(dataType, data, value);
                }
                if (valueType == dataType) continue;
                throw new InvalidDataException("Cannot put " + value + " to the column of type " + (Object)((Object)dataType));
            }
            Column dataframeColumn = switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1 -> {
                    String v12 = column.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getName(...)");
                    List<Long> v13 = data;
                    Intrinsics.checkNotNull((Object)v13, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Int?>");
                    yield (Column)new IntColumn(v12, TypeIntrinsics.asMutableList((Object)v13));
                }
                case 2 -> {
                    String v15 = column.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"getName(...)");
                    List<Long> v16 = data;
                    Intrinsics.checkNotNull((Object)v16, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Long?>");
                    yield (Column)new LongColumn(v15, TypeIntrinsics.asMutableList((Object)v16));
                }
                case 3 -> {
                    String v17 = column.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"getName(...)");
                    List<Long> v18 = data;
                    Intrinsics.checkNotNull((Object)v18, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Double?>");
                    yield (Column)new DoubleColumn(v17, TypeIntrinsics.asMutableList((Object)v18));
                }
                default -> {
                    String v19 = column.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getName(...)");
                    List<Long> v20 = data;
                    Intrinsics.checkNotNull((Object)v20, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String?>");
                    yield (Column)new StringColumn(v19, TypeIntrinsics.asMutableList((Object)v20));
                }
            };
            ((Collection)dataframeColumns).add(dataframeColumn);
        }
        return (DataFrame)new DataFrameImpl(dataframeColumns);
    }

    private final ValueType getDataType(Object value) {
        Object object = value;
        return object == null ? ValueType.INT : (object instanceof Integer ? ValueType.INT : (object instanceof String ? (StringsKt.toIntOrNull((String)((String)value)) != null ? ValueType.INT : (StringsKt.toDoubleOrNull((String)((String)value)) != null ? ValueType.DOUBLE : ValueType.STRING)) : (object instanceof Long ? ValueType.LONG : (object instanceof Double ? ValueType.DOUBLE : (object instanceof BigDecimal ? ValueType.DOUBLE : (object instanceof Short ? ValueType.INT : (object instanceof Byte ? ValueType.INT : (object instanceof Float ? ValueType.DOUBLE : (object instanceof Number ? ValueType.DOUBLE : ValueType.STRING)))))))));
    }

    private final ValueType addToStringColumn(List<String> data, Object value) {
        Object object = value;
        if (object == null) {
            data.add(null);
        } else if (object instanceof String) {
            data.add((String)value);
        } else {
            data.add(value.toString());
        }
        return ValueType.STRING;
    }

    private final ValueType addToIntColumn(List<Integer> data, Object value) {
        Integer intValue;
        Object object = value;
        boolean bl = object == null ? data.add(null) : (object instanceof Integer ? data.add((Integer)value) : (object instanceof String ? ((intValue = StringsKt.toIntOrNull((String)((String)value))) == null ? false : data.add(intValue)) : (object instanceof Short ? data.add(Integer.valueOf(((Number)value).shortValue())) : (object instanceof Byte ? data.add(Integer.valueOf(((Number)value).byteValue())) : false))));
        boolean added = bl;
        return added ? ValueType.INT : this.getDataType(value);
    }

    private final ValueType addToLongColumn(List<Long> data, Object value) {
        Long longValue;
        Object object = value;
        boolean bl = object == null ? data.add(null) : (object instanceof Long ? data.add((Long)value) : (object instanceof String ? ((longValue = StringsKt.toLongOrNull((String)((String)value))) == null ? false : data.add(longValue)) : (object instanceof Integer ? data.add(Long.valueOf(((Number)value).intValue())) : (object instanceof Short ? data.add(Long.valueOf(((Number)value).shortValue())) : (object instanceof Byte ? data.add(Long.valueOf(((Number)value).byteValue())) : false)))));
        boolean added = bl;
        return added ? ValueType.LONG : this.getDataType(value);
    }

    private final ValueType addToDoubleColumn(List<Double> data, Object value) {
        Double doubleValue;
        Object object = value;
        boolean bl = object == null ? data.add(null) : (object instanceof Double ? data.add((Double)value) : (object instanceof String ? ((doubleValue = StringsKt.toDoubleOrNull((String)((String)value))) == null ? false : data.add(doubleValue)) : (object instanceof Float ? data.add(Double.valueOf(((Number)value).floatValue())) : (object instanceof Integer ? data.add(Double.valueOf(((Number)value).intValue())) : (object instanceof Long ? data.add(Double.valueOf(((Number)value).longValue())) : (object instanceof Short ? data.add(Double.valueOf(((Number)value).shortValue())) : (object instanceof Byte ? data.add(Double.valueOf(((Number)value).byteValue())) : (object instanceof Number ? data.add(((Number)value).doubleValue()) : false))))))));
        boolean added = bl;
        return added ? ValueType.DOUBLE : this.getDataType(value);
    }

    private final List<Long> numberToLongList(List<Number> data) {
        ArrayList result = new ArrayList(data.size());
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Number it = (Number)element$iv;
            boolean bl = false;
            Number number = it;
            ((Collection)result).add(number != null ? Long.valueOf(number.longValue()) : null);
        }
        return result;
    }

    private final List<Double> numberToDoubleList(List<Number> data) {
        ArrayList result = new ArrayList(data.size());
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Number it = (Number)element$iv;
            boolean bl = false;
            Number number = it;
            ((Collection)result).add(number != null ? Double.valueOf(number.doubleValue()) : null);
        }
        return result;
    }

    private final List<String> numberToStringList(List<Number> data) {
        ArrayList result = new ArrayList(data.size());
        Iterable $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Number it = (Number)element$iv;
            boolean bl = false;
            Number number = it;
            ((Collection)result).add(number != null ? number.toString() : null);
        }
        return result;
    }

    private final ValueType addValue(ValueType dataType, List<?> data, Object value) {
        return switch (WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Int?>");
                yield this.addToIntColumn(TypeIntrinsics.asMutableList(data), value);
            }
            case 2 -> {
                Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Long?>");
                yield this.addToLongColumn(TypeIntrinsics.asMutableList(data), value);
            }
            case 3 -> {
                Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Double?>");
                yield this.addToDoubleColumn(TypeIntrinsics.asMutableList(data), value);
            }
            default -> {
                Intrinsics.checkNotNull(data, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String?>");
                yield this.addToStringColumn(TypeIntrinsics.asMutableList(data), value);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/datagrid/DataGridConversionUtil$ValueType;", "", "(Ljava/lang/String;I)V", "INT", "LONG", "DOUBLE", "STRING", "intellij.grid.impl"})
    private static final class ValueType
    extends Enum<ValueType> {
        public static final /* enum */ ValueType INT = new ValueType();
        public static final /* enum */ ValueType LONG = new ValueType();
        public static final /* enum */ ValueType DOUBLE = new ValueType();
        public static final /* enum */ ValueType STRING = new ValueType();
        private static final /* synthetic */ ValueType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String value) {
            return Enum.valueOf(ValueType.class, value);
        }

        @NotNull
        public static EnumEntries<ValueType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = valueTypeArray = new ValueType[]{ValueType.INT, ValueType.LONG, ValueType.DOUBLE, ValueType.STRING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.STRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

