/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.ValueTabInfoProvider;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowEditMaximizedAction
extends DumbAwareAction {
    private static final String EDIT_MAXIMIZED_POSITION = "EditMaximizedView.POSITION";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(1);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean inCell = DataGridUIUtil.inCell(grid, e);
        if (inCell) {
            Object value = DataGridUIUtil.getLeadSelectionCellValue(grid, e, false);
            e.getPresentation().setText(value instanceof ImageInfo ? DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.view.image", (Object[])new Object[0]) : DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.maximize", (Object[])new Object[0]));
        } else {
            e.getPresentation().setText(DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.text", (Object[])new Object[0]));
        }
        EditMaximizedView editMaximized = EditMaximizedViewKt.findEditMaximized(e.getDataContext());
        boolean visible = editMaximized != null && editMaximized.getCurrentTabInfoProvider() instanceof ValueTabInfoProvider;
        e.getPresentation().setEnabledAndVisible(inCell || !visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        EditMaximizedView view = ShowEditMaximizedAction.getView(grid, e);
        view.open((Function1<? super TabInfoProvider, Boolean>)((Function1)tabInfoProvider -> tabInfoProvider instanceof ValueTabInfoProvider));
        if (grid.isEditable()) {
            EditorCellViewer cellViewer;
            JComponent focusComponent = view.getPreferedFocusComponent();
            if (focusComponent != null) {
                focusComponent.requestFocus();
            }
            if ((cellViewer = (EditorCellViewer)ObjectUtils.tryCast((Object)view.getCurrentTabInfoProvider().getViewer(), EditorCellViewer.class)) != null) {
                cellViewer.selectAll();
            }
        }
    }

    public static EditMaximizedView getView(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        EditMaximizedView view;
        if (grid == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(4);
        }
        if ((view = EditMaximizedViewKt.findEditMaximized(e.getDataContext())) == null) {
            view = new EditMaximizedView(grid);
            Disposer.register((Disposable)grid, (Disposable)view);
            ShowEditMaximizedAction.getPosition().set(grid, view);
        }
        return view;
    }

    public static void savePosition(@NotNull Position position) {
        if (position == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance().setValue(EDIT_MAXIMIZED_POSITION, position.name());
    }

    @Nullable
    public static Position getPosition(@NotNull DataGrid grid, @Nullable EditMaximizedView view) {
        if (grid == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(6);
        }
        GridPanel panel2 = grid.getPanel();
        if (view != null) {
            return panel2.getRightView() == view.getComponent() ? Position.RIGHT : (panel2.getBottomView() == view.getComponent() ? Position.BOTTOM : null);
        }
        return panel2.getRightView() != null ? Position.RIGHT : (panel2.getBottomView() != null ? Position.BOTTOM : null);
    }

    @NotNull
    public static Position getPosition() {
        String name;
        block6: {
            Position position;
            try {
                name = PropertiesComponent.getInstance().getValue(EDIT_MAXIMIZED_POSITION);
                if (name != null) break block6;
                position = Position.RIGHT;
            }
            catch (IllegalArgumentException e) {
                Position position2 = Position.RIGHT;
                if (position2 == null) {
                    ShowEditMaximizedAction.$$$reportNull$$$0(9);
                }
                return position2;
            }
            if (position == null) {
                ShowEditMaximizedAction.$$$reportNull$$$0(7);
            }
            return position;
        }
        Position position = Position.valueOf(name);
        if (position == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(8);
        }
        return position;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "savePosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Position {
        RIGHT{

            @Override
            public void set(@NotNull DataGrid grid, @Nullable EditMaximizedView view) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                grid.getPanel().setRightView(view == null ? null : view.getComponent());
            }

            @Override
            @Nullable
            public EditMaximizedView get(@NotNull DataGrid grid) {
                EditMaximizedView view;
                if (grid == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (view = (EditMaximizedView)grid.getUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY)) != null && grid.getPanel().getRightView() == view.getComponent() ? view : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "grid";
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction$Position$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "get";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        BOTTOM{

            @Override
            public void set(@NotNull DataGrid grid, @Nullable EditMaximizedView view) {
                if (grid == null) {
                    2.$$$reportNull$$$0(0);
                }
                grid.getPanel().setBottomView(view == null ? null : view.getComponent());
            }

            @Override
            @Nullable
            public EditMaximizedView get(@NotNull DataGrid grid) {
                EditMaximizedView view;
                if (grid == null) {
                    2.$$$reportNull$$$0(1);
                }
                return (view = (EditMaximizedView)grid.getUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY)) != null && grid.getPanel().getBottomView() == view.getComponent() ? view : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "grid";
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction$Position$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "get";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract void set(@NotNull DataGrid var1, @Nullable EditMaximizedView var2);

        @Nullable
        public abstract EditMaximizedView get(@NotNull DataGrid var1);
    }
}

