/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.bigdatatools.visualization.charts.analyser.SeriesSuggester;
import com.intellij.bigdatatools.visualization.charts.core.ChartPage;
import com.intellij.bigdatatools.visualization.charts.core.ChartPageKt;
import com.intellij.bigdatatools.visualization.charts.core.axes.settings.AxesSettings;
import com.intellij.bigdatatools.visualization.charts.core.settings.ChartSettings;
import com.intellij.bigdatatools.visualization.charts.settings.SeriesSettingsPanel;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.ShowChartUnderTableAction;
import com.intellij.database.actions.ShowEditMaximizedAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridConversionUtil;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/actions/ShowChartUnderTableAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "showChart", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "update", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nShowChartUnderTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/database/actions/ShowChartUnderTableAction\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,137:1\n52#2:138\n*S KotlinDebug\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/database/actions/ShowChartUnderTableAction\n*L\n46#1:138\n*E\n"})
public final class ShowChartUnderTableAction
extends DumbAwareToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> CHART_UPDATE_SCHEDULED = new Key("CHART_UPDATE_SCHEDULED");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && Registry.is((String)"database.grid.show.chart.tab"));
        super.update(e);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent e) {
        ChartPage chartPage;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return false;
        }
        DataGrid grid = dataGrid;
        JComponent jComponent = grid.getPanel().getBottomView();
        if (jComponent != null) {
            void $this$getUserData$iv;
            JComponent jComponent2 = jComponent;
            Key key$iv = ChartPageKt.getCHART_PAGE_KEY();
            boolean $i$f$getUserData = false;
            Object object = $this$getUserData$iv.getClientProperty(key$iv);
            if (!(object instanceof ChartPage)) {
                object = null;
            }
            chartPage = (ChartPage)object;
        } else {
            chartPage = null;
        }
        return chartPage != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return;
        }
        DataGrid grid = dataGrid;
        if (state) {
            this.showChart(grid);
        } else {
            Companion.hideChart(grid);
        }
    }

    private final void showChart(DataGrid grid) {
        ChartPage chartPage;
        Companion.hideChart(grid);
        DataFrame dataFrame = DataGridConversionUtil.INSTANCE.getDataFrame(grid);
        List settings = SeriesSuggester.INSTANCE.getSingleSuggestion(dataFrame);
        ChartPage $this$showChart_u24lambda_u240 = chartPage = new ChartPage(new ChartSettings(new AxesSettings(false, false, 3, null), settings), SeriesSettingsPanel.Mode.WITHOUT_COLUMNS_LIST);
        boolean bl = false;
        $this$showChart_u24lambda_u240.assignDataFrame(dataFrame);
        ShowChartUnderTableAction.Companion.addChartToolbar($this$showChart_u24lambda_u240);
        $this$showChart_u24lambda_u240.getComponent().setBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)2));
        ChartPage chartPage2 = chartPage;
        UiUtils.putUserData((JComponent)chartPage2.getComponent(), (Key)ChartPageKt.getCHART_PAGE_KEY(), (Object)chartPage2);
        Disposer.register((Disposable)((Disposable)grid), (Disposable)((Disposable)chartPage2));
        Companion.addGridContentListener(grid, chartPage2);
        ShowChartUnderTableAction.Companion.fixValueEditor(grid);
        grid.getPanel().setBottomView(chartPage2.getComponent());
    }

    public static final /* synthetic */ Key access$getCHART_UPDATE_SCHEDULED$cp() {
        return CHART_UPDATE_SCHEDULED;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/ShowChartUnderTableAction$Companion;", "", "()V", "CHART_UPDATE_SCHEDULED", "Lcom/intellij/openapi/util/Key;", "", "addChartToolbar", "", "chartPage", "Lcom/intellij/bigdatatools/visualization/charts/core/ChartPage;", "addGridContentListener", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "fixValueEditor", "hideChart", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nShowChartUnderTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/database/actions/ShowChartUnderTableAction$Companion\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,137:1\n52#2:138\n*S KotlinDebug\n*F\n+ 1 ShowChartUnderTableAction.kt\ncom/intellij/database/actions/ShowChartUnderTableAction$Companion\n*L\n121#1:138\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addGridContentListener(@NotNull DataGrid grid, @NotNull ChartPage chartPage) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)chartPage, (String)"chartPage");
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            CheckedDisposable checkedDisposable2 = checkedDisposable;
            Disposer.register((Disposable)((Disposable)chartPage), (Disposable)((Disposable)checkedDisposable2));
            grid.addDataGridListener(new DataGridListener(checkedDisposable2, chartPage, grid){
                final /* synthetic */ CheckedDisposable $checkedDisposable;
                final /* synthetic */ ChartPage $chartPage;
                final /* synthetic */ DataGrid $grid;
                {
                    this.$checkedDisposable = $checkedDisposable;
                    this.$chartPage = $chartPage;
                    this.$grid = $grid;
                }

                public void onContentChanged(@NotNull DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
                    Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                    if (Intrinsics.areEqual((Object)dataGrid.getUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp()), (Object)true)) {
                        return;
                    }
                    dataGrid.putUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp(), true);
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> addGridContentListener.1.onContentChanged$lambda$1(this.$checkedDisposable, dataGrid, this.$chartPage, this.$grid), 200L, TimeUnit.MILLISECONDS);
                }

                private static final void onContentChanged$lambda$1$lambda$0(ChartPage $chartPage, DataGrid $grid) {
                    Intrinsics.checkNotNullParameter((Object)$chartPage, (String)"$chartPage");
                    Intrinsics.checkNotNullParameter((Object)$grid, (String)"$grid");
                    $chartPage.assignDataFrame(DataGridConversionUtil.INSTANCE.getDataFrame($grid));
                }

                private static final void onContentChanged$lambda$1(CheckedDisposable $checkedDisposable, DataGrid $dataGrid, ChartPage $chartPage, DataGrid $grid) {
                    Intrinsics.checkNotNullParameter((Object)$checkedDisposable, (String)"$checkedDisposable");
                    Intrinsics.checkNotNullParameter((Object)$dataGrid, (String)"$dataGrid");
                    Intrinsics.checkNotNullParameter((Object)$chartPage, (String)"$chartPage");
                    Intrinsics.checkNotNullParameter((Object)$grid, (String)"$grid");
                    if (!$checkedDisposable.isDisposed()) {
                        ApplicationManager.getApplication().invokeLater(() -> addGridContentListener.1.onContentChanged$lambda$1$lambda$0($chartPage, $grid));
                    }
                    $dataGrid.putUserData(ShowChartUnderTableAction.access$getCHART_UPDATE_SCHEDULED$cp(), false);
                }
            }, (Disposable)chartPage);
        }

        private final void addChartToolbar(ChartPage chartPage) {
            ActionToolbar actionToolbar2;
            ActionManager actionManager = ActionManager.getInstance();
            ActionToolbar $this$addChartToolbar_u24lambda_u240 = actionToolbar2 = actionManager.createActionToolbar("BDTChartToolbar", (ActionGroup)new DefaultActionGroup(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)actionManager.getAction("Console.TableResult.CloseChart")), (Iterable)chartPage.createActions())), false);
            boolean bl = false;
            $this$addChartToolbar_u24lambda_u240.getComponent().setOpaque(false);
            ActionToolbar actionToolbar3 = actionToolbar2;
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar3, (String)"apply(...)");
            ActionToolbar chartToolbar = actionToolbar3;
            chartToolbar.setTargetComponent((JComponent)chartPage.getComponent());
            chartPage.getComponent().add((Component)chartToolbar.getComponent(), "East");
        }

        /*
         * WARNING - void declaration
         */
        public final void hideChart(@NotNull DataGrid grid) {
            JComponent jComponent;
            block5: {
                block4: {
                    void $this$getUserData$iv;
                    Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
                    jComponent = grid.getPanel().getBottomView();
                    if (jComponent == null) break block4;
                    JComponent jComponent2 = jComponent;
                    Key key$iv = ChartPageKt.getCHART_PAGE_KEY();
                    boolean $i$f$getUserData = false;
                    Object object = $this$getUserData$iv.getClientProperty(key$iv);
                    if (!(object instanceof ChartPage)) {
                        object = null;
                    }
                    if ((jComponent = (ChartPage)object) != null) break block5;
                }
                return;
            }
            JComponent chartPage = jComponent;
            grid.getPanel().setBottomView(null);
            Disposer.dispose((Disposable)((Disposable)chartPage));
        }

        private final void fixValueEditor(DataGrid grid) {
            EditMaximizedView editMaximizedView = (EditMaximizedView)grid.getUserData(EditMaximizedViewKt.EDIT_MAXIMIZED_GRID_KEY);
            if (editMaximizedView == null) {
                return;
            }
            EditMaximizedView view = editMaximizedView;
            ShowEditMaximizedAction.Position position = ShowEditMaximizedAction.getPosition(grid, view);
            if (position == ShowEditMaximizedAction.Position.BOTTOM) {
                ShowEditMaximizedAction.Position.RIGHT.set(grid, view);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

