/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.cloneDialog.GHCloneDialogExtensionComponentBase;
import org.jetbrains.plugins.github.ui.cloneDialog.GHECloneDialogExtensionKt;
import org.jetbrains.plugins.github.ui.cloneDialog.GHECloneDialogLoginPanel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHECloneDialogExtensionComponent;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHCloneDialogExtensionComponentBase;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "createAccountMenuLoginActions", "", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItem$Action;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "createLoginAction", "createLoginPanel", "Ljavax/swing/JComponent;", "cs", "cancelHandler", "Lkotlin/Function0;", "", "isAccountHandled", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHECloneDialogExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHECloneDialogExtension.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHECloneDialogExtensionComponent\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,90:1\n40#2,3:91\n*S KotlinDebug\n*F\n+ 1 GHECloneDialogExtension.kt\norg/jetbrains/plugins/github/ui/cloneDialog/GHECloneDialogExtensionComponent\n*L\n42#1:91,3\n*E\n"})
final class GHECloneDialogExtensionComponent
extends GHCloneDialogExtensionComponentBase {
    public GHECloneDialogExtensionComponent(@NotNull Project project, @NotNull CoroutineScope parentCs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        super(project, parentCs, (GHAccountManager)((Object)object));
    }

    @Override
    protected boolean isAccountHandled(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        return GHECloneDialogExtensionKt.access$isGHEAccount(account);
    }

    @Override
    @NotNull
    protected JComponent createLoginPanel(@NotNull CoroutineScope cs, @Nullable GithubAccount account, @NotNull Function0<Unit> cancelHandler) {
        GHECloneDialogLoginPanel gHECloneDialogLoginPanel;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter(cancelHandler, (String)"cancelHandler");
        GHECloneDialogLoginPanel $this$createLoginPanel_u24lambda_u240 = gHECloneDialogLoginPanel = new GHECloneDialogLoginPanel(cs, account);
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)$this$createLoginPanel_u24lambda_u240);
        $this$createLoginPanel_u24lambda_u240.getLoginPanel().setCancelVisible(!((Collection)this.getAccounts()).isEmpty());
        $this$createLoginPanel_u24lambda_u240.getLoginPanel().setCancelHandler(cancelHandler);
        return (JComponent)((Object)gHECloneDialogLoginPanel);
    }

    @Override
    @NotNull
    protected Collection<AccountMenuItem.Action> createAccountMenuLoginActions(@Nullable GithubAccount account) {
        return CollectionsKt.listOf((Object)this.createLoginAction(account));
    }

    private final AccountMenuItem.Action createLoginAction(GithubAccount account) {
        boolean isExistingAccount = account != null;
        String string = GithubBundle.message("login.to.github.enterprise.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new AccountMenuItem.Action(string, (Function0)new Function0<Unit>(this, account){
            final /* synthetic */ GHECloneDialogExtensionComponent this$0;
            final /* synthetic */ GithubAccount $account;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                super(0);
            }

            public final void invoke() {
                this.this$0.switchToLogin(this.$account);
            }
        }, null, !isExistingAccount, 4, null);
    }
}

