/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.list;

import com.intellij.collaboration.ui.codereview.avatar.CodeReviewAvatarUtils;
import com.intellij.collaboration.ui.codereview.details.ReviewDetailsUIUtil;
import com.intellij.collaboration.ui.codereview.details.data.ReviewState;
import com.intellij.collaboration.ui.codereview.list.NamedCollection;
import com.intellij.collaboration.ui.codereview.list.ReviewListComponentFactory;
import com.intellij.collaboration.ui.codereview.list.ReviewListItemPresentation;
import com.intellij.collaboration.ui.codereview.list.TagPresentation;
import com.intellij.collaboration.ui.codereview.list.UserPresentation;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import icons.CollaborationToolsIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestMergeableState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRequestedReviewer;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRPersistentInteractionState;
import org.jetbrains.plugins.github.pullrequest.ui.GHReviewersUtils;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GithubSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J,\u0010\u0011\u001a\u00020\u00122\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u0010\u0013\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J0\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001e2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001e2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u001f\u0010)\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J2\u0010/\u001a\u0002002\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u00101\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory;", "", "interactionStateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;", "listModel", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRPersistentInteractionState;Ljavax/swing/ListModel;)V", "create", "Lcom/intellij/ui/components/JBList;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "currentUser", "createUserPresentation", "Lcom/intellij/collaboration/ui/codereview/list/UserPresentation;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRequestedReviewer;", "reviewState", "Lcom/intellij/collaboration/ui/codereview/details/data/ReviewState;", "createUserPresentationByFilter", "", "reviewsByReviewers", "", "reviewStateFilter", "getAssigneesPresentation", "Lcom/intellij/collaboration/ui/codereview/list/NamedCollection;", "assignees", "getLabelPresentation", "Lcom/intellij/collaboration/ui/codereview/list/TagPresentation$Simple;", "label", "Lorg/jetbrains/plugins/github/api/data/GHLabel;", "getMergeableStatus", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Status;", "mergeableState", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestMergeableState;", "getReviewersPresentation", "getStateText", "Lcom/intellij/openapi/util/NlsSafe;", "state", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestState;", "isDraft", "", "presentPR", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation;", "pr", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRListComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRListComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,149:1\n1549#2:150\n1620#2,3:151\n1603#2,9:154\n1855#2:163\n1856#2:165\n1612#2:166\n1549#2:167\n1620#2,3:168\n1549#2:178\n1620#2,3:179\n1#3:164\n1#3:182\n494#4,7:171\n*S KotlinDebug\n*F\n+ 1 GHPRListComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/list/GHPRListComponentFactory\n*L\n64#1:150\n64#1:151,3\n73#1:154,9\n73#1:163\n73#1:165\n73#1:166\n105#1:167\n105#1:168,3\n132#1:178\n132#1:179,3\n73#1:164\n130#1:171,7\n*E\n"})
public final class GHPRListComponentFactory {
    @NotNull
    private final GHPRPersistentInteractionState interactionStateService;
    @NotNull
    private final ListModel<GHPullRequestShort> listModel;

    public GHPRListComponentFactory(@NotNull GHPRPersistentInteractionState interactionStateService, @NotNull ListModel<GHPullRequestShort> listModel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)interactionStateService), (String)"interactionStateService");
        Intrinsics.checkNotNullParameter(listModel2, (String)"listModel");
        this.interactionStateService = interactionStateService;
        this.listModel = listModel2;
    }

    @NotNull
    public final JBList<GHPullRequestShort> create(@NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHUser ghostUser, @NotNull GHUser currentUser) {
        JBList jBList;
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)ghostUser, (String)"ghostUser");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        JBList it = jBList = new ReviewListComponentFactory(this.listModel).create((Function1)new Function1<GHPullRequestShort, ReviewListItemPresentation>(this, avatarIconsProvider, ghostUser, currentUser){
            final /* synthetic */ GHPRListComponentFactory this$0;
            final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
            final /* synthetic */ GHUser $ghostUser;
            final /* synthetic */ GHUser $currentUser;
            {
                this.this$0 = $receiver;
                this.$avatarIconsProvider = $avatarIconsProvider;
                this.$ghostUser = $ghostUser;
                this.$currentUser = $currentUser;
                super(1);
            }

            @NotNull
            public final ReviewListItemPresentation invoke(@NotNull GHPullRequestShort it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRListComponentFactory.access$presentPR(this.this$0, this.$avatarIconsProvider, it, this.$ghostUser, this.$currentUser);
            }
        });
        boolean bl = false;
        DataManager.registerDataProvider((JComponent)((JComponent)it), arg_0 -> GHPRListComponentFactory.create$lambda$1$lambda$0(it, arg_0));
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.ToolWindow.List.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        PopupHandler.installPopupMenu((JComponent)((JComponent)it), (ActionGroup)actionGroup, (String)"popup");
        ShortcutSet[] shortcutSetArray = new ShortcutSet[]{CommonShortcuts.ENTER, CommonShortcuts.DOUBLE_CLICK_1};
        CompositeShortcutSet shortcuts = new CompositeShortcutSet(shortcutSetArray);
        ActionUtil.wrap((String)"Github.PullRequest.Show").registerCustomShortcutSet((ShortcutSet)shortcuts, (JComponent)it);
        return jBList;
    }

    /*
     * WARNING - void declaration
     */
    private final ReviewListItemPresentation presentPR(IconsProvider<String> avatarIconsProvider, GHPullRequestShort pr, GHUser ghostUser, GHUser currentUser) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection<TagPresentation.Simple> collection;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean isUnreadDotEnabled = GithubSettings.getInstance().isSeenMarkersEnabled();
        String string = pr.getTitle();
        String string2 = "#" + pr.getNumber();
        Date date = pr.getCreatedAt();
        UserPresentation userPresentation = this.createUserPresentation(avatarIconsProvider, pr.getAuthor());
        Object[] objectArray = new Object[]{pr.getLabels().size()};
        String string3 = GithubBundle.message("pull.request.labels.popup", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Iterable iterable = pr.getLabels();
        String string4 = string3;
        NamedCollection.Companion companion = NamedCollection.Companion;
        UserPresentation userPresentation2 = userPresentation;
        Date date2 = date;
        String string5 = string2;
        String string6 = string;
        boolean $i$f$map = false;
        void var8_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (GHLabel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getLabelPresentation((GHLabel)p0));
        }
        collection = (List)destination$iv$iv;
        NamedCollection namedCollection = companion.create(string4, (List)collection);
        $this$map$iv = pr.getReviewRequests();
        List<GHPullRequestReview> list = pr.getReviews();
        GHActor gHActor = pr.getAuthor();
        GHReviewersUtils gHReviewersUtils = GHReviewersUtils.INSTANCE;
        IconsProvider<String> iconsProvider = avatarIconsProvider;
        GHPRListComponentFactory gHPRListComponentFactory = this;
        NamedCollection<UserPresentation> namedCollection2 = this.getAssigneesPresentation(avatarIconsProvider, pr.getAssignees());
        String string7 = this.getStateText(pr.getState(), pr.isDraft());
        collection = null;
        string4 = this.getMergeableStatus(pr.getMergeable());
        companion = namedCollection;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            GHPullRequestRequestedReviewer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            GHPullRequestReviewRequest p0 = (GHPullRequestReviewRequest)element$iv$iv;
            boolean bl2 = false;
            if (p0.getRequestedReviewer() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        NamedCollection<UserPresentation> namedCollection3 = gHPRListComponentFactory.getReviewersPresentation(iconsProvider, gHReviewersUtils.getReviewsByReviewers(gHActor, list, list2, ghostUser));
        int n = pr.getUnresolvedReviewThreadsCount();
        Object[] objectArray2 = new Object[]{pr.getUnresolvedReviewThreadsCount()};
        String string8 = GithubBundle.message("pull.request.unresolved.comments", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 64;
        Boolean bl = isUnreadDotEnabled ? Boolean.valueOf(this.interactionStateService.isSeen(pr, currentUser)) : null;
        ReviewListItemPresentation.CommentsCounter commentsCounter = new ReviewListItemPresentation.CommentsCounter(n, string8);
        NamedCollection<UserPresentation> namedCollection4 = namedCollection3;
        NamedCollection<UserPresentation> namedCollection5 = namedCollection2;
        String string9 = string7;
        Collection<TagPresentation.Simple> collection2 = collection;
        String string10 = string4;
        NamedCollection.Companion companion2 = companion;
        UserPresentation userPresentation3 = userPresentation2;
        Date date3 = date2;
        String string11 = string5;
        String string12 = string6;
        return (ReviewListItemPresentation)new ReviewListItemPresentation.Simple(string12, string11, date3, userPresentation3, (NamedCollection)companion2, (ReviewListItemPresentation.Status)string10, collection2, string9, namedCollection5, namedCollection4, commentsCounter, bl, n2, defaultConstructorMarker);
    }

    private final TagPresentation.Simple getLabelPresentation(GHLabel label) {
        return new TagPresentation.Simple(label.getName(), ColorHexUtil.fromHex((String)label.getColor()));
    }

    private final String getStateText(GHPullRequestState state2, boolean isDraft) {
        if (state2 == GHPullRequestState.OPEN && !isDraft) {
            return null;
        }
        return GHUIUtil.INSTANCE.getPullRequestStateText(state2, isDraft);
    }

    private final ReviewListItemPresentation.Status getMergeableStatus(GHPullRequestMergeableState mergeableState) {
        if (mergeableState == GHPullRequestMergeableState.CONFLICTING) {
            Icon icon = CollaborationToolsIcons.Review.NonMergeable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NonMergeable");
            String string = GithubBundle.message("pull.request.conflicts.merge.tooltip", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ReviewListItemPresentation.Status(icon, string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final NamedCollection<UserPresentation> getAssigneesPresentation(IconsProvider<String> avatarIconsProvider, List<GHUser> assignees) {
        Collection<UserPresentation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Object[]{assignees.size()};
        String string = GithubBundle.message("pull.request.assignees.popup", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Iterable iterable = assignees;
        String string2 = string;
        NamedCollection.Companion companion = NamedCollection.Companion;
        boolean $i$f$map = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            GHUser gHUser = (GHUser)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createUserPresentation(avatarIconsProvider, (GHPullRequestRequestedReviewer)user, null));
        }
        collection = (List)destination$iv$iv;
        return companion.create(string2, (List)collection);
    }

    private final NamedCollection<UserPresentation> getReviewersPresentation(IconsProvider<String> avatarIconsProvider, Map<GHPullRequestRequestedReviewer, ? extends ReviewState> reviewsByReviewers) {
        List presentations = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.createUserPresentationByFilter(avatarIconsProvider, reviewsByReviewers, ReviewState.ACCEPTED), (Iterable)this.createUserPresentationByFilter(avatarIconsProvider, reviewsByReviewers, ReviewState.WAIT_FOR_UPDATES)), (Iterable)this.createUserPresentationByFilter(avatarIconsProvider, reviewsByReviewers, ReviewState.NEED_REVIEW));
        Object[] objectArray = new Object[]{presentations.size()};
        String string = GithubBundle.message("pull.request.reviewers.popup", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return NamedCollection.Companion.create(string, presentations);
    }

    private final UserPresentation createUserPresentation(IconsProvider<String> avatarIconsProvider, GHActor user) {
        if (user == null) {
            return null;
        }
        return (UserPresentation)new UserPresentation.Simple(user.getLogin(), null, avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 20));
    }

    /*
     * WARNING - void declaration
     */
    private final List<UserPresentation> createUserPresentationByFilter(IconsProvider<String> avatarIconsProvider, Map<GHPullRequestRequestedReviewer, ? extends ReviewState> reviewsByReviewers, ReviewState reviewStateFilter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterValues$iv;
        Map<GHPullRequestRequestedReviewer, ? extends ReviewState> map2 = reviewsByReviewers;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            ReviewState reviewState2 = (ReviewState)entry$iv.getValue();
            boolean bl = false;
            if (!(reviewState2 == reviewStateFilter)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void reviewer;
            GHPullRequestRequestedReviewer gHPullRequestRequestedReviewer = (GHPullRequestRequestedReviewer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createUserPresentation(avatarIconsProvider, (GHPullRequestRequestedReviewer)reviewer, reviewStateFilter));
        }
        return (List)destination$iv$iv;
    }

    private final UserPresentation createUserPresentation(IconsProvider<String> avatarIconsProvider, GHPullRequestRequestedReviewer user, ReviewState reviewState2) {
        Color color;
        ReviewState reviewState3 = reviewState2;
        if (reviewState3 != null) {
            ReviewState reviewState4 = reviewState3;
            ReviewDetailsUIUtil reviewDetailsUIUtil = ReviewDetailsUIUtil.INSTANCE;
            ReviewState p0 = reviewState4;
            boolean bl = false;
            color = reviewDetailsUIUtil.getReviewStateIconBorder(p0);
        } else {
            color = null;
        }
        Color outlineColor = color;
        Icon avatarIcon = avatarIconsProvider.getIcon((Object)user.getAvatarUrl(), 18);
        Icon icon = outlineColor == null ? avatarIcon : CodeReviewAvatarUtils.INSTANCE.createIconWithOutline(avatarIcon, outlineColor);
        return (UserPresentation)new UserPresentation.Simple(user.getShortName(), user.getName(), icon);
    }

    private static final Object create$lambda$1$lambda$0(JBList $it, String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (GHPRActionKeys.getPULL_REQUEST_ID().is(dataId)) {
            GHPullRequestShort gHPullRequestShort = (GHPullRequestShort)$it.getSelectedValue();
            object = gHPullRequestShort != null ? gHPullRequestShort.getPrId() : null;
        } else if (GHPRActionKeys.getPULL_REQUEST_URL().is(dataId)) {
            GHPullRequestShort gHPullRequestShort = (GHPullRequestShort)$it.getSelectedValue();
            object = gHPullRequestShort != null ? gHPullRequestShort.getUrl() : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final /* synthetic */ ReviewListItemPresentation access$presentPR(GHPRListComponentFactory $this, IconsProvider avatarIconsProvider, GHPullRequestShort pr, GHUser ghostUser, GHUser currentUser) {
        return $this.presentPR((IconsProvider<String>)avatarIconsProvider, pr, ghostUser, currentUser);
    }
}

